package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * Defines a plot data for trending analysis. 
 * @author LSST CCS Team
 */
@XmlRootElement(name = "plotdata")
public class TrendingPlotData implements Serializable {
    private static final long serialVersionUID = 8626269723099001441L;
    
    /**
     * The associated datadesc id.
     */
    private long id;
    
    /**
     * Encoded plot data.
     */
    private String plotData;
    
    /**
     * The time this plot was sent.
     */
    private long time;
    
    public TrendingPlotData() {
        
    }
    
    @XmlElement
    public long getId() {
        return id;
    }
    
    public void setId(long id) {
        this.id = id;
    }
    
    @XmlElement(name = "plotdata")
    public String getPlotData() {
        return plotData;
    }
    
    public void setPlotData(String plotData) {
        this.plotData = plotData;
    }
    
    @XmlElement
    public long getTime() {
        return time;
    }

    public void setTime(long time) {
        this.time = time;
    }
    
    // wrapper class to get the correct collection name
    @XmlRootElement(name="trendingplots")
    public static class TrendingPlotDataList {
        @XmlElement(name="plotdata")
        public List<TrendingPlotData> list;
        
        public TrendingPlotDataList(List<TrendingPlotData> list) {
            this.list = list;
        }
        
        public TrendingPlotDataList() {}
    }
}
