package org.lsst.ccs.localdb.configdb.model;

import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;

/**
 * Represents the static information of a configuration parameter.
 * @author bamade
 */

@Entity
@Immutable
@Table(uniqueConstraints = {
    @UniqueConstraint(columnNames = {"agentName", "componentName", "parameterName", "typeName", "category"})})
public class ConfigurationParameter implements Serializable, PathObject {

    private static final long serialVersionUID = 5660908759518934491L;
    
    private long id ;
    
    private String agentName;
    
    ParameterPath parameterPath ;
    /**
     * type of parameter: class Name.
     * should have a valueOf(String) method
     */
    String typeName ;
    
    /**
     * possible details.
     */
    protected String descriptionStr ;
    
    /**
     * a user-friendly name: it's up to the config "designer" to make sure it's
     * a unique name otherwise the "pathName" of the parameterBase will be used.
     * Immutable in ghost Data
     */
    //TODO: derived field! Formula is too cumbersome! see hack in code
    private String simpleName;

    private String category;

    /**
     * used for configuration "rights"; a designer may have
     * the right to modify a parameter and an end-user not.
     * when automatically generated from a subsytemdescription
     * the level of all modifiable parameters is set to 10,
     * a parameter which is modifiable by an end-user is  less than 5.
     * Immutable in Ghost Data.
     *
     */
    private int level = 0;
    
    ////////////////////////////// CONSTRUCTORS

    protected ConfigurationParameter() {

    }

    /**
     * @param agentName
     * @param path
     * @param typeName
     * @param description
     * @param simpleName
     * @param category
     * @param level
     */
    public ConfigurationParameter(String agentName, ParameterPath path, String typeName, String description, String simpleName, String category, int level) {
        this.agentName = agentName;
        this.parameterPath = path;
        this.typeName = typeName;
        this.descriptionStr = description;
        this.simpleName = simpleName;
        this.category = category;
        this.level = level;
    }

    //////////////////////////// ACCESSORS/MUTATORS
    @Id
    @GeneratedValue
    public long getId() {
        return id;
    }
    
    protected void setId(long id) {
        this.id = id ;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    
    public ParameterPath getParameterPath() {
        return parameterPath;
    }

    void setParameterPath(ParameterPath parameterPath) {
        this.parameterPath = parameterPath;
        this.simpleName = parameterPath.toString();
    }

    public String getDescriptionStr() {
        return descriptionStr;
    }

    /**
     * this data is not essential to the logic so it is modifiable anyway.
     * @param descriptionStr
     */
    void setDescriptionStr(String descriptionStr) {
        this.descriptionStr = descriptionStr ;
    }

    public String getSimpleName() {
        return simpleName;
    }

    void setSimpleName(String simpleName) {
        // this is a hack : because simpleName is a derived field
        if(this.simpleName == null || "".equals(this.simpleName)) {
            this.simpleName = simpleName;
        }
    }
    
    public String getCategory(){
        return category;
    }
    
    void setCategory(String category){
        this.category = category;
    }

    public int getLevel() {
        return level;
    }

    void setLevel(int level) {
        this.level = level;
    }

    @Override
    @Transient
    public ParameterPath getPath() {
        return parameterPath;
    }

    public String getTypeName() {
        return typeName;
    }
    
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
    
    @Override
    public String toString() {
        return "{" + getId() + ": path=" + parameterPath.toString() + '}';
    }
    
}
