package org.lsst.ccs.localdb.configdb.model;

import javax.persistence.*;

/**
 * A parameter configuration in history.
 * Those can be resuscitated using the <TT>repair</TT> methods of
 * <TT>ConfigFacade</TT>
 * @author bamade
 */
// Date: 11/04/12

@Entity
class PastParameterConfiguration extends ParameterConfiguration {
    
    private static final long serialVersionUID = 1648990234116895047L;
    
    @Id
    private long id;

    @ManyToOne
    private GhostParameterDescription parameterDescription ;

    PastParameterConfiguration() {
    }

    /**
     * creates historic data from a Parameter configuration and the "ghost" corresponding to its description.
     * @param ghostDescription
     * @param oldConfig
     * @throws IllegalArgumentException if ghost and description do not match!
     */
    PastParameterConfiguration(GhostParameterDescription ghostDescription,AParameterConfiguration oldConfig) {
        super(oldConfig.getValue());
        if(oldConfig.getId() == 0L) {
            throw new IllegalArgumentException("trying to create historical data with a non-registered object") ;
        }
        if(ghostDescription.getId() != oldConfig.getDescription().getId()) {
            throw new IllegalArgumentException("description and its ghost with different ids") ;
        }
        this.id = oldConfig.getId() ;
        this.parameterDescription = ghostDescription;
    }

    @Override
    public long getId() {
        return id;
    }

    @Override
    protected void setId(long id) {
        this.id = id ;
    }

    @Override
    public ParameterDescription getDescription() {
        return parameterDescription;
    }

    GhostParameterDescription getParameterDescription() {
        return parameterDescription;
    }

     void setParameterDescription(GhostParameterDescription parameterDescription) {
        this.parameterDescription = parameterDescription;
    }
}
