/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import org.hibernate.annotations.Immutable;

@Embeddable
@Immutable
public class DataPath
implements Serializable {
    private static final long serialVersionUID = -8144353557197597425L;
    protected String agentName;
    protected String dataName;

    public DataPath() {
    }

    public DataPath(String agentName, String dataName) {
        this.agentName = agentName;
        this.dataName = dataName;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public String getDataName() {
        return this.dataName;
    }

    public void setDataName(String dataName) {
        this.dataName = dataName;
    }

    @Transient
    public String getFullKey() {
        return this.agentName + "/" + this.dataName;
    }

    @Transient
    public String[] getPath() {
        String[] namePath = this.getDataName().split("/");
        String[] result = new String[namePath.length + 1];
        result[0] = this.getAgentName();
        for (int i = 1; i < result.length; ++i) {
            result[i] = namePath[i - 1];
        }
        return result;
    }

    public static String encodePath(String[] path) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < path.length; ++i) {
            result.append('/');
            result.append(path[i].replaceAll("/", "\\\\/"));
        }
        return result.toString();
    }

    public static String[] decodePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] elts = path.split("(?<!\\\\)/");
        for (int i = 0; i < elts.length; ++i) {
            elts[i] = elts[i].replaceAll("\\\\/", "/");
        }
        return elts;
    }

    public int hashCode() {
        int hash = 5;
        hash = 13 * hash + Objects.hashCode(this.agentName);
        hash = 13 * hash + Objects.hashCode(this.dataName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataPath other = (DataPath)obj;
        if (!Objects.equals(this.agentName, other.agentName)) {
            return false;
        }
        return Objects.equals(this.dataName, other.dataName);
    }

    public String toString() {
        return this.getFullKey();
    }
}

