/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.trendServer;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.hibernate.Query;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.localdb.statusdb.common.LocaldbTestTemplate;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.trendServer.DataServer;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;

public class TrendServerTest
extends LocaldbTestTemplate {
    private static DataServer ds;
    private static Map<Long, DataChannel> channels;
    private static long tstart;
    private static long tstop;

    @BeforeClass
    public static void initClass() {
        p.setProperty("hibernate.dialect", "org.hibernate.dialect.HSQLDialect");
        p.setProperty("hibernate.connection.driver_class", "org.hsqldb.jdbcDriver");
        p.setProperty("hibernate.connection.url", "jdbc:hsqldb:file:target/test-classes/testtrendserverdb");
        p.setProperty("hibernate.connection.username", "root");
        p.setProperty("hibernate.connection.password", "");
        p.setProperty("hibernate.hbm2ddl.auto", "validate");
        sessionFactory = StatusdbUtils.getSessionFactory((Properties)p);
        ds = new DataServer();
        channels = TrendServerTest.ds.getChannels().list.stream().collect(Collectors.toMap(DataChannel::getId, c -> c));
        Session sess = sessionFactory.openSession();
        Object[] minMax = (Object[])sess.createQuery("select min(rd.time), max(rd.time) from RawData rd").uniqueResult();
        tstart = (Long)minMax[0];
        tstop = (Long)minMax[1];
        sess.close();
    }

    @Test
    public void testGetAvailableStats() throws Exception {
        for (DataChannel dc : channels.values()) {
            Map resMap = ds.getAvailableStats(dc.getId(), tstart, tstop);
            Session sess = sessionFactory.openSession();
            Query q = sess.createQuery("from StatDesc sd where sd.dataDesc.id=:id").setLong("id", dc.getId());
            List resList = q.list();
            Assert.assertEquals((String)"StatDesc size :", (long)resList.size(), (long)resMap.size());
        }
    }
}

