package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import javax.persistence.Cacheable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.QueryHint;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Immutable;

/**
 * A time interval for statistical data. All it has is a start and end time to define the
 * interval. The times are in Epoch milliseconds.
 * 
 */
@Entity
@Table(
        indexes = {@Index(columnList = "startTime"), @Index(columnList = "binWidth")},
        uniqueConstraints = @UniqueConstraint(columnNames = {"startTime","binWidth"})
)
@Cacheable
@Immutable
@org.hibernate.annotations.Cache( 
        usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_WRITE
        ,region = "org.lsst.ccs.localdb.statusdb.model.StatTimeInterval"
)
@NamedQueries ( {
    @NamedQuery (
            name = "findStatTimeInterval",
            //Get the time intervals spanning the span (t_start,t_end). 
            //This means startTime<=t_end and startTime+binWidth>t_start.
            //Which becomes startTime<=t_end amd startTime>t_start-binWidth.
            //Or startTime<=t2 and statTime>t1 where t2=t_end and t1=t_start-binWidth
            query = "from StatTimeInterval ti where ti.binWidth=:binWidth and ti.startTime<=:t2 and ti.startTime>:t1",
            hints = {@QueryHint(name="org.hibernate.cacheable", value="true")}
    )
})
public class StatTimeInterval implements Serializable {

    private long id;
    private long startTime;
    private long binWidth;

    public StatTimeInterval() {
    }

    public StatTimeInterval(long startTime, long binWidth) {
        this.startTime = startTime;
        this.binWidth = binWidth;
    }

    /**
     * @return the id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public long getId() {
        return id;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(long id) {
        this.id = id;
    }


    /**
     * @return the startTime
     */
    public long getStartTime() {
        return startTime;
    }

    /**
     * @param startTime
     *            the startTime to set
     */
    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    /**
     * @return the endTime
     */
    @Transient
    public long getEndTime() {
        return startTime+binWidth;
    }

    public long getBinWidth() {
        return binWidth;
    }
    
    public void setBinWidth(long binWidth) {
        this.binWidth = binWidth;
    }

}
