package org.lsst.ccs.localdb.statusdb.model;

import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name = "statdata")
public class StatData {

    static Logger log = Logger.getLogger("org.lsst.ccs.localdb");
    private long id;
    private StatDesc descr;
    private long tstampFirst;
    private long tstampLast;
    private double data; // the average
    private double sum2;
    private int n;
    private double minval;
    private double maxval;

    public StatData() {
    }

    public StatData(StatDesc d) {
        descr = d;
    }

    public StatData(StatDesc d, RawData x) {
        log.fine("new StatData from " + d + " and " + x);
        log.fine(x.getTstamp() + " " + x.getDoubleData());
        descr = d;
        data = x.getDoubleData();
        sum2 = data * data;
        minval = data;
        maxval = data;
        n = 1;
        tstampFirst = x.getTstamp();
        tstampLast = x.getTstamp();
    }

    @Transient
    public double getSum() {
        return getData() * getN();
    }

    public void setSum(double s) {
        setData(s / getN());
    }

    @Transient
    public double getRMS() {
        return Math.sqrt(getSum2() / getN() - getData() * getData());
    }

    public void accumulate(RawData x) {
        double sum = getSum();
        double d = x.getDoubleData();
        sum += d;
        setSum2(getSum2() + d * d);
        if (getN() == 0 || d > maxval)
            maxval = d;
        if (getN() == 0 || d < minval)
            minval = d;
        setN(getN() + 1);
        setSum(sum);
        setTstampLast(x.getTstamp());
    }

    /**
     * @return the id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public long getId() {
        return id;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * @return the descr
     */
    @ManyToOne
    public StatDesc getDescr() {
        return descr;
    }

    /**
     * @param descr
     *            the descr to set
     */
    public void setDescr(StatDesc descr) {
        this.descr = descr;
    }

    /**
     * @return the tstampFirst
     */
    @Column(name = "tstampmills1")
    public long getTstampFirst() {
        return tstampFirst;
    }

    /**
     * @param tstampFirst
     *            the tstampFirst to set
     */
    public void setTstampFirst(long tstampFirst) {
        this.tstampFirst = tstampFirst;
    }

    /**
     * @return the tstampLast
     */
    @Column(name = "tstampmills2")
    public long getTstampLast() {
        return tstampLast;
    }

    /**
     * @param tstampLast
     *            the tstampLast to set
     */
    public void setTstampLast(long tstampLast) {
        this.tstampLast = tstampLast;
    }

    /**
     * @return the data
     */
    public double getData() {
        return data;
    }

    /**
     * @param data
     *            the data to set
     */
    public void setData(double data) {
        this.data = data;
    }

    /**
     * @return the sum2
     */
    public double getSum2() {
        return sum2;
    }

    /**
     * @param sum2
     *            the sum2 to set
     */
    public void setSum2(double sum2) {
        this.sum2 = sum2;
    }

    /**
     * @return the n
     */
    public int getN() {
        return n;
    }

    /**
     * @param n
     *            the n to set
     */
    public void setN(int n) {
        this.n = n;
    }
    
    public void setMin(double min) {
        this.minval = min;
    }

    @Column(name = "minval")
    public double getMin() {
        return minval;
    }
    
    public void setMax(double max) {
        this.maxval = max;
    }

    @Column(name = "maxval")
    public double getMax() {
        return maxval;
    }
}
