package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.hibernate.annotations.Index;

@Entity
@Table(name = "plotdata")
@org.hibernate.annotations.Table(appliesTo = "plotdata", indexes = { @Index(name = "ts_plot", columnNames = {
        "descr_id", "tstampmills" }) })


public class PlotData implements Serializable {

    private static final long serialVersionUID = 345359964480234719L;
    private long id; // do we need this? Perhaps for filter, or whatever
    private DataDesc descr;
    private long tstamp;
    private String plotData;

    /**
     * @return the id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public long getId() {
        return id;
    }

    /**
     * @param id
     *            the id to set
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * @return the descr
     */
    @ManyToOne
    public DataDesc getDescr() {
        return descr;
    }

    /**
     * @param descr
     *            the descr to set
     */
    public void setDescr(DataDesc descr) {
        this.descr = descr;
    }

    /**
     * @return the tstamp
     */
    @Column(name = "tstampmills")
    public long getTstamp() {
        return tstamp;
    }

    /**
     * @param tstamp
     *            the tstamp to set
     */
    public void setTstamp(long tstamp) {
        this.tstamp = tstamp;
    }

    /**
     * @return the plotData
     */
    @Lob
    public String getPlotData() {
        return plotData;
    }

    /**
     * @param plotData
     *            the plotData to set
     */
    public void setPlotData(String plotData) {
        this.plotData = plotData;
    }
}
