package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Embeddable;
import org.lsst.ccs.utilities.logging.Logger;

// because time in MySQL is stored with one second accuracy

// currently implemented as long in millis : could be removed.

// if implemented as data + millis fractional beware of order by  desc that orders asc on first and desc on second


@Embeddable
public class Timestamp implements Serializable, Comparable<Timestamp> {
	private static final long serialVersionUID = 5388711583391014070L;

	public Timestamp() {
		millis = System.currentTimeMillis();
	}

	public Timestamp(Date d) {
		millis = d.getTime();
	}

	public Timestamp(long millis) {
		this.millis = millis;
	}

	public Date getDate() {
		return new Date(millis);
	}

	
	public void setDate(java.util.Date date) {
		this.millis = date.getTime();
	}
	
	public long getMillis() {
		return millis;
	}
	
	public void setMillis(long millis) {
		this.millis = millis;
	}

	@Column(name = "tstampmills")
	protected long millis;

	public int compareTo(Timestamp o) {
		long d = millis - o.millis;
		if (d<0) return -1;
		if (d>0) return 1;
		return 0;
	};

	static Logger log = Logger.getLogger("org.lsst.ccs.localdb");

}
