/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.NaturalId;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;

@Entity
@org.hibernate.annotations.Entity(dynamicUpdate=true, dynamicInsert=true)
@Table(name="datadesc")
public class DataDesc
implements Serializable {
    private static final long serialVersionUID = 2636311585766032024L;
    private long id;
    private String name;
    private String srcSubsystem;
    private String srcName;
    private int maxSamplingMillis = 0;
    private String dataType;
    private long preservationDelay;
    private List<StatDesc> derived = new ArrayList<StatDesc>();

    @Transient
    public String[] getPath() {
        String[] namePath = this.getSrcName().split("/");
        String[] result = new String[namePath.length + 1];
        result[0] = this.getSrcSubsystem();
        for (int i = 1; i < result.length; ++i) {
            result[i] = namePath[i - 1];
        }
        return result;
    }

    public static String encodePath(String[] path) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < path.length; ++i) {
            result.append('/');
            result.append(path[i].replaceAll("/", "\\\\/"));
        }
        return result.toString();
    }

    public static String[] decodePath(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        String[] elts = path.split("(?<!\\\\)/");
        for (int i = 0; i < elts.length; ++i) {
            elts[i] = elts[i].replaceAll("\\\\/", "/");
        }
        return elts;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @NaturalId
    @Column(unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSrcSubsystem() {
        return this.srcSubsystem;
    }

    public void setSrcSubsystem(String srcSubsystem) {
        this.srcSubsystem = srcSubsystem;
    }

    public String getSrcName() {
        return this.srcName;
    }

    public void setSrcName(String srcName) {
        this.srcName = srcName;
    }

    @Column(columnDefinition="int default 0")
    public int getMaxSamplingMillis() {
        return this.maxSamplingMillis;
    }

    public void setMaxSamplingMillis(int maxSamplingMillis) {
        this.maxSamplingMillis = maxSamplingMillis;
    }

    @Column(name="dataType")
    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Column(columnDefinition="int default 0")
    public long getPreservationDelay() {
        return this.preservationDelay;
    }

    public void setPreservationDelay(long preservationDelay) {
        this.preservationDelay = preservationDelay;
    }

    @OneToMany(mappedBy="rawDescr")
    public List<StatDesc> getDerived() {
        return this.derived;
    }

    public void setDerived(List<StatDesc> derived) {
        this.derived = derived;
    }
}

