/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.utils;

import java.io.IOException;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.logging.Logger;

public class StatusdbUtils {
    public static AnnotationConfiguration ac;
    public static Configuration cfg;
    public static SessionFactory fac;
    protected static Logger log;

    public static SessionFactory getSessionFactory(Properties inputProperties) {
        if (ac == null) {
            ac = new AnnotationConfiguration();
        }
        if (cfg == null) {
            String hibernateConfigFile = System.getProperty("org.lsst.ccs.localdb.hibernate.config.file", "hibernate-tm.cfg.xml");
            log.fine((Object)("hibernate config from " + hibernateConfigFile));
            System.out.println("hibernate config from " + hibernateConfigFile);
            cfg = ac.configure(hibernateConfigFile);
            String propertiesFile = System.getProperty("org.lsst.ccs.localdb.hibernate.properties.file", "statusPersister.properties");
            log.fine((Object)("hibernate properties from " + propertiesFile));
            System.out.println("hibernate properties from " + propertiesFile);
            Properties cfgProps = new Properties();
            try {
                cfgProps.load(BootstrapResourceUtils.getBootstrapPropertiesInputStream((String)propertiesFile, StatusdbUtils.class));
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load Hibernate properties", ioe);
            }
            if (inputProperties != null) {
                cfg = cfg.addProperties(inputProperties);
            }
            cfg = cfg.addProperties(cfgProps);
            Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb");
            Properties finalP = cfg.getProperties();
            log.debug((Object)"*** Working with connection properties ");
            for (Object key : finalP.keySet()) {
                String skey = (String)key;
                if (!skey.contains("connection")) continue;
                log.debug((Object)(skey + ": " + finalP.getProperty(skey)));
            }
            log.debug((Object)"*********************************");
        }
        if (fac == null) {
            fac = cfg.buildSessionFactory();
        }
        return fac;
    }

    static {
        log = Logger.getLogger((String)"org.lsst.ccs.localdb");
    }
}

