package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.NaturalId;

@Entity
@org.hibernate.annotations.Entity(dynamicUpdate = true, dynamicInsert = true)
@Table(name = "datadesc")
public class DataDesc implements Serializable {

	private static final long serialVersionUID = 2636311585766032024L;
	private long id; // can have a path
	private String name;

	// or have the path in some other metadata to build the JAS tree.
	// ?? String path; // for JAS
	// ?? String label; // for JAS : label as it appears in tree
	// when JAS plotting the axes labels can still be something different.
	// used in Fermi to have different views (shifter/engineers)
	// TODO publish the list of all variables with a web service REST
	@Transient
	public String[] getPath() {
		String[] namePath = getSrcName().split("/");
		String[] result = new String[namePath.length + 1];
		result[0] = getSrcSubsystem();
		for (int i = 1; i < result.length; i++) {
			result[i] = namePath[i - 1];
		}
		return result;
	}

	public static String encodePath(String[] path) {
		// escape slashs
		StringBuilder result = new StringBuilder();
		for (int i = 0; i < path.length; i++) {
			result.append('/');
			result.append(path[i].replaceAll("/", "\\\\/"));
		}
		return result.toString();
	}

	public static String[] decodePath(String path) {
		if (path.startsWith("/")) {
			path = path.substring(1);
		}
		String[] elts = path.split("(?<!\\\\)/");
		for (int i = 0; i < elts.length; i++) {
			elts[i] = elts[i].replaceAll("\\\\/", "/");
		}
		return elts;
	}

	private String srcSubsystem;
	private String srcName;
	private int maxSamplingMillis = 0;
	private String dataType;
	private long preservationDelay;
	private List<StatDesc> derived = new ArrayList<StatDesc>();

	/**
	 * @return the id
	 */
	@Id()
	@GeneratedValue(strategy = GenerationType.AUTO)
	public long getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(long id) {
		this.id = id;
	}

	/**
	 * @return the name
	 */
	@NaturalId
	@Column(unique = true)
	// mysql specific code:
	// @Column(unique = true, columnDefinition = "varchar(255) collate 'utf8_bin'")
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the srcSubsystem
	 */
	public String getSrcSubsystem() {
		return srcSubsystem;
	}

	/**
	 * @param srcSubsystem
	 *            the srcSubsystem to set
	 */
	public void setSrcSubsystem(String srcSubsystem) {
		this.srcSubsystem = srcSubsystem;
	}

	/**
	 * @return the srcName
	 */
	public String getSrcName() {
		return srcName;
	}

	/**
	 * @param srcName
	 *            the srcName to set
	 */
	public void setSrcName(String srcName) {
		this.srcName = srcName;
	}

	/**
	 * @return the maxSamplingMillis
	 */
	@Column(columnDefinition = "int default 0")
	public int getMaxSamplingMillis() {
		return maxSamplingMillis;
	}

	/**
	 * @param maxSamplingMillis
	 *            the maxSamplingMillis to set
	 */
	public void setMaxSamplingMillis(int maxSamplingMillis) {
		this.maxSamplingMillis = maxSamplingMillis;
	}

	/**
	 * @return the dataType
	 */
	@Column(length = 1)
	public String getDataType() {
		return dataType;
	}

	/**
	 * @param dataType
	 *            the dataType to set
	 */
	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	/**
	 * @return the preservationDelay
	 */
	@Column(columnDefinition = "int default 0")
	public long getPreservationDelay() {
		return preservationDelay;
	}

	/**
	 * @param preservationDelay
	 *            the preservationDelay to set
	 */
	public void setPreservationDelay(long preservationDelay) {
		this.preservationDelay = preservationDelay;
	}

	/**
	 * @return the derived
	 */
	@OneToMany(mappedBy = "rawDescr")
	public List<StatDesc> getDerived() {
		return derived;
	}

	/**
	 * @param derived
	 *            the derived to set
	 */
	public void setDerived(List<StatDesc> derived) {
		this.derived = derived;
	}
}
