/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.trendServer;

import com.sun.jersey.spi.resource.Singleton;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataMetaData;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;
import org.lsst.ccs.localdb.statusdb.server.ChannelMetaData;
import org.lsst.ccs.localdb.statusdb.server.Data;
import org.lsst.ccs.localdb.statusdb.server.DataChannel;
import org.lsst.ccs.localdb.statusdb.server.TrendingData;
import org.lsst.ccs.localdb.statusdb.utils.StatusdbUtils;
import org.lsst.ccs.utilities.logging.Logger;

@Path(value="/dataserver")
@Singleton
public class DataServer {
    private static SessionFactory fac;
    static Logger log;

    static {
        Logger.configure();
        log = Logger.getLogger((String)"org.lsst.ccs.localdb");
    }

    public DataServer() {
        Properties p = new Properties();
        String hcdName = "hibernate.connection.datasource";
        try {
            InitialContext env = new InitialContext();
            try {
                if (env.lookup("jdbc/css") != null) {
                    p.setProperty(hcdName, "jdbc/ccs");
                }
            }
            catch (NamingException namingException) {}
            try {
                if (env.lookup("java:comp/env/jdbc/ccs") != null) {
                    p.setProperty(hcdName, "java:comp/env/jdbc/ccs");
                }
            }
            catch (NamingException namingException) {}
        }
        catch (NamingException namingException) {}
        fac = StatusdbUtils.getSessionFactory(p);
        log.info((Object)"Starting Data Server", new String[0]);
    }

    private List<DataChannel> getListOfChannels() {
        log.info((Object)"Loading Channel Information", new String[0]);
        Session sess = fac.openSession();
        List l = sess.createQuery("from DataDesc").list();
        ArrayList<DataChannel> channels = new ArrayList<DataChannel>();
        log.info((Object)("Done with the query " + l.size()), new String[0]);
        for (DataDesc d : l) {
            DataChannel dc = new DataChannel(d);
            dc.getMetadata().put("subsystem", d.getSrcSubsystem());
            channels.add(dc);
            log.debug((Object)("retrieving Data Channel path= " + dc.getPathAsString()), new String[0]);
        }
        sess.close();
        return channels;
    }

    @GET
    @Path(value="/data/{id}")
    public Data getData(@PathParam(value="id") long id, @QueryParam(value="t1") @DefaultValue(value="-1") long t1, @QueryParam(value="t2") @DefaultValue(value="-1") long t2, @QueryParam(value="flavor") String flavor, @QueryParam(value="n") @DefaultValue(value="30") int nbins) {
        boolean useStat = false;
        boolean useRaw = false;
        if ("stat".equals(flavor)) {
            useStat = true;
        } else if ("raw".equals(flavor)) {
            useRaw = true;
        } else {
            flavor = "unspecified";
        }
        log.info((Object)("request for data " + id + "[" + t1 + "," + t2 + "] " + flavor + " " + nbins), new String[0]);
        if (t2 < 0L) {
            t2 = System.currentTimeMillis();
        }
        if (t1 < 0L) {
            t1 = t2 - 3600000L;
        }
        log.info((Object)("request for data " + id + "[" + t1 + "," + t2 + "] " + flavor + " " + nbins), new String[0]);
        long rawId = id;
        if (useRaw) {
            log.debug((Object)"sending raw data", new String[0]);
            return this.exportRawData(rawId, t1, t2);
        }
        if (useStat) {
            StatDesc statSource = null;
            long statSourceN = -1L;
            Map<StatDesc, Long> stats = this.getAvailableStats(rawId, t1, t2);
            log.info((Object)"stats :", new String[0]);
            for (Map.Entry<StatDesc, Long> s : stats.entrySet()) {
                log.info(s, new String[0]);
                log.info((Object)("  " + s.getKey().getId() + " " + s.getKey().getTimeBinWidth() + " : " + s.getValue()), new String[0]);
            }
            for (Map.Entry<StatDesc, Long> s : stats.entrySet()) {
                long n = s.getValue();
                if (n <= (long)(nbins / 2)) continue;
                if (statSource != null) {
                    if (n >= statSourceN) continue;
                    statSource = s.getKey();
                    statSourceN = n;
                    continue;
                }
                statSource = s.getKey();
                statSourceN = n;
            }
            if (statSource != null) {
                log.debug((Object)("sending stat from stat sampling " + statSource.getTimeBinWidth() + " nsamples " + statSourceN), new String[0]);
                return this.exportStatDataFromStat(rawId, statSource.getId(), t1, t2, nbins);
            }
        }
        log.debug((Object)"sending stat from raw", new String[0]);
        return this.exportStatDataFromRaw(rawId, t1, t2, nbins);
    }

    public List<ChannelMetaData> getMetadata(int channelId) {
        return this.getMetadata(channelId, -1L, -1L);
    }

    public List<ChannelMetaData> getMetadata(int channelId, long t1, long t2) {
        Session sess = fac.openSession();
        String queryStr = "from DataMetaData where rawDescr_id = :id ";
        if (t1 > -1L) {
            queryStr = String.valueOf(queryStr) + "and (tstopmillis > :t1 or tstopmillis = -1) ";
        }
        if (t2 > -1L) {
            queryStr = String.valueOf(queryStr) + "and tstartmillis < :t2 ";
        }
        Query q = sess.createQuery(queryStr);
        q.setParameter("id", (Object)channelId);
        if (t1 > -1L) {
            q.setParameter("t1", (Object)t1);
        }
        if (t2 > -1L) {
            q.setParameter("t2", (Object)t2);
        }
        List l = q.list();
        sess.close();
        ArrayList<ChannelMetaData> out = new ArrayList<ChannelMetaData>();
        for (DataMetaData md : l) {
            out.add(new ChannelMetaData(md));
        }
        return out;
    }

    @GET
    @Path(value="/channelinfo/{id}")
    public ChannelMetadataList getMetadataList(@PathParam(value="id") long channelId) {
        long rawId = channelId;
        return new ChannelMetadataList(this.getMetadata((int)rawId));
    }

    @GET
    @Path(value="/listchannels")
    public DataChannel.DataChannelList getChannels() {
        return new DataChannel.DataChannelList(this.getListOfChannels());
    }

    @GET
    @Path(value="/listchannels/{subsystem}")
    public DataChannel.DataChannelList getChannels(@PathParam(value="subsystem") String subsystemName) {
        List<DataChannel> channels = this.getListOfChannels();
        ArrayList<DataChannel> subChannels = new ArrayList<DataChannel>();
        for (DataChannel dc : channels) {
            if (!dc.getPath()[0].equals(subsystemName)) continue;
            subChannels.add(dc);
        }
        return new DataChannel.DataChannelList(subChannels);
    }

    public DataChannel[] getChannels(String partialPath, int level) {
        return null;
    }

    public DataChannel[] getChannelsByKeywork(String keyword) {
        return null;
    }

    protected Map<StatDesc, Long> getAvailableStats(long rawId, long t1, long t2) {
        Session sess = fac.openSession();
        HashMap<StatDesc, Long> m = new HashMap<StatDesc, Long>();
        Query q = sess.createQuery("select d, count(x) from StatDesc d, StatData x where d.rawDescr.id = :id and x.descr = d and x.tstampFirst >= :t1 and x.tstampLast <= :t2 order by d.timeBinWidth");
        q.setParameter("id", (Object)rawId);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        List l = q.list();
        for (Object[] r : l) {
            if (r[0] == null) continue;
            m.put((StatDesc)r[0], (Long)r[1]);
        }
        sess.close();
        return m;
    }

    protected long getAvailableRawData(long rawId, long t1, long t2) {
        Session sess = fac.openSession();
        Query q = sess.createQuery("select count(r) from RawData r where r.descr.id = :id and r.tstamp between :t1 and :t2 order by r.tstamp");
        q.setParameter("id", (Object)rawId);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        long n = (Long)q.uniqueResult();
        sess.close();
        return n;
    }

    protected List<RawData> getRawData(long id, long t1, long t2) {
        Session sess = fac.openSession();
        Query q = sess.createQuery("from RawData r where r.descr.id = :id and r.tstamp between :t1 and :t2 order by r.tstamp");
        q.setParameter("id", (Object)id);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        List l = q.list();
        log.debug((Object)("retrieved raw data " + id + "[" + t1 + "," + t2 + "] : " + l.size()), new String[0]);
        sess.close();
        return l;
    }

    protected List<StatData> getStatData(long id, long t1, long t2) {
        Session sess = fac.openSession();
        Query q = sess.createQuery("from StatData r where r.descr.id = :id and r.tstampFirst >= :t1 and r.tstampLast <= :t2 order by r.tstampFirst");
        q.setParameter("id", (Object)id);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        List l = q.list();
        log.debug((Object)("retrieved stat data " + id + "[" + t1 + "," + t2 + "] : " + l.size()), new String[0]);
        sess.close();
        return l;
    }

    protected Data exportRawData(long rawId, long t1, long t2) {
        List<RawData> l = this.getRawData(rawId, t1, t2);
        Data d = new Data();
        d.setDataMetaData(this.getMetadata((int)rawId, t1, t2));
        TrendingData[] data = new TrendingData[l.size()];
        int i = 0;
        while (i < l.size()) {
            TrendingData dt;
            RawData r = l.get(i);
            data[i] = dt = new TrendingData();
            long tStamp = r.getTstamp();
            TrendingData.AxisValue axisValue = new TrendingData.AxisValue("time", tStamp);
            dt.setAxisValue(axisValue);
            TrendingData.DataValue[] dataValue = new TrendingData.DataValue[1];
            Double dd = r.getDoubleData();
            dataValue[0] = new TrendingData.DataValue("value", dd == null ? 0.0 : dd);
            dt.setDataValue(dataValue);
            ++i;
        }
        d.getTrendingResult().setTrendingDataArray(data);
        return d;
    }

    protected Data exportStatDataFromRaw(long rawId, long t1, long t2, int nsamples) {
        Session sess = fac.openSession();
        SQLQuery q = sess.createSQLQuery("select tlow, thigh, datasum/entries as mean,  sqrt((datasumsquared - datasum*datasum/entries)/(entries-1)) as rms  from ( SELECT MIN(rd.tstampmills) AS tlow, MAX(rd.tstampmills) AS thigh,  SUM(rd.doubleData) AS datasum, SUM(rd.doubleData*rd.doubleData) AS datasumsquared,  count(1) AS entries from rawdata rd where descr_id = :id and tstampmills >= :t1  and tstampmills <= :t2 group by floor(rd.tstampmills/:deltat) ) accumulated where entries > 0 ");
        long deltat = (t2 - t1) / (long)nsamples;
        q.setParameter("id", (Object)rawId);
        q.setParameter("t1", (Object)t1);
        q.setParameter("t2", (Object)t2);
        q.setParameter("deltat", (Object)deltat);
        List l = q.list();
        sess.close();
        Data d = new Data();
        d.setDataMetaData(this.getMetadata((int)rawId, t1, t2));
        d.getTrendingResult().setTrendingDataArray(new TrendingData[l.size()]);
        int count = 0;
        for (Object[] obj : l) {
            long low = ((BigInteger)obj[0]).longValue();
            long high = ((BigInteger)obj[1]).longValue();
            TrendingData dt = new TrendingData();
            d.getTrendingResult().getTrendingDataArray()[count++] = dt;
            dt.setAxisValue(new TrendingData.AxisValue("time", (low + high) / 2L, low, high));
            TrendingData.DataValue[] dataValue = new TrendingData.DataValue[2];
            double value = (Double)obj[2];
            double rms = 0.0;
            if (obj[3] != null) {
                rms = (Double)obj[3];
            }
            dataValue[0] = new TrendingData.DataValue("value", value);
            dataValue[1] = new TrendingData.DataValue("rms", rms);
            dt.setDataValue(dataValue);
        }
        return d;
    }

    protected Data exportStatDataFromStat(long rawId, long id, long t1, long t2, int nsamples) {
        List<StatData> in = this.getStatData(id, t1, t2);
        int n = in.size();
        int rebin = 1;
        int nout = n;
        if (n > nsamples * 3) {
            rebin = n / nsamples;
            nout = (n + rebin - 1) / rebin;
            log.debug((Object)("will rebin stat by " + rebin + " : " + nout), new String[0]);
        }
        Data d = new Data();
        d.setDataMetaData(this.getMetadata((int)rawId, t1, t2));
        d.getTrendingResult().setTrendingDataArray(new TrendingData[nout]);
        int iout = 0;
        int ibin = 0;
        double sum = 0.0;
        double s2 = 0.0;
        long low = 0L;
        for (StatData sd : in) {
            sum += sd.getSum();
            s2 += sd.getSum2();
            sd.getN();
            if (ibin == 0) {
                low = sd.getTstampFirst();
            }
            if (ibin == rebin - 1 || iout * rebin + ibin == n - 1) {
                TrendingData dt;
                log.debug((Object)("storing for " + iout + " from " + (ibin + 1) + " bins"), new String[0]);
                d.getTrendingResult().getTrendingDataArray()[iout] = dt = new TrendingData();
                dt.setAxisValue(new TrendingData.AxisValue("time", (low + sd.getTstampLast()) / 2L, low, sd.getTstampLast()));
                TrendingData.DataValue[] dataValue = new TrendingData.DataValue[]{new TrendingData.DataValue("value", sum / (double)n), new TrendingData.DataValue("rms", s2 / (double)n - sum / (double)n * (sum / (double)n))};
                dt.setDataValue(dataValue);
                ++iout;
                ibin = 0;
                continue;
            }
            ++ibin;
        }
        return d;
    }

    public static void main(String[] args) throws IOException {
        int socket = 8080;
        if (args.length > 0) {
            socket = Integer.decode(args[0]);
        }
        class MyApplication
        extends Application {
            MyApplication() {
            }

            public Set<Class<?>> getClasses() {
                HashSet s = new HashSet();
                s.add(DataServer.class);
                return s;
            }
        }
        MyApplication app = new MyApplication();
        HttpHandler h = (HttpHandler)RuntimeDelegate.getInstance().createEndpoint((Application)app, HttpHandler.class);
        HttpServer s = HttpServer.create(new InetSocketAddress(socket), 5);
        s.createContext("/rest/data/", h);
        s.start();
    }

    @XmlRootElement(name="channelinfo")
    public static class ChannelMetadataList {
        @XmlElementWrapper(name="channelmetadata")
        @XmlElement(name="channelmetadatavalue")
        public List<ChannelMetaData> list;

        public ChannelMetadataList(List<ChannelMetaData> list) {
            this.list = list;
        }

        public ChannelMetadataList() {
        }
    }
}

