/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.lsst.ccs.localdb.statusdb.utils;

import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.lsst.ccs.bootstrap.BootstrapUtils;
import org.lsst.ccs.bootstrap.resources.ResourcesUtils;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *
 * @author turri
 */
public class StatusdbUtils {
    
    public static AnnotationConfiguration ac;
    public static Configuration cfg;
    public static SessionFactory fac;
    
    
    public static SessionFactory getSessionFactory(Properties inputProperties) {
                        
        if (ac == null) {
            ac = new AnnotationConfiguration();
        }

        if (cfg == null) {
            String hibernateConfigFile = System.getProperty("org.lsst.ccs.localdb.hibernate.config.file", "hibernate-tm.cfg.xml");
            cfg = ac.configure(hibernateConfigFile);
            String propertiesFile = System.getProperty("org.lsst.ccs.localdb.hibernate.properties.file", "statusPersister.properties");
            
//            Properties cfgProps = FrameworkUtils.loadProperties(null, StatusdbUtils.class, propertiesFile);
  
            //Load the properties from the environment.
            //The Properties must be flat as the addProperties method on the Configuration object
            //does not support chained properties.
            Properties cfgProps = BootstrapUtils.getMergedProperties(propertiesFile);
            cfgProps = ResourcesUtils.getFlatPropertiesObject(cfgProps);
                          
            if ( inputProperties != null ) {
                cfg = cfg.addProperties(inputProperties);
            }
            
            cfg = cfg.addProperties(cfgProps);

            Logger log = Logger.getLogger("lsst.ccs.db");
            Properties finalP = cfg.getProperties();            
            log.info("*** Working with connection properties ");
            for (Object key : finalP.keySet()) {
                String skey = (String) key;
                if (skey.contains("connection")) {
                    log.info(skey + ": " + finalP.getProperty(skey));
                }
            }
            log.info("*********************************");
        }

        if (fac == null) {
            fac = cfg.buildSessionFactory();
        }

        return fac;
    }
    
    
}
