/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.jgroups;

import java.util.HashMap;
import org.lsst.ccs.bus.BusMessagingLayer;
import org.lsst.ccs.bus.TransportManager;
import org.lsst.ccs.bus.jgroups.JGroupsBusMessagingLayer;

public class JGroupsTransportManager
extends TransportManager {
    static final HashMap<String, JGroupsBusMessagingLayer> map = new HashMap();

    public BusMessagingLayer getInstance(String protocolString, String propertiesString) {
        if (protocolString.startsWith("jgroups")) {
            String key;
            JGroupsBusMessagingLayer res;
            if ("jgroups".equals(protocolString)) {
                protocolString = "jgroups:udp_ccs:";
            }
            if (propertiesString == null || "".equals(propertiesString)) {
                String[] split = protocolString.split(":");
                propertiesString = split[1].startsWith("tcp") ? "jgroups.bind_addr=localhost;lsst.groups.trybroadcast=true; " : "LOG:udp.mcast_port=26969;STATUS:udp.mcast_port=36969;COMMAND:udp.mcast_port=46969;";
            }
            if ((res = map.get(key = this.getKey(protocolString, propertiesString))) == null) {
                JGroupsBusMessagingLayer layer = new JGroupsBusMessagingLayer(protocolString, propertiesString);
                map.put(key, layer);
                return layer;
            }
            return res;
        }
        return null;
    }

    String getKey(String protocolString, String propertiesString) {
        String props = propertiesString.replace('\n', ';');
        return props.replaceAll("\\s", "");
    }
}

