/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.FileWriter;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jgroups.Address;
import org.jgroups.AnycastAddress;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.Util;

public class TestToaOrder {
    private static final String PROPS = "toa.xml";
    private static final String CLUSTER = "test-toa-cluster";
    private static final String OUTPUT_FILE_SUFFIX = "-messages.txt";
    private static final String JMX_DOMAIN = "org.jgroups";
    private JChannel jChannel;
    private MyReceiver receiver;
    private int numberOfNodes;
    private int numberOfMessages;
    private final List<Address> members = new LinkedList<Address>();
    private long start;
    private long stop;
    private long sentBytes = 0L;
    private long sentMessages = 0L;
    private String config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        System.out.println("==============");
        System.out.println("Test TOA Order");
        System.out.println("==============");
        ArgumentsParser argumentsParser = new ArgumentsParser(args);
        if (argumentsParser.isHelp()) {
            TestToaOrder.helpAndExit();
        } else if (argumentsParser.isTestOrder()) {
            // empty if block
        }
        TestToaOrder test = new TestToaOrder(argumentsParser.getNumberOfNodes(), argumentsParser.getNumberOfMessages(), argumentsParser.getConfig());
        try {
            test.startTest();
        }
        catch (Exception e) {
            System.err.println("Error while executing the test: " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            test.closeJChannel();
            System.out.println("============= FINISHED =============");
        }
        System.exit(0);
    }

    private static void helpAndExit() {
        System.out.println("usage: " + TestToaOrder.class.getCanonicalName() + " <option>");
        System.out.println("Options:");
        System.out.println("  -h                    \tshow this message");
        System.out.println("  -nr-nodes <value>     \tnumber of nodes");
        System.out.println("  -nr-messages <values> \tnumber of messages to send by each node");
        System.out.println("  -config <file>        \tthe JGroup's configuration file");
        System.exit(1);
    }

    public TestToaOrder(int numberOfNodes, int numberOfMessages, String config) {
        this.numberOfNodes = numberOfNodes;
        this.numberOfMessages = numberOfMessages;
        this.config = config;
    }

    private void createJChannel() throws Exception {
        System.out.println("Creating Channel");
        this.receiver = new MyReceiver(this.numberOfNodes, this);
        this.jChannel = new JChannel(this.config);
        this.jChannel.setReceiver(this.receiver);
        this.jChannel.connect(CLUSTER);
        this.receiver.waitUntilClusterIsFormed();
        Util.registerChannel(this.jChannel, JMX_DOMAIN);
        this.members.addAll(this.jChannel.getView().getMembers());
    }

    private AnycastAddress getDestinations(List<Address> members) {
        int rand = members.indexOf(this.jChannel.getAddress());
        AnycastAddress address = new AnycastAddress();
        address.add(members.get(rand++ % members.size()), members.get(rand++ % members.size()), members.get(rand % members.size()));
        return address;
    }

    private void sendMessages() throws Exception {
        System.out.println("Start sending messages...");
        String address = this.jChannel.getAddressAsString();
        List<Address> mbrs = this.jChannel.getView().getMembers();
        this.start = System.nanoTime();
        for (int i = 0; i < this.numberOfMessages; ++i) {
            AnycastAddress dst = this.getDestinations(mbrs);
            Message message = new Message();
            message.setDest(dst);
            DataMessage dataMessage = new DataMessage();
            dataMessage.type = (byte)2;
            dataMessage.data = address + ":" + i;
            message.setObject(dataMessage);
            this.jChannel.send(message);
            this.sentBytes += (long)(dataMessage.data.getBytes().length + 1);
            ++this.sentMessages;
        }
        this.stop = System.nanoTime();
        System.out.println("Finish sending messages...");
    }

    private void awaitUntilAllMessagesAreReceived() throws InterruptedException {
        int expectedMessages = 3 * this.numberOfMessages;
        this.receiver.await(expectedMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitUntilAllFinishes() throws Exception {
        DataMessage dataMessage = new DataMessage();
        dataMessage.type = (byte)1;
        dataMessage.data = null;
        this.jChannel.send(null, dataMessage);
        List<Address> list = this.members;
        synchronized (list) {
            if (!this.members.isEmpty()) {
                this.members.wait();
            }
        }
    }

    public void printSenderInfo() {
        System.out.println("+++ Sender Information +++");
        double duration = this.stop - this.start;
        System.out.println("+ Duration (msec) = " + (duration /= 1000000.0));
        System.out.println("+ Sent Bytes      = " + this.sentBytes);
        System.out.println("+ Sent Messages   = " + this.sentMessages);
        System.out.println("-------------------");
        System.out.println("+ Sent Throughput (bytes/sec)  = " + (double)this.sentBytes / (duration /= 1000.0));
        System.out.println("+ Sent Messages (messages/sec) = " + (double)this.sentMessages / duration);
        System.out.println("--------------------------------");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memberFinished(Address addr) {
        List<Address> list = this.members;
        synchronized (list) {
            this.members.remove(addr);
            if (this.members.isEmpty()) {
                this.members.notify();
            }
        }
    }

    public void closeJChannel() {
        System.out.println("Close channel");
        this.jChannel.close();
    }

    public void startTest() throws Exception {
        System.out.println("Start testing...");
        this.createJChannel();
        this.sendMessages();
        this.awaitUntilAllMessagesAreReceived();
        String filePath = this.jChannel.getAddressAsString() + OUTPUT_FILE_SUFFIX;
        System.out.println("Writing messages in " + filePath);
        FileWriter fileWriter = new FileWriter(filePath);
        for (String s : this.receiver.getMessageList()) {
            fileWriter.write(s);
            fileWriter.write("\n");
        }
        fileWriter.flush();
        fileWriter.close();
        System.out.println("All done!");
        this.awaitUntilAllFinishes();
        this.printSenderInfo();
        this.receiver.printReceiverInfo();
        TestToaOrder.printJMXStats();
    }

    private static void printJMXStats() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName groupMulticast = TestToaOrder.getGroupMulticastObjectName(mBeanServer);
        if (groupMulticast == null) {
            System.err.println("Unable to find the GROUP_MULTICAST protocol");
            return;
        }
        try {
            System.out.println("======== JMX STATS =========");
            for (MBeanAttributeInfo mBeanAttributeInfo : mBeanServer.getMBeanInfo(groupMulticast).getAttributes()) {
                String attribute = mBeanAttributeInfo.getName();
                String type = mBeanAttributeInfo.getType();
                if (!type.equals("double") && !type.equals("int")) continue;
                System.out.println(attribute + "=" + mBeanServer.getAttribute(groupMulticast, attribute));
            }
            System.out.println("======== JMX STATS =========");
        }
        catch (Exception e) {
            System.err.println("Error collecting stats" + e.getLocalizedMessage());
        }
    }

    private static ObjectName getGroupMulticastObjectName(MBeanServer mBeanServer) {
        for (ObjectName name : mBeanServer.queryNames(null, null)) {
            if (!name.getDomain().equals(JMX_DOMAIN) || !"TOA".equals(name.getKeyProperty("protocol"))) continue;
            return name;
        }
        return null;
    }

    private static class DataMessage
    implements Serializable {
        public static final transient byte FINISH = 1;
        public static final transient byte DATA = 2;
        private static final long serialVersionUID = 5946678490588947910L;
        private byte type;
        private String data;

        private DataMessage() {
        }
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        private int expectedMembers;
        private int members = 0;
        private final List<String> messageList;
        private final TestToaOrder testGroupMulticastOrder;
        private long start = 0L;
        private long stop = 0L;
        private long receivedBytes = 0L;
        private int receivedMsgs = 0;

        public MyReceiver(int expectedMembers, TestToaOrder testGroupMulticastOrder) {
            this.expectedMembers = expectedMembers;
            this.testGroupMulticastOrder = testGroupMulticastOrder;
            this.messageList = new LinkedList<String>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Message msg) {
            DataMessage dataMessage = (DataMessage)msg.getObject();
            switch (dataMessage.type) {
                case 1: {
                    this.testGroupMulticastOrder.memberFinished(msg.getSrc());
                    break;
                }
                case 2: {
                    if (this.start == 0L) {
                        this.start = System.nanoTime();
                    }
                    List<String> list = this.messageList;
                    synchronized (list) {
                        this.messageList.add(dataMessage.data);
                    }
                    this.receivedBytes += (long)(dataMessage.data.getBytes().length + 1);
                    ++this.receivedMsgs;
                    this.stop = System.nanoTime();
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void viewAccepted(View view) {
            System.out.println("New View: " + view);
            super.viewAccepted(view);
            MyReceiver myReceiver = this;
            synchronized (myReceiver) {
                this.members = view.getMembers().size();
                this.notify();
            }
        }

        public synchronized void waitUntilClusterIsFormed() throws InterruptedException {
            while (this.members < this.expectedMembers) {
                System.out.println("Number of members is not the expected: " + this.members + " of " + this.expectedMembers);
                this.wait();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await(int expectedMessages) throws InterruptedException {
            while (true) {
                int actualSize;
                List<String> list = this.messageList;
                synchronized (list) {
                    actualSize = this.messageList.size();
                }
                if (actualSize >= expectedMessages) break;
                System.out.println("waiting messages... " + actualSize + " of " + expectedMessages);
                Thread.sleep(10000L);
            }
        }

        public List<String> getMessageList() {
            return this.messageList;
        }

        public void printReceiverInfo() {
            System.out.println("+++ Receiver Information +++");
            double duration = this.stop - this.start;
            System.out.println("+ Duration (msec)   = " + (duration /= 1000000.0));
            System.out.println("+ Received Bytes    = " + this.receivedBytes);
            System.out.println("+ Received Messages = " + this.receivedMsgs);
            System.out.println("---------------------");
            System.out.println("+ Receiving Throughput (bytes/sec)  = " + (double)this.receivedBytes / (duration /= 1000.0));
            System.out.println("+ Receiving Messages (messages/sec) = " + (double)this.receivedMsgs / duration);
            System.out.println("-------------------------------------");
        }
    }

    private static class ArgumentsParser {
        private static final int NR_NODES = 4;
        private static final int NR_MESSAGES = 1000;
        private String[] args;
        private int numberOfNodes = -1;
        private int numberOfMessages = -1;
        private boolean help = false;
        private boolean testOrder = false;
        private String[] filesPath = null;
        private String config = "toa.xml";

        public ArgumentsParser(String[] args) {
            this.args = args;
            this.parse();
            this.checkConfig();
        }

        private void parse() {
            try {
                for (int i = 0; i < this.args.length; ++i) {
                    if ("-h".equals(this.args[i])) {
                        this.help = true;
                        continue;
                    }
                    if ("-nr-nodes".equals(this.args[i])) {
                        this.numberOfNodes = Integer.parseInt(this.args[++i]);
                        if (this.numberOfNodes >= 4) continue;
                        System.err.println("Number of nodes must be greater or equal to 4");
                        System.exit(1);
                        continue;
                    }
                    if ("-nr-messages".equals(this.args[i])) {
                        this.numberOfMessages = Integer.parseInt(this.args[++i]);
                        if (this.numberOfMessages > 0) continue;
                        System.err.println("Number of messages must be greater than 0");
                        System.exit(1);
                        continue;
                    }
                    if ("-config".equals(this.args[i])) {
                        this.config = this.args[++i];
                        continue;
                    }
                    System.err.println("Unknown argument: " + this.args[i]);
                    TestToaOrder.helpAndExit();
                }
            }
            catch (Throwable t) {
                System.err.println("Error processing arguments: " + t.getMessage());
                t.printStackTrace();
                System.exit(1);
            }
        }

        private void checkConfig() {
            if (this.numberOfNodes == -1) {
                this.numberOfNodes = 4;
            }
            if (this.numberOfMessages == -1) {
                this.numberOfMessages = 1000;
            }
        }

        public boolean isHelp() {
            return this.help;
        }

        public boolean isTestOrder() {
            return this.testOrder;
        }

        public int getNumberOfNodes() {
            return this.numberOfNodes;
        }

        public int getNumberOfMessages() {
            return this.numberOfMessages;
        }

        public String[] getFilesPath() {
            return this.filesPath;
        }

        public String getConfig() {
            return this.config;
        }
    }
}

