package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

import org.lsst.ccs.localdb.statusdb.model.DataDesc;

/**
 * Defines a data channel for trending analysis.
 * 
 */

@XmlRootElement(name = "datachannel")
public class DataChannel implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -9154127909107314678L;

	public DataChannel(DataDesc desc) {
		this.desc = desc;
		path = desc.getPath();
	}

	public DataChannel() {
	}

	protected DataDesc desc;

	protected int id;
	
	@XmlElement
	public int getId() {
		return id;
	}
	
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * Channel's path For example : subsystem/variable (FCS/carouselPosition)
	 * 
	 */
	@XmlElement(name = "pathelement")
	@XmlElementWrapper
	protected String[] path; // TODO decide how to construct that path, could be
	// :
	// DataDesc.scrSubsystem, DataDesc.srcName

	Map<String, String> metadata = new HashMap<String, String>();

	// getter

	public String[] getPath() {
		return path;
	}

	public String getPathAsString() {
		return DataDesc.encodePath(path);
	}

	public Map<String, String> getMetadata() {
		return metadata;
	}

        public DataDesc getDataDescription() {
            return desc;
        }
        
	@XmlElement(name = "metadata")
	List<HashMapEntry4XML> getMetadataList() {
		return HashMapEntry4XML.marshal(metadata);
	}

	// wrapper class to get the correct collection name
	
	@XmlRootElement(name="datachannels")
	public static class DataChannelList {
		@XmlElement(name="datachannel")
		public List<DataChannel> list;

		public DataChannelList(List<DataChannel> list) {
			this.list = list;
		}
		
		public DataChannelList() {}
	}

}
