package org.lsst.ccs.localdb.statusdb.server;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.lsst.ccs.localdb.statusdb.server.TrendingData.AxisValue;
import org.lsst.ccs.localdb.statusdb.server.TrendingData.DataValue;

/**
 * Data that the data server sends back to a request.
 */

@XmlRootElement(name = "data")
@XmlType(propOrder = { "params", "trendingResult" })
public class Data implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -4852091712986749775L;
	Map<String, String> params = new HashMap<String, String>();

	@XmlElement
	List<HashMapEntry4XML> getParams() {
		return HashMapEntry4XML.marshal(params);
	}

	TrendingResult result = new TrendingResult();

	@XmlElement(name = "trendingresult")
	public TrendingResult getTrendingResult() {
		return result;
	}

	public void setTrendingResult(TrendingResult result) {
		this.result = result;
	}
        
        public void setDataMetaData(List<ChannelMetaData> list) {
            result.setChannelMetadata(list);
        }

	// basic testing of XML marshalling
	public static void main(String[] args) throws JAXBException {
		// check marshalling
		Data d = new Data();

		d.params.put("key1", "value1");
		d.params.put("key2", "value2");
		d.result = new TrendingResult();
//		d.result.metadata.put("metakey1", "metavalue1");
//		d.result.metadata.put("metakey2", "metavalue2");
		d.result.data = new TrendingData[10];
		for (int i = 0; i < 10; i++) {
			TrendingData dt = new TrendingData();
			d.result.data[i] = dt;
			dt.axisvalue = new AxisValue("time", System.currentTimeMillis());
			dt.datavalue = new DataValue[2];
			dt.datavalue[0] = new DataValue("data", 1.0);
			dt.datavalue[1] = new DataValue("data", 2.0);
		}

		JAXBContext jc = JAXBContext.newInstance(Data.class);
		Marshaller m = jc.createMarshaller();
		m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
		m.marshal(d, System.out);
	}

}
