package org.lsst.ccs.localdb.statusdb.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name = "rawdata")
public class RawData implements Serializable {

    private static final long serialVersionUID = 5996448023570084719L;
    private long id; // do we need this? Perhaps for filter, or whatever
    private DataDesc descr;
    private long tstamp;
    private Double doubleData;
    private String stringData;

    /**
     * @return the id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public long getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(long id) {
        this.id = id;
    }

    /**
     * @return the descr
     */
    @ManyToOne
    public DataDesc getDescr() {
        return descr;
    }

    /**
     * @param descr the descr to set
     */
    public void setDescr(DataDesc descr) {
        this.descr = descr;
    }

    /**
     * @return the tstamp
     */
    @Column(name = "tstampmills")
    public long getTstamp() {
        return tstamp;
    }

    /**
     * @param tstamp the tstamp to set
     */
    public void setTstamp(long tstamp) {
        this.tstamp = tstamp;
    }

    /**
     * @return the doubleData
     */
    public Double getDoubleData() {
        return doubleData;
    }

    /**
     * @param doubleData the doubleData to set
     */
    public void setDoubleData(Double doubleData) {
        this.doubleData = doubleData;
    }

    /**
     * @return the stringData
     */
    public String getStringData() {
        return stringData;
    }

    /**
     * @param stringData the stringData to set
     */
    public void setStringData(String stringData) {
        this.stringData = stringData;
    }
    // public Integer intData; ??
    // can be a keyword - example : temperature to retrieve all temperature data for one subsystem ?
}
// TODO description of derived data to be computed, and statistical data output, two tables.

