/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.StatusListener;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.localdb.Trending;
import org.lsst.ccs.localdb.statusdb.model.DataDesc;
import org.lsst.ccs.localdb.statusdb.model.DataMetaData;
import org.lsst.ccs.localdb.statusdb.model.RawData;
import org.lsst.ccs.localdb.statusdb.model.StatData;
import org.lsst.ccs.localdb.statusdb.model.StatDesc;

public class StatusPersister
implements StatusListener {
    public static AnnotationConfiguration ac;
    public static Configuration cfg;
    public static SessionFactory fac;
    static Logger log;
    Map<String, DataDesc> map = new ConcurrentHashMap<String, DataDesc>();
    protected DataWriter writer = new DataWriter();
    protected ConcurrentLinkedQueue<RawData> q = new ConcurrentLinkedQueue();

    static {
        log = Logger.getLogger((String)"lsst.ccs.db");
    }

    public static synchronized void init() {
        if (ac == null) {
            ac = new AnnotationConfiguration();
        }
        if (cfg == null) {
            cfg = ac.configure("hibernate-tm.cfg.xml");
        }
        if (fac == null) {
            fac = cfg.buildSessionFactory();
        }
    }

    public StatusPersister() {
        StatusPersister.init();
        log.info((Object)"Starting StatusPersister");
        Session sess = fac.openSession();
        List l = sess.createQuery("from DataDesc").list();
        for (DataDesc dd : l) {
            String key = String.valueOf(dd.getSrcSubsystem()) + "/" + dd.getSrcName();
            this.map.put(key, dd);
            log.info((Object)("storing " + key));
        }
        sess.close();
    }

    public void onStatus(BusMessage s) {
        if (s instanceof TrendingStatus) {
            TrendingStatus pv = (TrendingStatus)s;
            this.persistTrendingStatus(pv);
        } else if (s instanceof MetadataStatus) {
            this.persistMetadataStatus((MetadataStatus)s);
        }
    }

    public void persist(long tStamp, String name, Object d) {
        DataDesc dd = this.getDataDescription(name);
        if (dd == null) {
            return;
        }
        RawData data = new RawData();
        data.setTstamp(tStamp);
        data.setDescr(dd);
        if (d instanceof Double) {
            data.setDoubleData((Double)d);
        } else if (d instanceof Float) {
            data.setDoubleData(Double.valueOf(((Float)d).floatValue()));
        } else {
            data.setStringData(d.toString());
        }
        this.q.add(data);
    }

    public void persist(TrendingStatus pv) {
        ValueNotification dt = (ValueNotification)pv.getValue();
        String key = String.valueOf(pv.getOrigin()) + "/" + dt.getName();
        log.debug((Object)("got update (persist) " + key));
        DataDesc dd = this.getDataDescription(key);
        if (dd == null) {
            return;
        }
        RawData data = new RawData();
        data.setTstamp(dt.gettStamp());
        data.setDescr(dd);
        if (dt.getData() instanceof Double) {
            data.setDoubleData((Double)dt.getData());
        } else if (dt.getData() instanceof Float) {
            data.setDoubleData(Double.valueOf(((Float)dt.getData()).floatValue()));
        } else {
            data.setStringData(pv.getValue().toString());
        }
        this.q.add(data);
    }

    public void persistTrendingStatus(TrendingStatus pv) {
        this.persistData(pv.getOrigin(), pv.getTimeStamp(), pv.getValue());
    }

    public void persistData(String origin, long ts, Object p) {
        if (p instanceof ValueNotification[]) {
            ValueNotification[] vv;
            ValueNotification[] valueNotificationArray = vv = (ValueNotification[])p;
            int n = vv.length;
            int n2 = 0;
            while (n2 < n) {
                ValueNotification v = valueNotificationArray[n2];
                this.persistData(origin, v.gettStamp(), v);
                ++n2;
            }
        } else if (p instanceof List && !((List)p).isEmpty() && ((List)p).get(0) instanceof ValueNotification) {
            List vv = (List)p;
            for (ValueNotification v : vv) {
                this.persistData(origin, v.gettStamp(), v);
            }
        } else if (p instanceof ValueNotification) {
            ValueNotification dt = (ValueNotification)p;
            Object data = dt.getData();
            ts = dt.gettStamp();
            if (data instanceof Number || data instanceof String) {
                String key = String.valueOf(origin) + "/" + dt.getName();
                this.persistImmediateScalar(ts, key, data);
            } else {
                Field[] fields;
                Class<?> dataClass = data.getClass();
                log.debug((Object)("will try to persist class " + dataClass));
                boolean saveAll = dataClass.isAnnotationPresent(Trending.class);
                Field[] fieldArray = fields = dataClass.getDeclaredFields();
                int n = fields.length;
                int n3 = 0;
                while (n3 < n) {
                    Field f = fieldArray[n3];
                    if (saveAll || f.isAnnotationPresent(Trending.class)) {
                        try {
                            log.debug((Object)("persisting field " + f.getName()));
                            Object d = f.get(data);
                            String key = String.valueOf(origin) + "/" + dt.getName() + "/" + f.getName();
                            this.persistImmediateScalar(ts, key, d);
                        }
                        catch (IllegalArgumentException ex) {
                            log.error((Object)"pb reading field", (Throwable)ex);
                        }
                        catch (IllegalAccessException ex) {
                            log.error((Object)"pb reading field", (Throwable)ex);
                        }
                    }
                    ++n3;
                }
            }
        } else {
            log.info((Object)("can't persist " + p + " class " + p.getClass()));
        }
    }

    public void persistMetadataStatus(MetadataStatus mst) {
        String dataName = String.valueOf(mst.getOrigin()) + "/" + mst.getDataName();
        DataDesc dd = this.getDataDescription(dataName);
        Session sess = fac.openSession();
        Transaction tx = sess.beginTransaction();
        sess.lock((Object)dd, LockMode.NONE);
        DataMetaData metadata = new DataMetaData();
        metadata.setName(mst.getMetadataName());
        metadata.setRawDescr(dd);
        metadata.setValue(mst.getMetadataValue());
        metadata.setTstart(mst.getTimeStamp());
        Query q = sess.createQuery("from DataMetaData md where rawDescr_id = :id and name = :n and tstopmillis <= 0");
        q.setParameter("id", (Object)dd.getId());
        q.setParameter("n", (Object)metadata.getName());
        DataMetaData oldMetaData = (DataMetaData)q.uniqueResult();
        if (oldMetaData != null) {
            oldMetaData.setTstop(metadata.getTstart());
            sess.update((Object)oldMetaData);
        }
        sess.persist((Object)metadata);
        tx.commit();
        sess.close();
    }

    public void persistImmediateScalar(long tStamp, String name, Object d) {
        DataDesc dd = this.getDataDescription(name);
        if (dd == null) {
            return;
        }
        log.debug((Object)("got update " + name));
        RawData data = new RawData();
        data.setTstamp(tStamp);
        data.setDescr(dd);
        if (d instanceof Double) {
            data.setDoubleData((Double)d);
        } else if (d instanceof Float) {
            data.setDoubleData(Double.valueOf(((Float)d).floatValue()));
        } else if (d instanceof Integer) {
            data.setDoubleData(Double.valueOf(((Integer)d).intValue()));
        } else if (d instanceof Short) {
            data.setDoubleData(Double.valueOf(((Short)d).shortValue()));
        } else {
            data.setStringData(d.toString());
        }
        Session sess = fac.openSession();
        Transaction tx = sess.beginTransaction();
        sess.lock((Object)dd, LockMode.NONE);
        sess.persist((Object)data);
        List stats = dd.getDerived();
        Query q = sess.createQuery("from StatData s where s.descr = :d order by s.tstampFirst desc");
        q.setLockMode("s", LockMode.UPGRADE);
        for (StatDesc stat : stats) {
            q.setEntity("d", (Object)stat);
            q.setMaxResults(1);
            StatData sd = (StatData)q.uniqueResult();
            if (sd == null) {
                sd = new StatData(stat, data);
                sess.persist((Object)sd);
                continue;
            }
            if (data.getTstamp() > sd.getTstampFirst() + stat.getTimeBinWidth()) {
                sd = new StatData(stat, data);
                sess.persist((Object)sd);
                continue;
            }
            sd.accumulate(data);
        }
        tx.commit();
        sess.close();
    }

    private DataDesc getDataDescription(String key) {
        DataDesc dd = this.map.get(key);
        log.debug((Object)("Looking for data description in map " + this.map + " " + key));
        if (dd == null) {
            log.debug((Object)("Adding default Data Description for " + key));
            dd = new DataDesc();
            dd.setDataType("a");
            dd.setName(key);
            int ind = key.indexOf("/");
            dd.setSrcName(key.substring(ind + 1));
            dd.setSrcSubsystem(key.substring(0, ind));
            Session sess = fac.openSession();
            Transaction tx = sess.beginTransaction();
            try {
                sess.persist((Object)dd);
                tx.commit();
            }
            finally {
                sess.close();
            }
            this.map.put(key, dd);
        }
        return dd;
    }

    public class DataWriter
    implements Runnable {
        @Override
        public void run() {
            ArrayList<RawData> workingList = new ArrayList<RawData>(1000);
            int i = 0;
            while (i < 1000) {
                RawData d = StatusPersister.this.q.poll();
                if (d == null) break;
                workingList.add(d);
                ++i;
            }
        }
    }
}

