package org.lsst.ccs.localdb.statusdb;

import javax.ejb.MessageDriven;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;

import org.apache.log4j.Logger;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Status;

@MessageDriven(name = "statusPersister", mappedName = "topic/control/status")
public class StatusPersisterBean implements MessageListener {

    static Logger log = Logger.getLogger("lsst.ccs.db");
    StatusPersister p;// = new StatusPersister();

    public StatusPersisterBean() {
        try {
            p = new StatusPersister();
        } catch (RuntimeException e) {
            log.error("error instantiating StatusPersister ", e);
            e.printStackTrace();
            throw(e);
        }
    }

    public void onMessage(Message msg) {
        if (msg instanceof ObjectMessage) {
            Object payload;
            try {
                payload = ((ObjectMessage) msg).getObject();
            } catch (JMSException e) {
                throw new RuntimeException(e);
            }
            if (payload instanceof Status) {
                p.onStatus((BusMessage) payload);
            } else {
                log.warn("Message payload type "
                        + payload.getClass().getName()
                        + " not handled " + payload);

            }
        } else {
            log.warn("Message  type " + msg.getClass().getName()
                    + " not handled " + msg);

        }

    }
}
