/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.remote;

import java.io.Serializable;
import java.util.logging.Level;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.StatusForEnd;
import org.lsst.ccs.bus.StatusForStart;
import org.lsst.ccs.config.BootCommand;
import org.lsst.ccs.config.BootStatus;
import org.lsst.ccs.config.ConfigurationFacade;
import org.lsst.ccs.config.DBInterface;
import org.lsst.ccs.config.FIleBasedDAO;
import org.lsst.ccs.config.MachineConfiguration;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.config.remote.ConfigurationServerModule;
import org.lsst.ccs.config.remote.ConfigurationServiceImpl;
import org.lsst.ccs.framework.BasicModularSubSystem;

public class ConfigurationServerSystem
extends BasicModularSubSystem {
    ConfigurationServiceImpl service;
    ConfigurationFacade facade;
    boolean forTestsOnly;

    public ConfigurationServerSystem(ConfigurationFacade facade) {
        super("configServer");
        this.facade = facade;
        this.forTestsOnly = Boolean.getBoolean("org.lsst.ccs.testcontext");
        this.service = new ConfigurationServiceImpl(facade);
        this.addModule(new ConfigurationServerModule(this.service));
        this.setStatusBroadcastPeriod(86400000);
        this.setListenToStatus(true);
    }

    public void onStatus(BusMessage message) {
        String initiatorName = message.getOrigin();
        try {
            if (message instanceof BootStatus) {
                BootStatus bootStatus = (BootStatus)message;
                String requestedSubsystem = bootStatus.getRequestedSubsystem();
                String requestedConfiguration = bootStatus.getRequestedConfiguration();
                String requestedTag = bootStatus.getRequestedTag();
                String origin = bootStatus.getOrigin();
                boolean forTestContext = bootStatus.isInTestContext();
                if (!(this.forTestsOnly ^ forTestContext)) {
                    Serializable startupObject = null;
                    BootCommand cmd = null;
                    if (requestedSubsystem == null || "".equals(requestedSubsystem)) {
                        MachineConfiguration machineConfiguration = this.facade.getMachineConfiguration(origin);
                        requestedSubsystem = machineConfiguration.getSubsystemName();
                        requestedConfiguration = machineConfiguration.getConfigName();
                        requestedTag = machineConfiguration.getTag();
                    }
                    if ((cmd = new BootCommand(origin, requestedSubsystem, requestedConfiguration, requestedTag, startupObject = requestedConfiguration != null && !"".equals(requestedConfiguration) ? this.facade.getActiveConfigProfile(requestedConfiguration, requestedTag) : this.facade.getActiveSubsystemDescription(requestedSubsystem, requestedTag))) != null) {
                        this.fac.sendCommand((Command)cmd);
                    } else {
                        PackCst.CURLOG.log(Level.WARNING, "no descriptions for ", message);
                    }
                }
            } else if (message instanceof StatusForStart) {
                StatusForStart startStatus = (StatusForStart)message;
                if (startStatus.getOrigin().equals(this.getName())) {
                    return;
                }
                boolean forTestContext = startStatus.isInTestContext();
                if (!(this.forTestsOnly ^ forTestContext)) {
                    this.facade.registerRun(initiatorName, startStatus.getConfigurationName(), startStatus.getTag(), message.getTimeStamp());
                }
            } else if (message instanceof StatusForEnd) {
                StatusForEnd endStatus = (StatusForEnd)message;
                if (endStatus.getOrigin().equals(this.getName())) {
                    return;
                }
                boolean forTestContext = endStatus.isInTestContext();
                if (!(this.forTestsOnly ^ forTestContext)) {
                    this.facade.endRun(initiatorName, endStatus.getConfigurationName(), endStatus.getTag(), endStatus.getTimeStamp());
                }
            }
        }
        catch (Exception exc) {
            PackCst.CURLOG.log(Level.SEVERE, "on status message " + message, exc);
            System.err.println("ERROR :" + exc);
        }
    }

    public static void main(String[] args) throws Exception {
        ConfigurationFacade facade;
        System.setProperty("lsst.messaging.factory", "org.lsst.ccs.bus.BusMessagingFactory");
        if (Boolean.getBoolean("org.lsst.ccs.testcontext")) {
            facade = new ConfigurationFacade(new FIleBasedDAO());
        } else {
            String clazzName = System.getProperty("org.lsst.ccs.configDAO", "org.lsst.ccs.config.dao.hibernate.HibernateDAO");
            DBInterface dao = (DBInterface)Class.forName(clazzName).newInstance();
            facade = new ConfigurationFacade(dao);
        }
        ConfigurationServerSystem system = new ConfigurationServerSystem(facade);
        system.start();
    }
}

