/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.jgroups;

import java.util.HashMap;
import java.util.Map;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.ReceiverAdapter;

public class GroupTopic {
    static Map<String, GroupTopic> map = new HashMap<String, GroupTopic>();
    private String topicName;
    private JChannel channel;
    private ReceiverAdapter adapter;

    private GroupTopic(String topicName, String stackProperties) throws Exception {
        this.topicName = topicName;
        this.channel = new JChannel(stackProperties);
        this.channel.connect(topicName);
    }

    public String getTopicName() {
        return this.topicName;
    }

    public JChannel getChannel() {
        return this.channel;
    }

    public ReceiverAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(ReceiverAdapter adapter) {
        this.adapter = adapter;
        this.channel.setReceiver((Receiver)adapter);
    }

    public static synchronized GroupTopic create(String topic, String stackProperties) throws Exception {
        GroupTopic res = map.get(topic);
        if (res == null) {
            res = new GroupTopic(topic, stackProperties);
            map.put(topic, res);
        }
        return res;
    }

    public void close() {
        this.channel.close();
    }

    public static synchronized void closeAll() {
        for (GroupTopic top : map.values()) {
            top.close();
        }
    }

    public void sendMessage(Object obj) throws Exception {
        this.channel.send(new Message(null, null, obj));
    }
}

