/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.jutils;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Map;
import org.lsst.gruth.jutils.HollowParm;
import org.lsst.gruth.jutils.IncompatibleTypeException;

public class DblParm
extends HollowParm<Double> {
    private BigDecimal bigVal;

    public DblParm() {
    }

    public DblParm(Double value) {
        super(value);
    }

    public DblParm(Double value, Map<?, ?> map) {
        super(value, map);
    }

    public DblParm(BigDecimal value) {
        this.bigVal = value;
        this.set = true;
    }

    public DblParm(BigDecimal value, Map<?, ?> map) {
        this(value);
        this.setProperties(map);
    }

    public DblParm(String strVal) throws NumberFormatException {
        this(new BigDecimal(strVal));
    }

    public DblParm(String strVal, Map<?, ?> map) throws NumberFormatException {
        this(new BigDecimal(strVal), map);
    }

    @Override
    public Double getValue() {
        if (this.bigVal != null) {
            return this.bigVal.doubleValue();
        }
        return (Double)this.value;
    }

    public BigDecimal asBigDecimal() {
        if (this.isSet()) {
            if (this.bigVal != null) {
                return this.bigVal;
            }
            return BigDecimal.valueOf((Double)this.value);
        }
        return null;
    }

    @Override
    public void setValue(Double value) {
        if (this.readOnly) {
            return;
        }
        super.setValue(value);
        this.bigVal = null;
    }

    @Override
    public void setValue(BigDecimal bigVal) {
        if (this.readOnly) {
            return;
        }
        this.bigVal = bigVal;
        this.set = true;
        this.value = null;
    }

    @Override
    public void setValue(Integer val) {
        if (this.readOnly) {
            return;
        }
        this.bigVal = new BigDecimal(val);
        this.set = true;
        this.value = null;
    }

    @Override
    public void setValue(String strVal) throws NumberFormatException {
        if (this.readOnly) {
            return;
        }
        this.setValue(new BigDecimal(strVal));
    }

    @Override
    public void modifyChecked(Object obj) {
        if (this.readOnly) {
            return;
        }
        if (obj == null) {
            this.setNullValue();
            return;
        }
        Class<?> clazz = obj.getClass();
        Class<?> myClass = this.getClass();
        try {
            Method method = myClass.getDeclaredMethod("setValue", clazz);
            method.invoke((Object)this, obj);
        }
        catch (Exception exception) {
            throw new IncompatibleTypeException(myClass, clazz);
        }
    }

    @Override
    public String toString() {
        if (this.bigVal != null) {
            return this.bigVal.toPlainString();
        }
        return super.toString();
    }

    @Override
    public Class<Double> getValueClass() {
        return Double.class;
    }
}

