/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.ggre.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class DynDialog
extends JDialog {
    private ArrayList<Action> dynDialogActions;
    private Action lastAction;
    private Listener listener;
    private JPanel buttonPane;
    private String dynDialogTitle;
    private String dynDialogText;

    public Action getLastAction() {
        return this.lastAction;
    }

    public boolean addAction(Action dynDialogAction) {
        return this.dynDialogActions.add(dynDialogAction);
    }

    public boolean addAction(String text, String tooltip, String actionCommand) {
        return this.dynDialogActions.add(new Action(text, actionCommand, tooltip));
    }

    public boolean addAction(String text, String actionCommand) {
        return this.addAction(text, null, actionCommand);
    }

    public boolean addAction(String text, String actionCommand, Object caller, Method callBack) {
        Action action = new Action(text, actionCommand, caller, callBack);
        return this.dynDialogActions.add(action);
    }

    public DynDialog(String dynDialogTitle, String dynDialogText, ArrayList<Action> dynDialogActions, Listener listener) {
        this.dynDialogTitle = dynDialogTitle;
        this.dynDialogText = dynDialogText;
        this.dynDialogActions = dynDialogActions;
        this.listener = listener;
        this.init();
    }

    public DynDialog(String dynDialogTitle, String dynDialogText, Action[] dynDialogActions, Listener listener) {
        this.dynDialogTitle = dynDialogTitle;
        this.dynDialogText = dynDialogText;
        this.dynDialogActions = new ArrayList();
        Action[] actionArray = dynDialogActions;
        int n = dynDialogActions.length;
        int n2 = 0;
        while (n2 < n) {
            Action dynDialogAction = actionArray[n2];
            this.dynDialogActions.add(dynDialogAction);
            ++n2;
        }
        this.listener = listener;
        this.init();
    }

    public DynDialog(String dynDialogTitle, String dynDialogText, Action dynDialogAction, Listener listener) {
        this(dynDialogTitle, dynDialogText, new Action[]{dynDialogAction}, listener);
    }

    private void init() {
        this.setTitle(this.dynDialogTitle);
        this.setBounds(100, 100, 450, 300);
        this.setAlwaysOnTop(true);
        this.setModalityType(DEFAULT_MODALITY_TYPE);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new FlowLayout());
        contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.add(new JLabel(this.dynDialogText, null, 10));
        this.buttonPane = new JPanel();
        this.buttonPane.setLayout(new FlowLayout(4));
        for (Action action : this.dynDialogActions) {
            this.buttonPane.add(new JButton(action));
        }
        this.getContentPane().add((Component)this.buttonPane, "South");
        this.setResizable(false);
        this.pack();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.lastAction = null;
        }
        super.setVisible(b);
    }

    public static class Action
    extends AbstractAction {
        private Object caller;
        private Method callBack;
        private String actionCommand;
        private Listener localListener;

        public String getActionCommand() {
            return this.actionCommand;
        }

        public Action(String text, String tooltip, Listener localListener) {
            this(text, null, tooltip);
            this.localListener = localListener;
        }

        public Action(String text, Listener localListener) {
            this(text, null, localListener);
        }

        public Action(String text) {
            this(text, (String)null, (Listener)null);
        }

        public Action(String text, String actionCommand, String tooltip) {
            this.actionCommand = actionCommand;
            this.putValue("Name", text);
            this.putValue("ShortDescription", tooltip);
            this.putValue("ActionCommandKey", actionCommand);
        }

        public Action(String text, String actionCommand) {
            this(text, actionCommand, (String)null);
        }

        public Action(String text, String actionCommand, Object caller, Method callBack) {
            this(text, actionCommand, (String)null);
            this.caller = caller;
            this.callBack = callBack;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Listener l;
            DynDialog thisDynDialog = (DynDialog)((JButton)e.getSource()).getTopLevelAncestor();
            thisDynDialog.lastAction = this;
            thisDynDialog.setVisible(false);
            if (this.localListener != null) {
                this.localListener.dynDialogReact(this);
            }
            if (this.caller != null && this.callBack != null) {
                try {
                    this.callBack.invoke(this.caller, null);
                }
                catch (IllegalArgumentException e1) {
                    e1.printStackTrace();
                }
                catch (IllegalAccessException e1) {
                    e1.printStackTrace();
                }
                catch (InvocationTargetException e1) {
                    e1.printStackTrace();
                }
            }
            if ((l = thisDynDialog.listener) != null) {
                l.dynDialogReact(this);
            }
        }
    }

    public static interface Listener {
        public void dynDialogReact(Action var1);
    }
}

