/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.gruth.ggre;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.BorderUIResource;
import org.lsst.gruth.ggre.ReportDetailPanel;
import org.lsst.gruth.ggre.ReportsPanel;
import org.lsst.gruth.ggre.ReportsPanelNotification;
import org.lsst.gruth.ggre.dialogs.DynDialog;
import org.lsst.gruth.reports.StoreAgent;

public class ReportEditorPanel
extends JPanel
implements Observer {
    private static final String APP_TITLE_BASE = "GGRE";
    private static final String STATUS_HTML_TEMPLATE_BEFORE = "<html><body style='font-family: arial, helvetica, sans-serif;'><div style='padding: 3px;'>";
    private static final String STATUS_HTML_TEMPLATE_AFTER = "</div></body></html>";
    private static final ImageIcon icnOpen = new ImageIcon(ReportEditorPanel.class.getResource("resources/icons/Folder_table.png"));
    private static final ImageIcon icnSave = new ImageIcon(ReportEditorPanel.class.getResource("resources/icons/Database_save.png"));
    private String workingDirectoryName = null;
    private StoreAgent store;
    private String bundleName = null;
    private JButton btnReportViewAsXml;
    private ReportsPanel pnlReports;
    private ReportDetailPanel pnlDetail;
    private JEditorPane edtStatus;
    private DynDialog confirmDialog;

    public ReportEditorPanel(StoreAgent store) {
        this.store = store;
        this.initLayout();
    }

    private void initLayout() {
        this.shouldUpdateTitle();
        this.setLayout(new BorderLayout(3, 3));
        Box topBox = Box.createVerticalBox();
        this.add((Component)topBox, "North");
        Box leftBox = Box.createHorizontalBox();
        this.add((Component)leftBox, "West");
        Box bottomBox = Box.createVerticalBox();
        this.add((Component)bottomBox, "South");
        JMenuBar menuBar = new JMenuBar();
        menuBar.setAlignmentX(0.0f);
        topBox.add((Component)menuBar, "North");
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.setAlignmentX(0.0f);
        topBox.add(buttonBox);
        JToolBar toolBarFile = new JToolBar("Reports");
        toolBarFile.setRollover(true);
        toolBarFile.setFloatable(false);
        toolBarFile.setAlignmentX(0.0f);
        buttonBox.add(toolBarFile);
        JToolBar toolBarReport = new JToolBar("Report");
        toolBarReport.setRollover(true);
        toolBarReport.setFloatable(false);
        toolBarReport.setAlignmentX(0.0f);
        buttonBox.add(toolBarReport);
        JMenu mnuStore = new JMenu("Store");
        menuBar.add(mnuStore);
        StoreActions[] storeActionsArray = StoreActions.values();
        int n = storeActionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            StoreActions action = storeActionsArray[n2];
            mnuStore.add(new JMenuItem(new StoreAction(action)));
            toolBarFile.add(new JButton(new StoreAction(action)));
            ++n2;
        }
        this.pnlReports = new ReportsPanel();
        this.add((Component)this.pnlReports, "Center");
        this.pnlDetail = new ReportDetailPanel();
        this.add((Component)this.pnlDetail, "After");
        this.edtStatus = new JEditorPane("text/html", null);
        this.populateStatus("No report selected.");
        this.edtStatus.setEditable(false);
        this.edtStatus.setVisible(true);
        this.edtStatus.setBorder(BorderUIResource.getEtchedBorderUIResource());
        bottomBox.add(this.edtStatus);
        this.pnlReports.getObservable().addObserver(this);
        this.pnlReports.getObservable().addObserver(this.pnlDetail);
    }

    private void populateStatus(String htmlContents) {
        StringBuilder sb = new StringBuilder(STATUS_HTML_TEMPLATE_BEFORE);
        sb.append(htmlContents);
        sb.append(STATUS_HTML_TEMPLATE_AFTER);
        this.edtStatus.setText(sb.toString());
    }

    private void shouldUpdateTitle() {
    }

    @Override
    public void update(Observable observable, Object notification) {
        if (notification instanceof ReportsPanelNotification) {
            ReportsPanelNotification notif = (ReportsPanelNotification)notification;
            StringBuilder sb = new StringBuilder();
            sb.append("Test \"<b>");
            sb.append(notif.getEditedReport().getReport().getUniqueKey());
            sb.append("</b>\"");
            if (notif.isDifferenceNotification()) {
                sb.append(" - original Advice was <b>");
                sb.append((Object)notif.getOriginalReport().getAdvice());
                sb.append("</b>");
            }
            this.populateStatus(sb.toString());
        } else {
            this.populateStatus("No report selected.");
        }
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName, String version) {
        this.bundleName = bundleName;
        try {
            if (version == null) {
                this.store.setBundle(bundleName);
            } else {
                int versionNumber = Integer.parseInt(version);
                this.store.setBundle(bundleName, versionNumber);
            }
            this.pnlReports.setStore(this.store);
            String title = String.valueOf(bundleName) + " " + this.store.getVersion();
            Window top = SwingUtilities.getWindowAncestor(this);
            if (top instanceof JFrame) {
                JFrame ftop = (JFrame)top;
                ftop.setTitle("EDITING REPORTS FOR: " + title);
            }
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this, String.valueOf(bundleName) + " : no such bundle (" + exc + ")", "Store exception", 0);
        }
    }

    public void storeActionOpen(ActionEvent evt) {
        String name = JOptionPane.showInputDialog(this, "choose the bundle to open : type name of name:version", "Store content", 3);
        if (name == null) {
            return;
        }
        String[] names = name.split(":");
        String bundleName = null;
        String version = null;
        switch (names.length) {
            case 0: {
                return;
            }
            case 2: {
                version = names[1];
            }
            case 1: {
                bundleName = names[0];
            }
        }
        this.doOpenStoreAndUpdateView(bundleName, version);
    }

    public void doOpenStoreAndUpdateView(String bundleName, String version) {
        this.setBundleName(bundleName, version);
        this.pnlReports.showReport();
    }

    public void storeActionSave(ActionEvent evt) {
        try {
            this.store.save();
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this, String.valueOf(this.bundleName) + " : save (" + exc + ")", "Store exception", 0);
        }
    }

    static /* synthetic */ ImageIcon access$0() {
        return icnOpen;
    }

    static /* synthetic */ ImageIcon access$1() {
        return icnSave;
    }

    private class StoreAction
    extends AbstractAction {
        private StoreAction(StoreActions action) {
            this.putValue("org.lsst.gruth.ggre_storeActionsItem", (Object)action);
            this.putValue("Name", action.label);
            this.putValue("ShortDescription", action.description);
            this.putValue("SmallIcon", action.icon);
            this.putValue("ActionCommandKey", action.actionCommand);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            switch ((StoreActions)((Object)this.getValue("org.lsst.gruth.ggre_storeActionsItem"))) {
                case OPEN: {
                    ReportEditorPanel.this.storeActionOpen(actionEvent);
                    break;
                }
                case SAVE: {
                    ReportEditorPanel.this.storeActionSave(actionEvent);
                }
            }
        }
    }

    private static enum StoreActions {
        OPEN("StoreActionOpen", "Open", "Opens a new bundle", ReportEditorPanel.access$0()),
        SAVE("StoreActionSave", "Save", "Saves the current report set", ReportEditorPanel.access$1());

        private String actionCommand;
        private String label;
        private String description;
        private ImageIcon icon;

        private StoreActions(String actionCommand, String label, String description, ImageIcon icon) {
            this.actionCommand = actionCommand;
            this.label = label;
            this.description = description;
            this.icon = icon;
        }
    }
}

