/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.test.reflection.java.generics.deep;

import java.util.List;
import junit.framework.TestCase;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;

public class DeepGenericsContainment
extends TestCase {
    public void test2StepsGenerics() throws Exception {
        JavaReflectionManager factory = new JavaReflectionManager();
        XClass container = factory.toXClass(Container.class);
        XProperty contained = (XProperty)container.getDeclaredProperties("field").get(0);
        DeepGenericsContainment.assertTrue((boolean)contained.isTypeResolved());
        XProperty generic = (XProperty)contained.getType().getDeclaredProperties("field").get(0);
        DeepGenericsContainment.assertTrue((boolean)generic.isTypeResolved());
    }

    public void test2StepsGenericsCollection() throws Exception {
        JavaReflectionManager factory = new JavaReflectionManager();
        XClass container = factory.toXClass(ContainerWithCollection.class);
        XProperty collection = (XProperty)container.getDeclaredProperties("field").get(0);
        DeepGenericsContainment.assertTrue((boolean)collection.isTypeResolved());
        XClass elementClass = collection.getElementClass();
        XProperty generic = (XProperty)elementClass.getDeclaredProperties("field").get(0);
        DeepGenericsContainment.assertTrue((boolean)generic.isTypeResolved());
    }

    public static class ContainerWithCollection {
        List<Contained<String>> contained;
    }

    public static class Container {
        Contained<String> contained;
    }

    public static class Contained<T> {
        T generic;
    }
}

