/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.limits;

import java.util.List;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.Limits;
import org.lsst.ccs.subsystem.teststand.limits.LimitsInterface;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;

class RatchetTransitionAlgorithm
implements TransitionAlgorithm {
    private LimitAlgorithm limitAlgorithm;
    private double lastValue;
    private boolean goingUp;
    private Limits originalLimits;

    RatchetTransitionAlgorithm() {
    }

    @Override
    public void init(List<Double> parameters, LimitAlgorithm limitAlgorithm, double initialValue, LimitsInterface priorLimits, long startTime) {
        if (!parameters.isEmpty()) {
            throw new IllegalArgumentException("RatchetTransitionAlgorithm does not take any parameters");
        }
        this.limitAlgorithm = limitAlgorithm;
        this.lastValue = initialValue;
        this.goingUp = limitAlgorithm.getTargetValue() > initialValue;
        this.originalLimits = new Limits(limitAlgorithm.getLimits());
    }

    @Override
    public boolean isAtTarget(double currentValue, long time) {
        return currentValue > this.originalLimits.getWarnLow() && currentValue < this.originalLimits.getWarnHigh();
    }

    @Override
    public void adjustLimits(double currentValue, long time) {
        if (this.goingUp && currentValue > this.lastValue) {
            this.lastValue = currentValue;
            this.limitAlgorithm.adjust(currentValue);
        } else if (!this.goingUp && currentValue < this.lastValue) {
            this.lastValue = currentValue;
            this.limitAlgorithm.adjust(currentValue);
        }
    }

    @Override
    public void completeTransition(long time) {
        this.originalLimits.copyTo(this.limitAlgorithm.getLimits());
    }

    @Override
    public LimitsInterface getLimits() {
        return this.limitAlgorithm.getLimits();
    }
}

