/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.limits;

import java.util.List;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.LimitsInterface;

class ProportionalLimitAlgorithm
extends LimitAlgorithm {
    private Double alarmLow;
    private Double warnLow;
    private Double warnHigh;
    private Double alarmHigh;

    ProportionalLimitAlgorithm() {
    }

    @Override
    public void init(List<Double> parameters, LimitsInterface limits, double targetValue) {
        super.init(parameters, limits, targetValue);
        if (parameters.size() != 4) {
            throw new IllegalArgumentException("Proportional limit algorithm requires 4 parameters");
        }
        this.alarmLow = parameters.get(0);
        this.warnLow = parameters.get(1);
        this.warnHigh = parameters.get(2);
        this.alarmHigh = parameters.get(3);
        if (this.alarmLow <= 0.0 || this.alarmLow > this.warnLow || this.warnLow >= 1.0 || this.warnHigh <= 1.0 || this.alarmHigh < this.warnHigh) {
            throw new IllegalArgumentException("Proportional limit algorith parameters are invalid");
        }
        this.adjust(targetValue);
    }

    @Override
    public void adjust(double currentValue) {
        this.getLimits().setLimits(currentValue * this.alarmLow, currentValue * this.warnLow, currentValue * this.warnHigh, currentValue * this.alarmHigh);
    }
}

