/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.limits;

import java.util.List;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.LimitsInterface;

class DeltaLimitAlgorithm
extends LimitAlgorithm {
    private double alarmLow;
    private double warnLow;
    private double alarmHigh;
    private double warnHigh;

    DeltaLimitAlgorithm() {
    }

    @Override
    public void init(List<Double> parameters, LimitsInterface limits, double targetValue) {
        super.init(parameters, limits, targetValue);
        if (parameters.size() != 4) {
            throw new IllegalArgumentException("Delta limit algorithm requires 4 parameters");
        }
        this.alarmLow = -Math.abs(parameters.get(0));
        this.warnLow = -Math.abs(parameters.get(1));
        this.warnHigh = Math.abs(parameters.get(2));
        this.alarmHigh = Math.abs(parameters.get(3));
        if (this.alarmLow > this.warnLow || this.warnLow >= 0.0 || this.warnHigh <= 0.0 || this.alarmHigh < this.warnHigh) {
            throw new IllegalArgumentException("Delta limit algorith parameters are invalid");
        }
        this.adjust(targetValue);
    }

    @Override
    public void adjust(double currentValue) {
        this.getLimits().setLimits(currentValue + this.alarmLow, currentValue + this.warnLow, currentValue + this.warnHigh, currentValue + this.alarmHigh);
    }
}

