/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.limits;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.teststand.limits.AbsoluteLimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.DeltaLimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.ProportionalLimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.RatchetTransitionAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;

public class AlgorithmFactory {
    static final Map<String, Class<? extends LimitAlgorithm>> limitRegistry = new HashMap<String, Class<? extends LimitAlgorithm>>();
    static final Map<String, Class<? extends TransitionAlgorithm>> transitionRegistry = new HashMap<String, Class<? extends TransitionAlgorithm>>();

    public static LimitAlgorithm createLimitAlgorithm(String name) {
        try {
            Class<? extends LimitAlgorithm> algorithmClass = limitRegistry.get(name);
            if (algorithmClass == null) {
                throw new RuntimeException("Unregistered limit algorithm: " + name);
            }
            return algorithmClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException("Unable to create limit algorithm: " + name, ex);
        }
    }

    public static TransitionAlgorithm createTransitionAlgorithm(String name) {
        try {
            Class<? extends TransitionAlgorithm> algorithmClass = transitionRegistry.get(name);
            if (algorithmClass == null) {
                throw new RuntimeException("Unregistered transition algorithm: " + name);
            }
            return algorithmClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new RuntimeException("Unable to create transition algorithm: " + name, ex);
        }
    }

    static {
        limitRegistry.put("DELTA", DeltaLimitAlgorithm.class);
        limitRegistry.put("ABSOLUTE", AbsoluteLimitAlgorithm.class);
        limitRegistry.put("PROPORTIONAL", ProportionalLimitAlgorithm.class);
        transitionRegistry.put("RATCHET", RatchetTransitionAlgorithm.class);
    }
}

