/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand.limits;

import java.util.List;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.LimitsInterface;

class AbsoluteLimitAlgorithm
extends LimitAlgorithm {
    private double deltaAlarmLow;
    private double deltaWarnLow;
    private double deltaAlarmHigh;
    private double deltaWarnHigh;

    AbsoluteLimitAlgorithm() {
    }

    @Override
    public void init(List<Double> parameters, LimitsInterface limits, double targetValue) {
        super.init(parameters, limits, targetValue);
        if (parameters.size() != 4) {
            throw new IllegalArgumentException("Absolute limit algorithm requires 4 parameters");
        }
        double alarmLow = parameters.get(0);
        double warnLow = parameters.get(1);
        double warnHigh = parameters.get(2);
        double alarmHigh = parameters.get(3);
        if (alarmLow > warnLow || warnLow >= targetValue || warnHigh <= targetValue || alarmHigh < warnHigh) {
            throw new IllegalArgumentException("Absolute limit algorithm parameters are invalid: " + parameters);
        }
        limits.setLimits(alarmLow, warnLow, warnHigh, alarmHigh);
        this.deltaAlarmLow = alarmLow - targetValue;
        this.deltaWarnLow = warnLow - targetValue;
        this.deltaWarnHigh = warnHigh - targetValue;
        this.deltaAlarmHigh = alarmHigh - targetValue;
    }

    @Override
    public void adjust(double currentValue) {
        this.getLimits().setLimits(currentValue + this.deltaAlarmLow, currentValue + this.deltaWarnLow, currentValue + this.deltaWarnHigh, currentValue + this.deltaAlarmHigh);
    }
}

