/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.List;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystem.teststand.limits.AlgorithmFactory;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.LimitsInterface;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;
import org.python.google.common.base.Strings;

public class VacuumConfiguration {
    @ConfigurationParameter(category="vacuum")
    double pressureSetPoint;
    @ConfigurationParameter(category="vacuum")
    String pressureMonitoringLimitAlgorithm;
    @ConfigurationParameter(category="vacuum")
    List<Double> pressureMonitoringLimitAlgorithmParameters;
    @ConfigurationParameter(category="vacuum")
    String pressureMonitoringTransitionAlgorithm;
    @ConfigurationParameter(category="vacuum")
    List<Double> pressureMonitoringTransitionAlgorithmParameters;

    LimitAlgorithm createVacuumLimitsAlgorithm(LimitsInterface limits) {
        LimitAlgorithm la = AlgorithmFactory.createLimitAlgorithm(this.pressureMonitoringLimitAlgorithm);
        la.init(this.pressureMonitoringLimitAlgorithmParameters, limits, this.pressureSetPoint);
        return la;
    }

    TransitionAlgorithm createVacuumTransitionAlgorithm(LimitAlgorithm limits, double initialPressure, LimitsInterface priorLimits, long startTime) {
        if (!Strings.isNullOrEmpty((String)this.pressureMonitoringTransitionAlgorithm)) {
            TransitionAlgorithm ta = AlgorithmFactory.createTransitionAlgorithm(this.pressureMonitoringTransitionAlgorithm);
            ta.init(this.pressureMonitoringTransitionAlgorithmParameters, limits, initialPressure, priorLimits, startTime);
            return ta;
        }
        return null;
    }

    public String toString() {
        return "VacuumConfiguration{pressureSetPoint=" + this.pressureSetPoint + ", pressureMonitoringLimitAlgorithm=" + this.pressureMonitoringLimitAlgorithm + ", pressureMonitoringLimitAlgorithmParameters=" + this.pressureMonitoringLimitAlgorithmParameters + ", pressureMonitoringTransitionAlgorithm=" + this.pressureMonitoringTransitionAlgorithm + ", pressureMonitoringTransitionAlgorithmParameters=" + this.pressureMonitoringTransitionAlgorithmParameters + '}';
    }
}

