/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.time.Duration;
import org.lsst.ccs.AlertService;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.power.states.RebPowerState;
import org.lsst.ccs.subsystem.teststand.AP9630UPSDevice;
import org.lsst.ccs.subsystem.teststand.TS7;
import org.lsst.ccs.subsystem.teststand.alerts.TS7Alerts;
import org.lsst.ccs.subsystem.teststand.data.TS7Outlets;
import org.lsst.ccs.utilities.logging.Logger;

public class UPSMonitor {
    private static final int UPS_BATTERY_TIME = 30000;
    private static final int UPS_COLD_1_OFF_TIME = 32000;
    private static final int UPS_COLD_2_OFF_TIME = 34000;
    private static final int UPS_REBS_OFF_TIME = 154000;
    private static final int UPS_VAC_REM_TIME = 600;
    private final TS7 ts7;
    private final AP9630UPSDevice upsDevc;
    private final Logger log;
    private final AgentPeriodicTaskService pts;
    private final AlertService als;
    private long upsDownTime = 0L;
    private long upsOfflineTime = 0L;
    private UPSLoadState upsState = UPSLoadState.NOMINAL;

    public UPSMonitor(TS7 ts7, AP9630UPSDevice upsDevc, Logger log, AgentPeriodicTaskService pts, AlertService als) {
        this.ts7 = ts7;
        this.upsDevc = upsDevc;
        this.log = log;
        this.pts = pts;
        this.als = als;
        pts.scheduleAgentPeriodicTask(new AgentPeriodicTask("ups-timer", () -> this.monitorUPS()));
        pts.setPeriodicTaskPeriod("ups-timer", Duration.ofSeconds(1L));
    }

    private void monitorUPS() {
        int status;
        block34: {
            status = 0;
            try {
                status = this.upsDevc.getStatus();
                if (this.upsOfflineTime == -1L) {
                    this.als.raiseAlert(TS7Alerts.UPS_DISCONNECTED.getAlert(), AlertState.NOMINAL, "");
                }
                this.upsOfflineTime = 0L;
            }
            catch (DriverException e) {
                if (this.upsOfflineTime == 0L) {
                    this.log.error((Object)("Error reading UPS status: " + (Object)((Object)e)));
                    this.upsOfflineTime = System.currentTimeMillis();
                    return;
                }
                if (this.upsOfflineTime <= 0L) break block34;
                if (System.currentTimeMillis() - this.upsOfflineTime <= 15000L) {
                    return;
                }
                this.upsOfflineTime = -1L;
                this.als.raiseAlert(TS7Alerts.UPS_DISCONNECTED.getAlert(), AlertState.ALARM, "");
            }
        }
        int downTime = this.upsDownTime == 0L ? 0 : (int)(System.currentTimeMillis() - this.upsDownTime);
        switch (this.upsState) {
            case NOMINAL: {
                if (status == 0) break;
                this.upsDownTime = System.currentTimeMillis();
                this.upsState = UPSLoadState.ON_BATTERY;
                this.als.raiseAlert(TS7Alerts.UPS_ON_BATTERY.getAlert(), AlertState.WARNING, "");
                break;
            }
            case ON_BATTERY: {
                if (status == 0) {
                    this.upsDownTime = 0L;
                    this.upsState = UPSLoadState.NOMINAL;
                    this.als.raiseAlert(TS7Alerts.UPS_ON_BATTERY.getAlert(), AlertState.NOMINAL, "");
                    break;
                }
                if (downTime < 30000) break;
                this.upsState = UPSLoadState.COLD_1_OFF;
                this.als.raiseAlert(TS7Alerts.UPS_ON_BATTERY.getAlert(), AlertState.ALARM, "");
                if (this.ts7.isAlertResponseEnabled()) {
                    try {
                        this.log.info((Object)"Powering off cold plate refrigerator 1");
                        this.ts7.turnOutletOff(TS7Outlets.COLDPLATEREFRIGERATOR_1);
                    }
                    catch (DriverException e) {
                        this.log.error((Object)("Error powering off cold plate refrigerator 1: " + (Object)((Object)e)));
                    }
                    break;
                }
                this.log.info((Object)"Powering off cold plate refrigerator 1 was disabled");
                break;
            }
            case COLD_1_OFF: {
                if (downTime < 32000) break;
                this.upsState = UPSLoadState.COLD_2_OFF;
                if (this.ts7.isAlertResponseEnabled()) {
                    try {
                        this.log.info((Object)"Powering off cold plate refrigerator 2");
                        this.ts7.turnOutletOff(TS7Outlets.COLDPLATEREFRIGERATOR_2);
                    }
                    catch (DriverException e) {
                        this.log.error((Object)("Error powering off cold plate refrigerator 2: " + (Object)((Object)e)));
                    }
                    break;
                }
                this.log.info((Object)"Powering off cold plate refrigerator 2 was disabled");
                break;
            }
            case COLD_2_OFF: {
                if (downTime < 34000) break;
                this.upsState = UPSLoadState.CRYO_OFF;
                if (this.ts7.isAlertResponseEnabled()) {
                    try {
                        this.log.info((Object)"Powering off cryo plate refrigerator");
                        this.ts7.turnOutletOff(TS7Outlets.CRYOPLATEREFRIGERATOR);
                    }
                    catch (DriverException e) {
                        this.log.error((Object)("Error powering off cryo plate refrigerator: " + (Object)((Object)e)));
                    }
                    break;
                }
                this.log.info((Object)"Powering off cryo plate refrigerator was disabled");
                break;
            }
            case CRYO_OFF: {
                if (this.ts7.getCurrentRebsPowerState() == RebPowerState.OFF) {
                    this.upsState = UPSLoadState.REBS_OFF;
                    break;
                }
                if (downTime < 154000) break;
                this.upsState = UPSLoadState.REBS_OFF;
                if (this.ts7.isAlertResponseEnabled()) {
                    try {
                        this.log.info((Object)"Powering off REB power supply");
                        this.ts7.turnOutletOff(TS7Outlets.REB48VOLTPOWERSUPPLY);
                    }
                    catch (DriverException e) {
                        this.log.error((Object)("Error powering off REB power supply: " + (Object)((Object)e)));
                    }
                    break;
                }
                this.log.info((Object)"Powering off REB power supply was disabled");
                break;
            }
            case REBS_OFF: {
                int remTime;
                if (status == 0) {
                    this.upsDownTime = 0L;
                    this.upsState = UPSLoadState.NOMINAL;
                    this.als.raiseAlert(TS7Alerts.UPS_ON_BATTERY.getAlert(), AlertState.NOMINAL, "");
                    break;
                }
                try {
                    remTime = this.upsDevc.getRemTime();
                }
                catch (DriverException e) {
                    this.log.error((Object)("Error reading remaining UPS time: " + (Object)((Object)e)));
                    break;
                }
                if (remTime >= 600) break;
                this.upsState = UPSLoadState.ALL_OFF;
                if (this.ts7.isAlertResponseEnabled()) {
                    try {
                        this.log.info((Object)"Powering off vacuum valve");
                        this.ts7.turnOutletOff(TS7Outlets.VACUUMVALVE);
                        this.log.info((Object)"Powering off vacuum turbo pump");
                        this.ts7.turnOutletOff(TS7Outlets.TURBOPUMP);
                        this.log.info((Object)"Powering off vacuum roughing pump");
                        this.ts7.turnOutletOff(TS7Outlets.ROUGHINGPUMP);
                    }
                    catch (DriverException e) {
                        this.log.error((Object)("Error powering off vacuum components: " + (Object)((Object)e)));
                    }
                    break;
                }
                this.log.info((Object)"Powering off vacuum components was disabled");
                break;
            }
            case ALL_OFF: {
                if (status != 0) break;
                this.upsDownTime = 0L;
                this.upsState = UPSLoadState.NOMINAL;
                this.als.raiseAlert(TS7Alerts.UPS_ON_BATTERY.getAlert(), AlertState.NOMINAL, "");
            }
        }
    }

    private static enum UPSLoadState {
        NOMINAL,
        ON_BATTERY,
        COLD_1_OFF,
        COLD_2_OFF,
        CRYO_OFF,
        REBS_OFF,
        ALL_OFF;

    }
}

