/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.util.ArrayList;
import java.util.List;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.subsystem.teststand.limits.AlgorithmFactory;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.LimitsInterface;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;
import org.python.google.common.base.Strings;

public class ThermalConfiguration {
    @ConfigurationParameter(category="thermal")
    double coldSetPoint;
    @ConfigurationParameter(category="thermal")
    double cryoSetPoint;
    @ConfigurationParameter(category="thermal")
    String coldMonitoringLimitAlgorithm;
    @ConfigurationParameter(category="thermal")
    String cryoMonitoringLimitAlgorithm;
    @ConfigurationParameter(category="thermal")
    List<Double> coldMonitoringLimitAlgorithmParameters;
    @ConfigurationParameter(category="thermal")
    List<Double> cryoMonitoringLimitAlgorithmParameters;
    @ConfigurationParameter(category="thermal")
    String coldMonitoringTransitionAlgorithm;
    @ConfigurationParameter(category="thermal")
    String cryoMonitoringTransitionAlgorithm;
    @ConfigurationParameter(category="thermal")
    List<Double> coldMonitoringTransitionAlgorithmParameters = new ArrayList<Double>();
    @ConfigurationParameter(category="thermal")
    List<Double> cryoMonitoringTransitionAlgorithmParameters = new ArrayList<Double>();

    LimitAlgorithm createColdLimitsAlgorithm(LimitsInterface limits) {
        LimitAlgorithm la = AlgorithmFactory.createLimitAlgorithm(this.coldMonitoringLimitAlgorithm);
        la.init(this.coldMonitoringLimitAlgorithmParameters, limits, this.coldSetPoint);
        return la;
    }

    LimitAlgorithm createCryoLimitsAlgorithm(LimitsInterface limits) {
        LimitAlgorithm la = AlgorithmFactory.createLimitAlgorithm(this.cryoMonitoringLimitAlgorithm);
        la.init(this.cryoMonitoringLimitAlgorithmParameters, limits, this.cryoSetPoint);
        return la;
    }

    TransitionAlgorithm createColdTransitionAlgorithm(LimitAlgorithm limits, double initialValue, LimitsInterface priorLimits, long startTime) {
        if (!Strings.isNullOrEmpty((String)this.coldMonitoringTransitionAlgorithm)) {
            TransitionAlgorithm ta = AlgorithmFactory.createTransitionAlgorithm(this.coldMonitoringTransitionAlgorithm);
            ta.init(this.coldMonitoringTransitionAlgorithmParameters, limits, initialValue, priorLimits, startTime);
            return ta;
        }
        return null;
    }

    TransitionAlgorithm createCryoTransitionAlgorithm(LimitAlgorithm limits, double initialValue, LimitsInterface priorLimits, long startTime) {
        if (!Strings.isNullOrEmpty((String)this.cryoMonitoringTransitionAlgorithm)) {
            TransitionAlgorithm ta = AlgorithmFactory.createTransitionAlgorithm(this.cryoMonitoringTransitionAlgorithm);
            ta.init(this.cryoMonitoringTransitionAlgorithmParameters, limits, initialValue, priorLimits, startTime);
            return ta;
        }
        return null;
    }

    public String toString() {
        return "ThermalConfiguration{coldSetPoint=" + this.coldSetPoint + ", cryoSetPoint=" + this.cryoSetPoint + ", coldMonitoringLimitAlgorithm=" + this.coldMonitoringLimitAlgorithm + ", cryoMonitoringLimitAlgorithm=" + this.cryoMonitoringLimitAlgorithm + ", coldMonitoringLimitAlgorithmParameters=" + this.coldMonitoringLimitAlgorithmParameters + ", cryoMonitoringLimitAlgorithmParameters=" + this.cryoMonitoringLimitAlgorithmParameters + ", coldMonitoringTransitionAlgorithm=" + this.coldMonitoringTransitionAlgorithm + ", cryoMonitoringTransitionAlgorithm=" + this.cryoMonitoringTransitionAlgorithm + ", coldMonitoringTransitionAlgorithmParameters=" + this.coldMonitoringTransitionAlgorithmParameters + ", cryoMonitoringTransitionAlgorithmParameters=" + this.cryoMonitoringTransitionAlgorithmParameters + '}';
    }
}

