/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.lsst.ccs.AlertService;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.power.states.RebPowerState;
import org.lsst.ccs.subsystem.teststand.AP9630UPSDevice;
import org.lsst.ccs.subsystem.teststand.APC7900Device;
import org.lsst.ccs.subsystem.teststand.CryoDevice;
import org.lsst.ccs.subsystem.teststand.ThermalConfiguration;
import org.lsst.ccs.subsystem.teststand.UPSMonitor;
import org.lsst.ccs.subsystem.teststand.VQMDevice;
import org.lsst.ccs.subsystem.teststand.VacuumConfiguration;
import org.lsst.ccs.subsystem.teststand.data.TS7Outlets;
import org.lsst.ccs.subsystem.teststand.data.TSFullState;
import org.lsst.ccs.subsystem.teststand.data.TSState;
import org.lsst.ccs.subsystem.teststand.limits.ChannelLimits;
import org.lsst.ccs.subsystem.teststand.limits.LimitAlgorithm;
import org.lsst.ccs.subsystem.teststand.limits.Limits;
import org.lsst.ccs.subsystem.teststand.limits.TransitionAlgorithm;
import org.lsst.ccs.subsystem.teststand.states.ThermalState;
import org.lsst.ccs.subsystem.teststand.states.ThermalTarget;
import org.lsst.ccs.subsystem.teststand.states.VacuumState;
import org.lsst.ccs.subsystem.teststand.states.VacuumTarget;
import org.lsst.ccs.utilities.logging.Logger;

public class TS7
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TOP)
    Subsystem subsys;
    @LookupName
    private String name;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    CryoDevice cryoDevc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    VQMDevice vqmDevc;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    protected final Map<String, APC7900Device> pduDevicesMap = new HashMap<String, APC7900Device>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    AP9630UPSDevice upsDevc;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    ThermalConfiguration thermalConfiguration;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    VacuumConfiguration vacuumConfiguration;
    @ConfigurationParameter(isFinal=true)
    private String rebPsSubsystem = "ccs-rebps";
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService pts;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService als;
    private Channel coldPlate1;
    private Channel coldPlate2;
    private Channel cryoPlate;
    private Channel pressureDevice;
    private final Logger LOGGER = Logger.getLogger((String)this.getClass().getPackage().getName());
    private final Object initializationLock = new Object();
    private boolean initializedRebPowerState = false;
    private RebPowerState currentRebsPowerState = RebPowerState.OFF;
    private TransitionAlgorithm vacuumTransitionAlgorithm;
    private TransitionAlgorithm coldTransitionAlgorithm1;
    private TransitionAlgorithm coldTransitionAlgorithm2;
    private TransitionAlgorithm cryoTransitionAlgorithm;
    private volatile boolean alertResponseEnabled = false;
    private UPSMonitor upsMon;

    public void postInit() {
        if (this.cryoDevc == null) {
            this.LOGGER.warning((Object)"Cryo device not defined");
        }
        this.subsys.updateAgentState(new Enum[]{ThermalState.UNKNOWN, ThermalTarget.UNKNOWN, VacuumState.UNKNOWN, VacuumTarget.UNKNOWN});
        this.pts.scheduleAgentPeriodicTask(new AgentPeriodicTask("transition-timer", () -> this.updateLimits()));
        this.upsMon = new UPSMonitor(this, this.upsDevc, this.LOGGER, this.pts, this.als);
    }

    @Command(type=Command.CommandType.ACTION, description="Change the thermal goal for the subsystem")
    public void setThermalGoal(ThermalTarget goal) {
        if (!this.subsys.isInState((Enum)goal)) {
            if (goal == ThermalTarget.UNKNOWN) {
                throw new IllegalArgumentException("Cannot transition to " + goal);
            }
            this.LOGGER.info((Object)("Switching to thermal goal " + goal));
            this.configurationService.loadCategories(new String[]{"thermal:" + goal.name().toLowerCase()});
            long time = System.currentTimeMillis();
            ChannelLimits coldPlateLimits1 = new ChannelLimits(this.coldPlate1);
            Limits coldPlatePriorLimits1 = new Limits(coldPlateLimits1);
            LimitAlgorithm coldLimitsAlgorithm1 = this.thermalConfiguration.createColdLimitsAlgorithm(coldPlateLimits1);
            this.coldTransitionAlgorithm1 = this.thermalConfiguration.createColdTransitionAlgorithm(coldLimitsAlgorithm1, this.coldPlate1.getValue(), coldPlatePriorLimits1, time);
            ChannelLimits coldPlateLimits2 = new ChannelLimits(this.coldPlate2);
            Limits coldPlatePriorLimits2 = new Limits(coldPlateLimits2);
            LimitAlgorithm coldLimitsAlgorithm2 = this.thermalConfiguration.createColdLimitsAlgorithm(coldPlateLimits2);
            this.coldTransitionAlgorithm2 = this.thermalConfiguration.createColdTransitionAlgorithm(coldLimitsAlgorithm2, this.coldPlate2.getValue(), coldPlatePriorLimits2, time);
            ChannelLimits cryoPlateLimits = new ChannelLimits(this.cryoPlate);
            Limits cryoPlatePriorLimits = new Limits(cryoPlateLimits);
            LimitAlgorithm cryoLimitsAlgorithm = this.thermalConfiguration.createCryoLimitsAlgorithm(cryoPlateLimits);
            this.cryoTransitionAlgorithm = this.thermalConfiguration.createCryoTransitionAlgorithm(cryoLimitsAlgorithm, this.cryoPlate.getValue(), cryoPlatePriorLimits, time);
            ThermalState thermalState = ThermalState.AT_TARGET;
            if (coldLimitsAlgorithm1 != null) {
                boolean coldAtTarget1 = this.coldTransitionAlgorithm1.isAtTarget(this.coldPlate1.getValue(), time);
                if (!coldAtTarget1) {
                    thermalState = ThermalState.IN_TRANSITION;
                    this.coldTransitionAlgorithm1.adjustLimits(this.coldPlate1.getValue(), time);
                }
                this.LOGGER.info((Object)("Cold plate 1 state is " + (coldAtTarget1 ? "in transition" : "at target") + " current limits are " + this.coldTransitionAlgorithm1.getLimits()));
            }
            if (coldLimitsAlgorithm2 != null) {
                boolean coldAtTarget2 = this.coldTransitionAlgorithm2.isAtTarget(this.coldPlate2.getValue(), time);
                if (!coldAtTarget2) {
                    thermalState = ThermalState.IN_TRANSITION;
                    this.coldTransitionAlgorithm2.adjustLimits(this.coldPlate2.getValue(), time);
                }
                this.LOGGER.info((Object)("Cold plate 2 state is " + (coldAtTarget2 ? "in transition" : "at target") + " current limits are " + this.coldTransitionAlgorithm2.getLimits()));
            }
            if (this.cryoTransitionAlgorithm != null) {
                boolean cryoAtTarget = this.cryoTransitionAlgorithm.isAtTarget(this.cryoPlate.getValue(), time);
                if (!cryoAtTarget) {
                    thermalState = ThermalState.IN_TRANSITION;
                    this.cryoTransitionAlgorithm.adjustLimits(this.cryoPlate.getValue(), time);
                }
                this.LOGGER.info((Object)("Cryo plate state is " + (cryoAtTarget ? "in transition" : "at target") + " current limits are " + this.cryoTransitionAlgorithm.getLimits()));
            }
            this.LOGGER.info((Object)("Thermal state is now " + thermalState));
            this.subsys.updateAgentState(new Enum[]{goal, thermalState});
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Change the thermal goal for the subsystem")
    public void setVacuumGoal(VacuumTarget goal) {
        if (!this.subsys.isInState((Enum)goal)) {
            if (goal == VacuumTarget.UNKNOWN) {
                throw new IllegalArgumentException("Cannot transition to " + goal);
            }
            this.LOGGER.info((Object)("Switching to vacuum goal " + goal));
            this.configurationService.loadCategories(new String[]{"vacuum:" + goal.name().toLowerCase()});
            ChannelLimits pressureLimits = new ChannelLimits(this.pressureDevice);
            Limits priorPressureLimits = new Limits(pressureLimits);
            LimitAlgorithm la = this.vacuumConfiguration.createVacuumLimitsAlgorithm(pressureLimits);
            this.vacuumTransitionAlgorithm = this.vacuumConfiguration.createVacuumTransitionAlgorithm(la, this.pressureDevice.getValue(), priorPressureLimits, System.currentTimeMillis());
            VacuumState vacuumState = VacuumState.AT_TARGET;
            if (this.vacuumTransitionAlgorithm != null) {
                long time = System.currentTimeMillis();
                boolean vacuumAtTarget = this.vacuumTransitionAlgorithm.isAtTarget(this.pressureDevice.getValue(), time);
                if (!vacuumAtTarget) {
                    vacuumState = VacuumState.IN_TRANSITION;
                    this.vacuumTransitionAlgorithm.adjustLimits(this.pressureDevice.getValue(), time);
                }
                this.LOGGER.info((Object)("Vacuum state is " + (vacuumAtTarget ? "in transition" : "at target") + " current limits are " + this.vacuumTransitionAlgorithm.getLimits()));
            }
            this.LOGGER.info((Object)("Vacuum state is now " + vacuumState));
            this.subsys.updateAgentState(new Enum[]{goal, vacuumState});
        }
    }

    private void updateLimits() {
        long time = System.currentTimeMillis();
        if (this.subsys.isInState((Enum)VacuumState.IN_TRANSITION)) {
            double dataPoint = this.pressureDevice.getValue();
            boolean atTarget = this.vacuumTransitionAlgorithm.isAtTarget(dataPoint, time);
            if (!atTarget) {
                this.vacuumTransitionAlgorithm.adjustLimits(dataPoint, time);
            } else {
                this.vacuumTransitionAlgorithm.completeTransition(time);
                this.subsys.updateAgentState(new Enum[]{VacuumState.AT_TARGET});
            }
            this.LOGGER.info((Object)("Update: Vacuum state is " + (atTarget ? "in transition" : "at target") + " current limits are " + this.vacuumTransitionAlgorithm.getLimits()));
        }
        if (this.subsys.isInState((Enum)ThermalState.IN_TRANSITION)) {
            boolean allAtTarget = true;
            double dataPoint = this.coldPlate1.getValue();
            boolean atTarget = this.coldTransitionAlgorithm1.isAtTarget(dataPoint, time);
            if (!atTarget) {
                this.coldTransitionAlgorithm1.adjustLimits(dataPoint, time);
                allAtTarget = false;
            } else {
                this.coldTransitionAlgorithm1.completeTransition(time);
            }
            this.LOGGER.info((Object)("Update: Cold plate 1 state is " + (atTarget ? "in transition" : "at target") + " current limits are " + this.coldTransitionAlgorithm1.getLimits()));
            dataPoint = this.coldPlate2.getValue();
            atTarget = this.coldTransitionAlgorithm2.isAtTarget(dataPoint, time);
            if (!atTarget) {
                this.coldTransitionAlgorithm2.adjustLimits(dataPoint, time);
                allAtTarget = false;
            } else {
                this.coldTransitionAlgorithm2.completeTransition(time);
            }
            this.LOGGER.info((Object)("Update: Cold plate 2 state is " + (atTarget ? "in transition" : "at target") + " current limits are " + this.coldTransitionAlgorithm2.getLimits()));
            dataPoint = this.cryoPlate.getValue();
            atTarget = this.cryoTransitionAlgorithm.isAtTarget(dataPoint, time);
            if (!atTarget) {
                this.cryoTransitionAlgorithm.adjustLimits(dataPoint, time);
                allAtTarget = false;
            } else {
                this.cryoTransitionAlgorithm.completeTransition(time);
            }
            this.LOGGER.info((Object)("Update: Cryo plate state is " + (atTarget ? "in transition" : "at target") + " current limits are " + this.cryoTransitionAlgorithm.getLimits()));
            if (allAtTarget) {
                this.subsys.updateAgentState(new Enum[]{ThermalState.AT_TARGET});
            }
        }
    }

    public void postStart() {
        Predicate filter = BusMessageFilterFactory.messageOrigin((String)this.rebPsSubsystem);
        this.subsys.getMessagingAccess().addStatusMessageListener(msg -> this.handlePowerSupplyMessage(msg), filter);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full test stand subsystem state")
    public TSFullState getFullState() {
        return new TSFullState(new TSState(0, 0, this.getTickPeriod()), this.subsys.getMonitor().getFullState());
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update interval")
    public void setUpdatePeriod(@Argument(name="value", description="The tick period (ms)") int value) {
        this.setTickPeriod(value);
        this.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of PDU names")
    public List<String> getPduNames() {
        return new ArrayList<String>(this.pduDevicesMap.keySet());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of PDU outlet names")
    public List<String> getOutletNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String pduName : this.pduDevicesMap.keySet()) {
            for (String outletName : this.pduDevicesMap.get(pduName).getOutletNames()) {
                names.add(pduName + "/" + outletName);
            }
        }
        return names;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the map of PDU outlet on states")
    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        HashMap<String, Boolean> states = new HashMap<String, Boolean>();
        for (String pduName : this.pduDevicesMap.keySet()) {
            Map<String, Boolean> pduStates = this.pduDevicesMap.get(pduName).getOutletOnStateMap();
            for (String outletName : pduStates.keySet()) {
                states.put(pduName + "/" + outletName, pduStates.get(outletName));
            }
        }
        return states;
    }

    private void publishState() {
        KeyValueData data = new KeyValueData("TSState", (Serializable)new TSState(0, 0, this.getTickPeriod()));
        this.subsys.publishSubsystemDataOnStatusBus(data);
    }

    private void setTickPeriod(long period) {
        this.pts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.pts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePowerSupplyMessage(StatusMessage msg) {
        Object object = this.initializationLock;
        synchronized (object) {
            StateBundle sb;
            if (this.initializedRebPowerState && msg instanceof StatusStateChangeNotification) {
                StatusStateChangeNotification ssn = (StatusStateChangeNotification)msg;
                sb = ssn.getNewState();
            } else {
                sb = !this.initializedRebPowerState ? msg.getState() : null;
            }
            if (sb != null) {
                RebPowerState powerState = (RebPowerState)sb.getState(RebPowerState.class);
                if (powerState != null) {
                    this.initializedRebPowerState = true;
                }
                if (this.currentRebsPowerState != powerState) {
                    this.currentRebsPowerState = powerState;
                    new Thread(() -> this.updatePowerState(this.currentRebsPowerState, sb.getComponentsWithState(RebPowerState.class))).start();
                }
            }
        }
    }

    public RebPowerState getCurrentRebsPowerState() {
        return this.currentRebsPowerState;
    }

    private void updatePowerState(RebPowerState state, Map<String, Enum> map) {
        String rebStateStr = "";
        for (Map.Entry<String, Enum> e : map.entrySet()) {
            rebStateStr = rebStateStr + e.getKey() + "=" + e.getValue() + " ";
        }
        this.LOGGER.info((Object)("Updating power state to " + state + " " + rebStateStr));
    }

    @Command(type=Command.CommandType.ACTION, description="Turn Off named outlet")
    public void turnOutletOff(TS7Outlets outlet) throws DriverException {
        this.changeOutletState(outlet, false);
    }

    @Command(type=Command.CommandType.ACTION, description="Turn On named outlet")
    public void turnOutletOn(TS7Outlets outlet) throws DriverException {
        this.changeOutletState(outlet, true);
    }

    private void changeOutletState(TS7Outlets outlet, boolean on) throws DriverException {
        String outletName = outlet.getOutletName();
        for (APC7900Device pdu : this.pduDevicesMap.values()) {
            if (!pdu.getOutletNames().contains(outletName)) continue;
            if (on) {
                pdu.forceOutletOn(outletName);
            } else {
                pdu.forceOutletOff(outletName);
            }
            return;
        }
        throw new IllegalArgumentException("Could not find device to turn off outlet " + outletName);
    }

    @Command(type=Command.CommandType.ACTION, description="Enable/disable alert response")
    public void enableAlertResponse(boolean enable) {
        this.alertResponseEnabled = enable;
    }

    @Command(type=Command.CommandType.QUERY, description="Get true/false if the alert response is enabled")
    public boolean isAlertResponseEnabled() {
        return this.alertResponseEnabled;
    }
}

