/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.teststand;

import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.subsystem.teststand.KeithleyDevice;
import org.lsst.ccs.subsystem.teststand.data.TSState;

public class KeithleySimDevice
extends KeithleyDevice {
    private boolean isconnected = false;
    private double nplc = 0.0;
    private int nreads = 1;

    public KeithleySimDevice(String host, int port) throws DriverException {
        this.setState(TSState.pwrstates.ON.ordinal());
        this.isconnected = true;
    }

    public KeithleySimDevice() {
    }

    @Override
    protected void initDevice() {
        this.fullName = "Keithley module";
    }

    @Command(name="open", description="Open connection to device using defaults")
    public void open() throws DriverException {
    }

    @Override
    protected void close() {
    }

    @Override
    protected void initialize() {
        if (this.isconnected) {
            this.log.error((Object)"Keithley device is already initialized and connected to:");
            if (this.isconnected) {
                this.log.error((Object)"Setting device online.");
                this.setOnline(true);
            }
        } else {
            this.log.error((Object)"Tried to initialize undefined bias device!");
        }
    }

    @Command(name="open", description="Open connection to device")
    public String open(@Argument(name="host", description="Host name") String host) throws DriverException {
        return "Simulated Keithley Device";
    }

    @Command(name="open", description="Open connection to device")
    public String open(@Argument(name="host", description="Host name") String host, @Argument(name="port", description="Port number") int port) throws DriverException {
        return "Simulated Keithley Device";
    }

    @Command(name="openftdi", description="Open FTDI connection to device")
    public String openftdi(@Argument(name="serialname", description="Serial device name") String host, @Argument(name="baud", description="baud rate") int port) throws DriverException {
        return "Simulated Keithley Device";
    }

    @Override
    @Command(name="accumBuff", description="start the buffer accumulation")
    public double accumBuffer(@Argument(name="nreads", description="#reads (armcount)") int nreads, @Argument(name="nplc", description="#Pulse Line Counts btwn reads (0.01->60.)") double nplc, @Argument(name="wait", description="to wait (true) or not to (false)") boolean wait) {
        this.nreads = nreads;
        this.nplc = nplc;
        if (wait) {
            try {
                Thread.sleep((long)(nplc / 60.0 * (double)nreads * 1000.0));
            }
            catch (Exception e) {
                this.log.error((Object)("Sleep exception " + e));
            }
        }
        return nplc / 60.0 * (double)nreads;
    }

    @Override
    @Command(name="readBuffstr", description="read the buffer")
    public String readBufferStr() throws DriverException {
        double[][] data = this.readBuffer();
        return "Data = " + this.getString(data[0]) + "\n Times = " + this.getString(data[1]) + "\n";
    }

    @Override
    @Command(name="readBuff", description="read the buffer")
    public double[][] readBuffer() {
        double[][] vals = new double[2][this.nreads];
        for (int i = 0; i < this.nreads; ++i) {
            vals[0][i] = this.nplc / 60.0 * (double)i;
            vals[1][i] = 2.0E-4 * Math.random();
        }
        return vals;
    }

    @Override
    @Command(name="showVoltage", description="Show the set voltage")
    public double getVoltage() throws DriverException {
        return -67.89;
    }

    @Override
    @Command(name="readVoltage", description="Read the actual voltage")
    public double readVoltage() {
        double volt = -67.88 + 1.0 * Math.random();
        return volt;
    }

    @Command(name="showvoltlim", description="Show the soft voltage limit")
    public String getVoltageLimit() throws DriverException {
        return "Voltage limit = -71.0";
    }

    public double getCurrent() {
        double curr = 1.23E-12;
        return curr;
    }

    @Override
    @Command(type=Command.CommandType.ACTION, name="readCurrent", description="Read the actual current")
    public double readCurrent() {
        this.log.debug((Object)"KeithleyDevice executing readcurrent operation:");
        double curr = 1.24E-12 + Math.random() * 2.0E-13;
        return curr;
    }

    @Override
    @Command(name="showcurrlim", description="Show the soft current limit")
    public String getCurrentLimit() {
        return "Current limit = 0.001";
    }

    @Override
    @Command(name="showOutput", description="Show the output state")
    public boolean showOutput() {
        boolean state = false;
        return state;
    }
}

