/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.RebPsDevice;
import org.lsst.ccs.subsystem.power.config.RebPsEnum;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.data.PowerSupplyAgentProperties;
import org.lsst.ccs.subsystem.power.data.RebPsFullState;
import org.lsst.ccs.subsystem.power.data.RebPsState;
import org.lsst.ccs.subsystem.power.states.RebPowerState;
import org.lsst.ccs.utilities.logging.Logger;

public class RebPower
implements HasLifecycle,
RebPsDevice.Event {
    private final Logger sLog = Logger.getLogger((String)"org.lsst.ccs.subsystem.power");
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Monitor mon;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private PowerDevice mainPs;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private RebPsDevice psDevice;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    private final List<Channel> rebPowerChannels = new ArrayList<Channel>();
    @ConfigurationParameter
    private double[] powerStateTransitionLimits = new double[]{0.2, 8.0, 15.0};
    private long updateStateMillis = 1000L;
    @ConfigurationParameter
    private double powerStateTransitionHysteresisPercentage = 0.01;
    private Map<String, Double> rebPower = new HashMap<String, Double>();
    private Map<String, Double> rebSimulatedPower = new HashMap<String, Double>();
    private boolean isSimulated;

    public void init() {
        AgentPeriodicTask periodicTask = new AgentPeriodicTask("reb-power-state", () -> this.updateRebPowerState()).withPeriod(Duration.ofMillis(this.updateStateMillis));
        this.periodicTaskService.scheduleAgentPeriodicTask(periodicTask);
        this.isSimulated = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.run.mode", "").equals("simulation");
    }

    public void postInit() {
        this.subsys.setAgentProperty(PowerSupplyAgentProperties.POWER_SUPPLY_TYPE_AGENT_PROPERTY, RebPower.class.getCanonicalName());
        if (this.mainPs == null) {
            this.sLog.warning((Object)"No main power supply device specified");
        }
        if (this.psDevice == null) {
            this.sLog.error((Object)"No REB power devices specified");
        } else {
            this.psDevice.setListener(this);
        }
        for (Map.Entry<String, Channel> entry : this.channels.entrySet()) {
            String channelName = entry.getKey();
            if (!channelName.endsWith(".Power")) continue;
            this.sLog.fine((Object)("Adding power channel " + channelName));
            this.rebPowerChannels.add(entry.getValue());
        }
        StateBundle sb = new StateBundle(new Enum[]{RebPowerState.OFF});
        for (Channel ch : this.rebPowerChannels) {
            String rebName = ch.getName();
            sb.setComponentState(rebName, new Enum[]{RebPowerState.OFF});
            if (this.isSimulated) {
                this.rebSimulatedPower.put(rebName, 0.0);
            }
            this.rebPower.put(rebName, 0.0);
        }
        this.subsys.updateAgentState(sb);
    }

    @Command(type=Command.CommandType.ACTION, description="Set simulated reb power")
    public void setSimulatedRebPower(@Argument(name="rebName") String rebName, @Argument(name="rebPower", description="The simulated Reb Total power") double rebPower) {
        this.rebSimulatedPower.put(rebName, rebPower);
    }

    private void updateRebPowerState() {
        StateBundle sb = new StateBundle(new Enum[0]);
        double totalPower = 0.0;
        double oldTotalPower = 0.0;
        for (Channel ch : this.rebPowerChannels) {
            String rebName = ch.getName();
            double rebPowerValue = this.isSimulated ? this.rebSimulatedPower.get(rebName).doubleValue() : ch.getValue();
            totalPower += rebPowerValue;
            oldTotalPower += this.rebPower.get(rebName).doubleValue();
            if (!this.isChangeSignificant(rebPowerValue, this.rebPower.get(rebName))) continue;
            this.rebPower.put(rebName, rebPowerValue);
            sb.setComponentState(rebName, new Enum[]{this.getRebPowerState(rebPowerValue)});
        }
        if (this.isChangeSignificant(totalPower, oldTotalPower)) {
            sb.setState(new Enum[]{this.getRebPowerState(totalPower / 3.0)});
        }
        if (!this.subsys.isInState(sb)) {
            this.sLog.fine((Object)("Changing Rebs Power State to " + sb));
            this.subsys.updateAgentState(sb);
        }
    }

    private RebPowerState getRebPowerState(double value) {
        if (value < this.powerStateTransitionLimits[0]) {
            return RebPowerState.OFF;
        }
        if (value < this.powerStateTransitionLimits[1]) {
            return RebPowerState.ON;
        }
        if (value < this.powerStateTransitionLimits[2]) {
            return RebPowerState.LOW_POWER;
        }
        return RebPowerState.OPERATIONAL;
    }

    private boolean isChangeSignificant(double newValue, double oldValue) {
        return Math.abs(newValue - oldValue) > this.powerStateTransitionHysteresisPercentage * oldValue;
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private long getTickPeriod() {
        return this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    public void postStart() throws HardwareException {
        this.sLog.info((Object)"REB PS subsystem started");
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update period")
    public void setUpdatePeriod(@Argument(name="period", description="The tick period (msecs)") int period) {
        this.setTickPeriod(period);
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Turn the main power supply on or off")
    public void setMainPower(@Argument(name="on", description="Whether on or off") boolean on) throws Exception {
        try {
            if (on) {
                this.mainPs.powerOn();
                this.psDevice.checkOnline();
            } else {
                this.psDevice.sequencePower(false);
                this.mainPs.powerOff();
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Toggle the main power supply state")
    public void toggleMainPower() throws Exception {
        this.setMainPower(this.getMainState() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Turns a power supply on or off")
    public void setPowerOn(@Argument(name="reb", description="REB number") int reb, @Argument(name="ps", description="Power supply number") int ps, @Argument(name="on", description="Whether on or off") boolean on) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.setPowerOn(reb, ps, on);
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turns a power supply on or off")
    public void setNamedPowerOn(@Argument(name="reb", description="REB number") int reb, @Argument(name="name", description="Power supply name") RebPsEnum psEnum, @Argument(name="on", description="Whether on or off") boolean on) throws PowerException {
        this.setPowerOn(reb, psEnum.getNumber(), on);
    }

    @Command(type=Command.CommandType.ACTION, description="Toggle a power supply")
    public void togglePower(@Argument(name="reb", description="REB number") int reb, @Argument(name="ps", description="Power supply number") int ps) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.togglePower(reb, ps);
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Toggle a power supply")
    public void toggleNamedPower(@Argument(name="reb", description="REB number") int reb, @Argument(name="name", description="Power supply name") RebPsEnum psEnum) throws PowerException {
        this.togglePower(reb, psEnum.getNumber());
    }

    @Command(type=Command.CommandType.ACTION, description="Sequence a power supply")
    public void sequencePower(@Argument(name="reb", description="REB number") int reb, @Argument(name="on", description="Whether to turn on") boolean on) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.sequencePower(reb, on);
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a HV bias DAC")
    public void setBiasDac(@Argument(name="reb", description="REB number") int reb, @Argument(name="value", description="DAC value") double value) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.setBiasDac(reb, value);
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a DPHI DAC")
    public void setDphiDac(@Argument(name="reb", description="REB number") int reb, @Argument(name="value", description="DAC value") double value) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.setDphiDac(reb, value);
            }
        }
        finally {
            this.publishState();
            this.mon.setPublishData();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public RebPsFullState getFullState() throws Exception {
        return new RebPsFullState(this.getState(), this.mon.getFullState());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the error counters")
    public int[] getErrors() {
        if (this.psDevice != null) {
            return this.psDevice.getErrors();
        }
        return new int[]{0, 0};
    }

    @Command(type=Command.CommandType.ACTION, description="Terminate the program")
    public void quit() {
        System.exit(0);
    }

    void publishState() {
        KeyValueData kvd = new KeyValueData("RebPsState", (Serializable)this.getState());
        this.subsys.publishSubsystemDataOnStatusBus(kvd);
    }

    RebPsState getState() {
        String psId = "PS-X";
        int[] psState = new int[]{};
        double[] biasDacs = new double[]{};
        double[] dphiDacs = new double[]{};
        if (this.psDevice != null) {
            psId = this.psDevice.getPsId();
            try {
                psState = this.psDevice.getState();
            }
            catch (PowerException powerException) {
                // empty catch block
            }
            try {
                biasDacs = this.psDevice.getBiasDacs();
            }
            catch (PowerException powerException) {
                // empty catch block
            }
            try {
                dphiDacs = this.psDevice.getDphiDacs();
            }
            catch (PowerException powerException) {
                // empty catch block
            }
        }
        return new RebPsState((int)this.getTickPeriod(), this.getMainState(), psState, biasDacs, dphiDacs, psId);
    }

    int getMainState() {
        int state = -1;
        if (this.mainPs != null && this.mainPs.isOnline()) {
            try {
                List<PowerChanState> pcState = this.mainPs.getPowerState();
                if (!pcState.isEmpty()) {
                    state = pcState.get(0).getState();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return state;
    }

    @Override
    public void opened() {
        this.publishState();
    }

    @Override
    public void closed() {
        this.publishState();
    }
}

