/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.dsp;

import org.lsst.ccs.utilities.dsp.FIRFilter;

public class FilterFactory {
    public static FIRFilter getHighPassFIR(double rate, double attenuation, double f1) {
        return FilterFactory.getFIRFilter(rate, attenuation, f1, -1.0, FilterType.HIGH_PASS);
    }

    public static FIRFilter getBandPassFIR(double rate, double attenuation, double f1, double f2) {
        return FilterFactory.getFIRFilter(rate, attenuation, f1, f2, FilterType.BAND_PASS);
    }

    public static FIRFilter getLowPassFIR(double rate, double attenuation, double f2) {
        return FilterFactory.getFIRFilter(rate, attenuation, -1.0, f2, FilterType.LOW_PASS);
    }

    public static FIRFilter getFIRFilter(double rate, double attenuation, double f1, double f2, FilterType type) {
        FilterSpecs spec = new FilterSpecs();
        spec.setFN(rate / 2.0).setAttenuation(attenuation).setLowFrequency(f1).setHighFrequency(f2).setType(type);
        if (f1 > 0.0) {
            spec.setTransitionBandwidth(f1 / 5.0);
        } else {
            spec.setTransitionBandwidth(f2 / 5.0);
        }
        return FilterFactory.getFIRFilter(spec);
    }

    public static FIRFilter getFIRFilter(FilterSpecs spec) {
        int i;
        int n;
        if (spec.order < 1) {
            spec.order = FilterFactory.estimatedFIROrder(spec);
        }
        double alpha = 0.0;
        if (spec.getAttenuation() >= 50.0) {
            alpha = 0.1102 * (spec.getAttenuation() - 8.7);
        } else if (spec.getAttenuation() > 21.0) {
            alpha = 0.5842 * Math.exp(0.4 * Math.log(spec.getAttenuation() - 21.0)) + 0.07886 * (spec.getAttenuation() - 21.0);
        }
        if (spec.getAttenuation() <= 21.0) {
            alpha = 0.0;
        }
        double I0alpha = FilterFactory.I0(alpha);
        int m = spec.order / 2;
        double[] win = new double[m + 1];
        for (int n2 = 1; n2 <= m; ++n2) {
            win[n2] = FilterFactory.I0(alpha * Math.sqrt(1.0 - FilterFactory.sqr((double)n2 / (double)m))) / I0alpha;
        }
        double w0 = 0.0;
        double w1 = 0.0;
        switch (spec.type) {
            case LOW_PASS: {
                w0 = 0.0;
                w1 = Math.PI * (spec.getHighFrequency() + 0.5 * spec.getTransitionBandwidth()) / spec.fN;
                break;
            }
            case HIGH_PASS: {
                w0 = Math.PI;
                w1 = Math.PI * (1.0 - (spec.getLowFrequency() - 0.5 * spec.getTransitionBandwidth()) / spec.fN);
                break;
            }
            case BAND_PASS: {
                w0 = 1.5707963267948966 * (spec.getLowFrequency() + spec.getHighFrequency()) / spec.fN;
                w1 = 1.5707963267948966 * (spec.getHighFrequency() - spec.getLowFrequency() + spec.getTransitionBandwidth()) / spec.fN;
            }
        }
        double[] a = new double[spec.order + 1];
        a[0] = w1 / Math.PI;
        for (n = 1; n <= m; ++n) {
            a[n] = Math.sin((double)n * w1) * Math.cos((double)n * w0) * win[n] / ((double)n * Math.PI);
        }
        for (n = m + 1; n <= spec.order; ++n) {
            a[n] = a[n - m];
        }
        for (n = 0; n <= m - 1; ++n) {
            a[n] = a[spec.order - n];
        }
        a[m] = w1 / Math.PI;
        double g = 0.0;
        for (i = 1; i < spec.order + 1; ++i) {
            g += a[i];
        }
        i = 1;
        while (i < spec.order + 1) {
            int n3 = i++;
            a[n3] = a[n3] / g;
        }
        return new FIRFilter(a);
    }

    private static int estimatedFIROrder(FilterSpecs spec) {
        int o = 2 * (int)((spec.getAttenuation() - 7.95) / (14.36 * spec.getTransitionBandwidth() / spec.getFN()) + 1.0);
        return o;
    }

    private static final double sqr(double x) {
        return x * x;
    }

    private static double I0(double x) {
        double x2;
        double eps = 1.0E-6;
        double fact = 1.0;
        double p = x2 = 0.5 * x;
        double t = p * p;
        double s = 1.0 + t;
        int k = 2;
        while (t > eps) {
            t = FilterFactory.sqr((p *= x2) / (fact *= (double)k));
            s += t;
            ++k;
        }
        return s;
    }

    public static void main(String[] args) {
        int i;
        FIRFilter f = FilterFactory.getHighPassFIR(300.0, 30.0, 60.0);
        f.print();
        double[] sig = new double[1000];
        double[] sigf = new double[1000];
        for (i = 0; i < 1000; ++i) {
            sig[i] = Math.cos(62.83185307179586 * ((double)i / 300.0)) + Math.cos(879.645943005142 * (double)(i / 300));
            sigf[i] = f.apply(sig[i]);
        }
        for (i = 0; i < 980; ++i) {
            System.out.println(sig[i] + " " + sigf[i + 20] + " " + Math.cos(62.83185307179586 * ((double)i / 300.0)));
        }
    }

    public static final class FilterSpecs {
        FilterType type = FilterType.LOW_PASS;
        int order = -1;
        double lowFrequency = 0.0;
        double highFrequency = 10000.0;
        double transitionBandwidth = 5000.0;
        double attenuation = 60.0;
        double fN = 150.0;

        public double getAttenuation() {
            return this.attenuation;
        }

        public FilterSpecs setAttenuation(double attenuation) {
            this.attenuation = attenuation;
            return this;
        }

        public double getFN() {
            return this.fN;
        }

        public FilterSpecs setFN(double fn) {
            this.fN = fn;
            return this;
        }

        public double getHighFrequency() {
            return this.highFrequency;
        }

        public FilterSpecs setHighFrequency(double highFrequency) {
            this.highFrequency = highFrequency;
            return this;
        }

        public double getLowFrequency() {
            return this.lowFrequency;
        }

        public FilterSpecs setLowFrequency(double lowFrequency) {
            this.lowFrequency = lowFrequency;
            return this;
        }

        public int getOrder() {
            return this.order;
        }

        public FilterSpecs setOrder(int order) {
            this.order = order;
            return this;
        }

        public double getTransitionBandwidth() {
            return this.transitionBandwidth;
        }

        public FilterSpecs setTransitionBandwidth(double transitionBandwidth) {
            this.transitionBandwidth = transitionBandwidth;
            return this;
        }

        public FilterType getType() {
            return this.type;
        }

        public FilterSpecs setType(FilterType type) {
            this.type = type;
            return this;
        }
    }

    public static enum FilterType {
        LOW_PASS,
        BAND_PASS,
        HIGH_PASS;

    }
}

