/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.SequencerUtils;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.SequencerData;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;

public class SequencerProc {
    private static final Map<FPGA2Model.PointerInfo.PointerKind, Integer> pointerTypeMap = new HashMap<FPGA2Model.PointerInfo.PointerKind, Integer>();
    private final BaseSet bss;
    private final SequencerUtils seq;
    private Map<String, Integer> mainsMap;
    private Map<Integer, String> invMainsMap;
    private Map<String, Integer> subroutineMap;
    private Map<Integer, String> invSubroutineMap;
    private Map<String, Integer> functionMap;
    private Map<Integer, String> invFunctionMap;
    private final Map<String, Integer> pointerMap = new HashMap<String, Integer>();
    private int zeroReg;

    public SequencerProc(BaseSet bss) {
        this.bss = bss;
        this.seq = new SequencerUtils(bss);
    }

    public int loadSequencer(String fileName) throws Exception {
        int nSlice;
        for (int j = 0; j < 1024; j += 16) {
            this.bss.write(0x300000 + j + 15, 0);
        }
        if (fileName.endsWith(".sif")) {
            nSlice = this.seq.loadFile(fileName);
            this.mainsMap = null;
            this.pointerMap.clear();
        } else {
            nSlice = this.loadSequencerXML(fileName);
        }
        this.zeroReg = 0;
        for (int j = 0; j < 1024; j += 16) {
            if (this.bss.read(0x300000 + j + 15) != 0) continue;
            this.zeroReg = 0x300000 + j + 15;
        }
        return nSlice;
    }

    private int loadSequencerXML(String fileName) throws Exception {
        FPGA2Model model = null;
        try {
            if (fileName.startsWith("/")) {
                model = new FPGA2ModelBuilder().compileFile(new File(fileName));
            } else {
                InputStream sequencerFileInputStream = BootstrapResourceUtils.getBootstrapResource((String)fileName);
                if (sequencerFileInputStream == null) {
                    throw new RuntimeException("Could not load sequencer file " + fileName);
                }
                model = new FPGA2ModelBuilder().compileFile(sequencerFileInputStream, "xml");
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Exception ec = (Exception)e.getCause();
            ec = ec == null ? e : ec;
            throw ec;
        }
        this.mainsMap = model.getMainAddresses();
        this.invMainsMap = this.invertMap(this.mainsMap);
        this.subroutineMap = model.getSubroutineAddresses();
        this.invSubroutineMap = this.invertMap(this.subroutineMap);
        this.functionMap = model.getFunctionAddresses();
        this.invFunctionMap = this.invertMap(this.functionMap);
        List<FPGA2Model.PointerInfo> pointerList = model.getPointers();
        for (FPGA2Model.PointerInfo pi : pointerList) {
            int type = pointerTypeMap.get((Object)pi.getKind());
            this.pointerMap.put(pi.getName(), pi.getOffset() | type << 8);
        }
        this.seq.clearCache();
        for (int[] command : model.getCommands()) {
            switch (command[0]) {
                case 0: {
                    int lines = 0;
                    for (int j = 3; j < command.length; ++j) {
                        lines |= 1 << command[j];
                    }
                    this.seq.writeLines(command[1], command[2], lines);
                    break;
                }
                case 1: {
                    this.seq.writeTimes(command[1], command[2], command[3]);
                    break;
                }
                case 2: {
                    this.seq.writeProgExec(command[1], command[2], command[3]);
                    break;
                }
                case 6: {
                    this.seq.writeProgExec(command[1], 1, command[2], command[3]);
                    this.seq.writeExecFunc(command[2], command[4]);
                    break;
                }
                case 7: {
                    this.seq.writeProgExec(command[1], 2, command[2], command[3]);
                    this.seq.writeExecCount(command[3], command[4]);
                    break;
                }
                case 8: {
                    this.seq.writeProgExec(command[1], 3, command[2], command[3]);
                    this.seq.writeExecFunc(command[2], command[4]);
                    this.seq.writeExecCount(command[3], command[5]);
                    break;
                }
                case 3: {
                    this.seq.writeProgJump(command[1], command[2], command[3]);
                    break;
                }
                case 9: {
                    this.seq.writeProgJump(command[1], 1, command[2], command[3]);
                    this.seq.writeJumpSubr(command[2], command[4]);
                    break;
                }
                case 10: {
                    this.seq.writeProgJump(command[1], 2, command[2], command[3]);
                    this.seq.writeJumpCount(command[3], command[4]);
                    break;
                }
                case 11: {
                    this.seq.writeProgJump(command[1], 3, command[2], command[3]);
                    this.seq.writeJumpSubr(command[2], command[4]);
                    this.seq.writeJumpCount(command[3], command[5]);
                    break;
                }
                case 4: {
                    this.seq.writeProgEndSubr(command[1]);
                    break;
                }
                case 5: {
                    this.seq.writeProgEnd(command[1]);
                    break;
                }
            }
        }
        int nSlice = this.seq.getCacheSliceCount();
        int version = this.seq.getVersion();
        if (version == 3) {
            this.seq.writeStartAddr(0);
        } else if (version == 0) {
            this.seq.writeSliceCount(nSlice);
        }
        return nSlice;
    }

    public List<String> getMains() {
        if (this.mainsMap == null) {
            return null;
        }
        return new ArrayList<String>(this.mainsMap.keySet());
    }

    public Map<String, Integer> getMainMap() {
        return this.mainsMap;
    }

    public Map<String, Integer> getSubroutineMap() {
        return this.subroutineMap;
    }

    public Map<String, Integer> getFunctionMap() {
        return this.functionMap;
    }

    public Map<String, Integer> getPointers() {
        return this.pointerMap;
    }

    public int[] getImageRegisters() {
        int[] registers = new int[9];
        for (int reg : SequencerData.imageRegs.keySet()) {
            int addr = this.zeroReg;
            Integer desc = this.pointerMap.get(SequencerData.imageRegs.get(reg));
            if (desc != null) {
                int type = desc >> 8;
                int index = desc & 0xFF;
                if (type == 2) {
                    addr = 0x360000 + index;
                }
                if (type == 3) {
                    addr = 0x380000 + index;
                }
            }
            registers[reg] = addr;
        }
        return registers;
    }

    public int setStart(String mainName) throws REBException, RaftException {
        Integer addr;
        if (this.mainsMap != null && (addr = this.mainsMap.get(mainName)) != null) {
            this.seq.writeStartAddr(addr.intValue());
            return this.seq.getCacheSliceCount();
        }
        throw new RaftException("Unknown main program name: " + mainName);
    }

    public int setStart(int address) throws REBException {
        this.seq.writeStartAddr(address);
        return this.seq.getCacheSliceCount();
    }

    public void setParameter(String parmName, int value) throws REBException, RaftException {
        Integer typeAddr;
        if (this.pointerMap != null && (typeAddr = this.pointerMap.get(parmName)) != null) {
            int type = typeAddr >> 8;
            int addr = typeAddr & 0xFF;
            switch (type) {
                case 0: {
                    this.seq.writeExecFunc(addr, value);
                    break;
                }
                case 2: {
                    this.seq.writeExecCount(addr, value);
                    break;
                }
                case 1: {
                    this.seq.writeJumpSubr(addr, value);
                    break;
                }
                case 3: {
                    this.seq.writeJumpCount(addr, value);
                }
            }
            return;
        }
        throw new RaftException("Unknown parameter name: " + parmName);
    }

    public int getParameter(String parmName) throws REBException, RaftException {
        Integer typeAddr;
        if (this.pointerMap != null && (typeAddr = this.pointerMap.get(parmName)) != null) {
            int type = typeAddr >> 8;
            int addr = typeAddr & 0xFF;
            int value = 0;
            switch (type) {
                case 0: {
                    value = this.seq.readExecFunc(addr);
                    break;
                }
                case 2: {
                    value = this.seq.readExecCount(addr);
                    break;
                }
                case 1: {
                    value = this.seq.readJumpSubr(addr);
                    break;
                }
                case 3: {
                    value = this.seq.readJumpCount(addr);
                }
            }
            return value;
        }
        throw new RaftException("Unknown parameter name: " + parmName);
    }

    public void setCcdMask(int ccdMask) throws REBException {
        this.seq.writeStripeSelect(ccdMask);
    }

    public int getDataSource() throws REBException {
        return this.seq.readDataSource();
    }

    public void setDataSource(int value) throws REBException {
        this.seq.writeDataSource(value);
    }

    public boolean isScanEnabled() throws REBException {
        return this.seq.isScanEnabled();
    }

    public void enableScan(boolean value) throws REBException {
        this.seq.enableScan(value);
    }

    public void resetScan() throws REBException {
        this.seq.resetScan();
    }

    public int getErrorAddr() throws REBException {
        return this.seq.getErrorAddr();
    }

    public void resetError() throws REBException {
        this.seq.resetError();
    }

    public void startSequencer() throws REBException {
        this.resetError();
        this.seq.enable();
    }

    public void sendStop() throws REBException {
        this.seq.sendStop();
    }

    public void sendStep() throws REBException {
        this.seq.sendStep();
    }

    public boolean isRunning() throws REBException {
        return this.seq.isEnabled();
    }

    public void waitDone(int timeout) throws REBException {
        this.seq.waitDone(timeout);
    }

    private Map<Integer, String> invertMap(Map<String, Integer> map) {
        HashMap<Integer, String> invMap = new HashMap<Integer, String>();
        for (Map.Entry<String, Integer> e : map.entrySet()) {
            invMap.put(e.getValue(), e.getKey());
        }
        return invMap;
    }

    static {
        pointerTypeMap.put(FPGA2Model.PointerInfo.PointerKind.FUNCTION, 0);
        pointerTypeMap.put(FPGA2Model.PointerInfo.PointerKind.SUBROUTINE, 1);
        pointerTypeMap.put(FPGA2Model.PointerInfo.PointerKind.REPEAT_FUNCTION, 2);
        pointerTypeMap.put(FPGA2Model.PointerInfo.PointerKind.REPEAT_SUBROUTINE, 3);
    }
}

