/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.ComponentConfigurationEnvironment;
import org.lsst.ccs.SubsystemConfigurationEnvironment;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reb.Aspic;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.Cabac;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.ImageMetadata;
import org.lsst.ccs.drivers.reb.PowerAdcs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;
import org.lsst.ccs.drivers.reb.SlowAdcs;
import org.lsst.ccs.drivers.reb.StatusSet;
import org.lsst.ccs.drivers.reb.TempAdcs;
import org.lsst.ccs.drivers.reb.TempRtds;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.rafts.AspicControl;
import org.lsst.ccs.subsystem.rafts.BiasControl;
import org.lsst.ccs.subsystem.rafts.CabacControl;
import org.lsst.ccs.subsystem.rafts.DacControl;
import org.lsst.ccs.subsystem.rafts.ImageProc;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.config.ASPIC;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.config.CABAC;
import org.lsst.ccs.subsystem.rafts.config.REB;
import org.lsst.ccs.subsystem.rafts.data.ImageData;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.RegisterData;
import org.lsst.ccs.subsystem.rafts.data.StatusData;
import org.lsst.ccs.utilities.logging.Logger;

public class REBDevice
extends Device {
    protected static final String ID = "id";
    protected static final String IFC_NAME = "ifcName";
    protected static final String CCD_MASK = "ccdMask";
    static final String RAFTS = "Rafts";
    static final String RAFTS_LIMITS = "RaftsLimits";
    public static final int TYPE_BD_TEMP = 0;
    public static final int TYPE_BD_POWER = 1;
    public static final int TYPE_RTD = 2;
    public static final int TYPE_ASP_TEMP = 3;
    public static final int TYPE_BIAS_VOLT = 4;
    public static final int TYPE_CCD_CURR = 5;
    public static final int TYPE_CR_VOLT = 6;
    public static final int TYPE_HEATER = 7;
    public static final int CHAN_TOTAL_POWER = -1;
    public static final int CHAN_HTR_VOLTS = 0;
    public static final int CHAN_HTR_POWER = 1;
    public static final int NUM_HTR_CHANS = 2;
    public static final int CHAN_RTD_INT_TEMP = 4;
    public static final int CHAN_RTD_INT_VOLT = 5;
    public static final int NUM_RTD_CHANS = 6;
    static final int REB_NUM_MASK = 3;
    static final int RAFT_NUM_MASK = 31;
    static final int RAFT_NUM_SHIFT = 2;
    static final double DAC_SCALE = 273.0666;
    static final double HEATER_OHMS = 20.0;
    private static final Map<String, Integer> hdwTypeMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> typeMap;
    @ConfigurationParameter(name="id", category="Rafts")
    protected int id;
    @ConfigurationParameter(name="ccdMask", category="Rafts")
    protected int ccdMask;
    @ConfigurationParameter(name="ifcName", category="Rafts")
    protected String ifcName;
    private String hdwType = "daq1";
    private int rebType = 0;
    private final BaseSet bss = new BaseSet();
    private final StatusSet sts = new StatusSet(this.bss);
    private final TempAdcs tmp = new TempAdcs(this.bss);
    private final PowerAdcs pwr = new PowerAdcs(this.bss);
    private final SlowAdcs slow = new SlowAdcs(this.bss);
    private final TempRtds rtd = new TempRtds(this.bss);
    private final BoardDacs dac = new BoardDacs(this.bss);
    private final Aspic asp = new Aspic(this.bss);
    private final Cabac cbc = new Cabac(this.bss);
    private final ImageClient imc = new ImageClient((RegClient)this.bss);
    private final BiasControl[] biases = new BiasControl[3];
    private final AspicControl[] aspics = new AspicControl[6];
    private final CabacControl[] cabacs = new CabacControl[6];
    private final ImageProc img = new ImageProc(this.imc);
    private final SequencerProc seq = new SequencerProc(this.bss);
    private DacControl dacCtrl;
    private long serialNum;
    protected int hdwTypeI;
    protected int configCcdMask;
    protected int maxCcdMask;
    protected int hwVersion;
    private int maxTemp;
    private int maxPower;
    private int maxAtemp;
    private int maxCcdI;
    private int numTemp;
    private int numPower;
    private int numAtemp;
    private int numCrVolt;
    private int numRtd;
    private boolean dacRaw;
    private boolean biasRaw;
    private double[] tempValues;
    private double[] powerValues;
    private double[] atempValues;
    private final double[] heaterValues = new double[2];
    private double heaterVolts;
    private static final Map<String, Integer> rsetNames;

    public REBDevice() {
    }

    public REBDevice(int id, String ifcName, int ccdMask) {
        this("DAQ0", id, ifcName, ccdMask);
    }

    public REBDevice(String hdwType, int id, String ifcName, int ccdMask) {
        this(hdwType, id, ifcName, ccdMask, null);
    }

    public REBDevice(String hdwType, int id, String ifcName, int ccdMask, ClientFactory clientFactory) {
        if (clientFactory != null) {
            this.bss.setClientFactory(clientFactory);
            this.imc.setClientFactory(clientFactory);
        }
        this.hdwType = hdwType;
        this.id = id;
        this.ifcName = ifcName;
        this.ccdMask = ccdMask;
        this.img.setCcdMask(ccdMask);
    }

    @ConfigurationParameterChanger
    public void setId(int id) {
        if (id == this.id) {
            return;
        }
        this.id = id;
        if (this.inited) {
            this.setOnline(false);
            this.inited = false;
            this.initialize();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the REB ID")
    public int getId() {
        return this.id;
    }

    @ConfigurationParameterChanger
    public void setIfcName(String ifcName) {
        if (ifcName.equals(this.ifcName)) {
            return;
        }
        this.ifcName = ifcName;
        if (this.inited) {
            this.setOnline(false);
            this.inited = false;
            this.initialize();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the network interface name")
    public String getIfcName() {
        return this.ifcName;
    }

    @ConfigurationParameterChanger
    public void setCcdMask(int ccdMask) {
        this.ccdMask = ccdMask;
        this.img.setCcdMask(ccdMask);
        if (this.inited) {
            try {
                this.seq.setCcdMask(ccdMask);
            }
            catch (REBException e) {
                this.log.error((Object)("Error writing stripe register: " + (Object)((Object)e)));
            }
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the mask of CCDs being used")
    public int getCcdMask() {
        return this.ccdMask & this.maxCcdMask;
    }

    public void setClientFactory(ClientFactory factory) {
        if (factory != null) {
            this.bss.setClientFactory(factory);
            this.imc.setClientFactory(factory);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB type")
    public int getRebType() {
        return this.rebType;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB number")
    public int getRebNumber() {
        return this.id & 3;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the raft number")
    public int getRaftNumber() {
        return this.id >> 2 & 0x1F;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the hardware type")
    public int getHdwType() {
        return this.hdwTypeI;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the hardware version")
    public int getHwVersion() {
        return this.hwVersion;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the serial number")
    public long getSerialNumber() {
        return this.serialNum;
    }

    protected void initDevice() {
        this.img.configure(this, this.getSubsystem(), this.log);
        Integer type = hdwTypeMap.get(this.hdwType.toUpperCase());
        if (type == null) {
            MonitorLogUtils.reportConfigError((Logger)this.log, (String)this.getName(), (String)"hdwType", (String)"is invalid");
        }
        this.hdwTypeI = type;
        int biasMask = 0;
        int aspMask = 0;
        int aspicMask = 0;
        int cabMask = 0;
        int cabacMask = 0;
        for (Control ctrl : this.ctlChans.values()) {
            if (ctrl instanceof BiasControl) {
                biasMask |= 1 << ctrl.getHwChan();
                continue;
            }
            if (ctrl instanceof AspicControl) {
                aspMask |= 1 << ctrl.getHwChan();
                continue;
            }
            if (!(ctrl instanceof CabacControl)) continue;
            cabMask |= 1 << ctrl.getHwChan();
        }
        int j = 0;
        while (j < 3) {
            int pair = aspMask & 3;
            if (pair != 0) {
                if (pair == 3) {
                    aspicMask |= 1 << j;
                } else {
                    this.log.error((Object)("Unpaired configuration for ASPIC " + (2 * j + pair - 1) + " ignored"));
                }
            }
            ++j;
            aspMask >>= 2;
        }
        j = 0;
        while (j < 3) {
            int pair = cabMask & 3;
            if (pair != 0) {
                if (pair == 3) {
                    cabacMask |= 1 << j;
                } else {
                    this.log.error((Object)("Unpaired configuration for CABAC " + (2 * j + pair - 1) + " ignored"));
                }
            }
            ++j;
            cabMask >>= 2;
        }
        if (cabacMask != 0 && biasMask != 0) {
            this.log.error((Object)"Both bias and CABAC configurations defined");
        }
        if (cabacMask == 0 && biasMask == 0) {
            this.log.warning((Object)"No bias or CABAC configuration defined");
        }
        if (cabacMask != 0 && cabacMask != aspicMask) {
            this.log.warning((Object)"ASPIC and CABAC configurations don't match");
        }
        if (biasMask != 0 && biasMask != aspicMask) {
            this.log.warning((Object)"ASPIC and bias configurations don't match");
        }
        this.configCcdMask = biasMask | aspicMask | cabacMask;
        for (Control ctrl : this.ctlChans.values()) {
            if (ctrl instanceof DacControl) {
                this.dacCtrl = (DacControl)ctrl;
                continue;
            }
            if (ctrl instanceof BiasControl) {
                if ((1 << ctrl.getHwChan() & this.configCcdMask) == 0) continue;
                this.biases[ctrl.getHwChan()] = (BiasControl)ctrl;
                continue;
            }
            if (ctrl instanceof AspicControl) {
                if ((1 << ctrl.getHwChan() / 2 & this.configCcdMask) == 0) continue;
                this.aspics[ctrl.getHwChan()] = (AspicControl)ctrl;
                continue;
            }
            if (!(ctrl instanceof CabacControl) || (1 << ctrl.getHwChan() / 2 & this.configCcdMask) == 0) continue;
            this.cabacs[ctrl.getHwChan()] = (CabacControl)ctrl;
        }
        this.bss.setDefaultRebType(this.rebType);
        try {
            this.maxCcdMask = this.configCcdMask & (1 << this.bss.getNumStrips()) - 1;
        }
        catch (REBException e) {
            this.log.error((Object)("Error getting expected CCD count: " + (Object)((Object)e)));
        }
        this.fullName = "REB " + this.id + (this.ifcName != null ? " (" + this.ifcName + ")" : "");
    }

    protected void initialize() {
        if (!this.inited) {
            this.fullName = "REB " + this.id + (this.ifcName != null ? " (" + this.ifcName + ")" : "");
        }
        try {
            int j;
            this.bss.open(this.hdwTypeI, this.id, this.ifcName);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.bss.disable();
            this.bss.setTime();
            this.bss.enable();
            this.rebType = this.bss.getRebType();
            this.hwVersion = this.bss.getHwVersion();
            this.maxTemp = this.tmp.getNumRegs();
            this.maxPower = this.pwr.getNumRegs();
            this.maxAtemp = this.slow.getNumAspicTemps();
            this.maxCcdI = this.slow.getNumCcdCurrents();
            this.numRtd = 0;
            this.numCrVolt = 0;
            this.numAtemp = 0;
            this.numPower = 0;
            this.numTemp = 0;
            this.maxCcdMask = this.configCcdMask & (1 << this.bss.getNumStrips()) - 1;
            this.img.setCcdMask(this.ccdMask & this.maxCcdMask);
            this.img.setNumRebCcds(this.bss.getNumStrips());
            this.img.setDataInversion(this.bss.getRebType() == 0);
            try {
                this.seq.setCcdMask(this.ccdMask & this.maxCcdMask);
            }
            catch (REBException e) {
                this.log.error((Object)"Error writing stripe selection");
            }
            this.img.enableScan(this.seq.isScanEnabled());
            if (this.dacCtrl != null && !this.dacCtrl.checkConfig()) {
                this.dacCtrl = null;
            }
            this.dacRaw = this.dacCtrl != null ? this.dacCtrl.isRaw() : false;
            this.biasRaw = false;
            for (j = 0; j < this.biases.length; ++j) {
                BiasControl bias = this.biases[j];
                if (bias != null && !bias.checkConfig()) {
                    bias = null;
                }
                if (bias != null) {
                    this.biasRaw = bias.isRaw();
                }
                this.biases[j] = bias;
            }
            for (j = 0; j < this.aspics.length; ++j) {
                AspicControl aspic = this.aspics[j];
                if (aspic != null && !aspic.checkConfig()) {
                    aspic = null;
                }
                this.aspics[j] = aspic;
            }
            for (j = 0; j < this.cabacs.length; ++j) {
                CabacControl cabac = this.cabacs[j];
                if (cabac != null && !cabac.checkConfig()) {
                    cabac = null;
                }
                this.cabacs[j] = cabac;
            }
            try {
                this.serialNum = this.bss.getRebSerial();
            }
            catch (REBException e) {
                this.log.error((Object)"Error reading serial number");
            }
            this.initSensors();
            if (this.numRtd > 0) {
                this.rtd.initialize();
            }
            this.imc.open(this.hdwTypeI, this.id, this.ifcName);
            this.img.setConstFitsMetadata(this.serialNum);
            this.setOnline(true);
            this.log.info((Object)("Connected to " + this.fullName));
        }
        catch (REBException e) {
            if (!this.inited) {
                this.log.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.bss.close();
        }
        catch (REBException rEBException) {
            // empty catch block
        }
        try {
            this.imc.close();
        }
        catch (REBException rEBException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"channel type", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        try {
            boolean chanOk;
            if (type == 4 || type == 6) {
                chanOk = this.slow.testChannel(hwChan);
            } else {
                int maxChan = type == 0 ? this.maxTemp : (type == 1 ? this.maxPower : (type == 3 ? this.maxAtemp : (type == 5 ? this.maxCcdI : (type == 2 ? 6 : (type == 7 ? 2 : 0)))));
                boolean bl = chanOk = (hwChan >= 0 || type == 1) && hwChan < maxChan;
            }
            if (!chanOk) {
                MonitorLogUtils.reportError((Logger)this.log, (String)name, (String)"hw channel number", (Object)hwChan);
            }
            switch (type) {
                case 0: {
                    ++this.numTemp;
                    break;
                }
                case 1: {
                    ++this.numPower;
                    break;
                }
                case 3: {
                    ++this.numAtemp;
                    break;
                }
                case 6: {
                    ++this.numCrVolt;
                    break;
                }
                case 2: {
                    ++this.numRtd;
                }
            }
        }
        catch (Exception e) {
            this.dropChannel(id);
        }
    }

    protected void readChannelGroup() {
        double volts;
        if (!this.online) {
            return;
        }
        try {
            int j;
            if (this.numTemp > 0) {
                try {
                    this.tempValues = this.tmp.readAdcs();
                }
                catch (REBException e) {
                    if (e.getMessage().contains("Completion wait")) {
                        for (j = 0; j < this.tempValues.length; ++j) {
                            this.tempValues[j] = Double.NaN;
                        }
                    }
                    throw e;
                }
            }
            if (this.numPower > 0) {
                try {
                    this.powerValues = this.pwr.readAdcs();
                }
                catch (REBException e) {
                    if (e.getMessage().contains("Completion wait")) {
                        for (j = 0; j < this.powerValues.length; ++j) {
                            this.powerValues[j] = Double.NaN;
                        }
                    }
                    throw e;
                }
            }
            if (this.numAtemp > 0) {
                this.atempValues = this.slow.readAspicTemps(0, this.maxAtemp);
            }
            if (this.numCrVolt > 0) {
                this.slow.fetchVoltages();
            }
        }
        catch (REBException e) {
            this.log.error((Object)("Error reading sensors: " + e.getMessage()));
            this.setOnline(false);
        }
        this.heaterValues[0] = volts = this.heaterVolts;
        this.heaterValues[1] = volts * volts / 20.0;
    }

    protected double readChannel(int hwChan, int type) {
        double value;
        block16: {
            value = super.readChannel(hwChan, type);
            if (type == 4 || type == 5 || type == 6) {
                try {
                    if (type == 5) {
                        value = this.slow.readCurrent(hwChan);
                        break block16;
                    }
                    value = this.slow.readVoltage(hwChan);
                }
                catch (DriverException e) {
                    this.log.error((Object)("Error reading slow ADC: " + e.getMessage()));
                    this.setOnline(false);
                }
            } else if (type == 2) {
                try {
                    if (hwChan < 4) {
                        value = this.rtd.readTemperature(hwChan);
                        break block16;
                    }
                    if (hwChan == 4) {
                        value = this.rtd.readIntTemperature();
                        break block16;
                    }
                    value = this.rtd.readIntVoltage();
                }
                catch (DriverException e) {
                    this.log.error((Object)("Error reading RTD: " + e.getMessage()));
                    this.setOnline(false);
                }
            } else if (type == 1) {
                if (hwChan >= 0) {
                    value = this.powerValues[hwChan];
                } else {
                    value = 0.0;
                    for (int j = 0; j < this.powerValues.length; j += 2) {
                        value += this.powerValues[j] * this.powerValues[j + 1];
                    }
                    value += this.heaterValues[1];
                }
            } else {
                value = type == 0 ? this.tempValues[hwChan] : (type == 3 ? this.atempValues[hwChan] : (type == 7 ? this.heaterValues[hwChan] : 0.0));
            }
        }
        return value;
    }

    public double readChannelNow(int hwChan, int type) {
        double value = Double.NaN;
        try {
            value = type == 0 ? this.tmp.readAdc(hwChan) : (type == 1 ? this.pwr.readAdc(hwChan) : (type == 3 ? this.slow.readAspicTemp(hwChan / 2, hwChan % 2) : (type == 6 ? this.slow.readVoltageNow(hwChan) : super.readChannelNow(hwChan, type))));
        }
        catch (DriverException e) {
            this.log.error((Object)("Error reading channel: " + e.getMessage()));
            this.setOnline(false);
        }
        return value;
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the REB configuration data")
    public void setREBConfig(@Argument(name="reb", description="REB configuration data") REB reb) {
        SubsystemConfigurationEnvironment sce = this.getSubsystem().getSubsystemConfigurationEnvironment();
        String name = this.getName();
        sce.change(name, ID, (Object)reb.getId());
        sce.change(name, IFC_NAME, (Object)reb.getIfcName());
        sce.change(name, CCD_MASK, (Object)reb.getCcdMask());
        this.dacCtrl.setConfig(reb.getDacs());
        BiasDACS[] biasConfig = reb.getBiases();
        for (int j = 0; j < biasConfig.length; ++j) {
            BiasControl bias = this.biases[j];
            if (bias == null) continue;
            bias.setConfig(biasConfig[j]);
        }
        ASPIC[] aspicConfig = reb.getAspics();
        for (int j = 0; j < aspicConfig.length; ++j) {
            AspicControl aspic = this.aspics[j];
            if (aspic == null) continue;
            aspic.setConfig(aspicConfig[j]);
        }
        CABAC[] cabacConfig = reb.getCabacs();
        for (int j = 0; j < cabacConfig.length; ++j) {
            CabacControl cabac = this.cabacs[j];
            if (cabac == null) continue;
            cabac.setConfig(cabacConfig[j]);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB configuration data")
    public REB getREBConfig() {
        REB reb = new REB();
        reb.setId(this.id);
        reb.setIfcName(this.ifcName);
        reb.setCcdMask(this.ccdMask & this.maxCcdMask);
        reb.setMaxCcdMask(this.maxCcdMask);
        reb.setDacVersion(DacControl.getHwVersion(this.dac));
        reb.setDacRaw(this.dacRaw);
        reb.setBiasVersion(BiasControl.getHwVersion(this.dac));
        reb.setBiasRaw(this.biasRaw);
        reb.setAspicVersion(AspicControl.getHwVersion(this.asp));
        reb.setCabacVersion(CabacControl.getHwVersion(this.cbc));
        this.dacCtrl.getConfig(reb.getDacs());
        BiasDACS[] biasConfig = reb.getBiases();
        for (int j = 0; j < this.biases.length; ++j) {
            BiasControl bias = this.biases[j];
            if (bias == null) continue;
            biasConfig[j] = bias.getConfig();
        }
        ASPIC[] aspicConfig = reb.getAspics();
        for (int j = 0; j < this.aspics.length; ++j) {
            AspicControl aspic = this.aspics[j];
            if (aspic == null) continue;
            aspicConfig[j] = aspic.getConfig();
        }
        CABAC[] cabacConfig = reb.getCabacs();
        for (int j = 0; j < this.cabacs.length; ++j) {
            CabacControl cabac = this.cabacs[j];
            if (cabac == null) continue;
            cabacConfig[j] = cabac.getConfig();
        }
        return reb;
    }

    @Command(type=Command.CommandType.CONFIGURATION, description="transversal TM setting for all aspic controls for this reb")
    public void setAllTM(boolean tm) {
        this.setAllInternal("tm", tm ? 1 : 0);
    }

    @Command(type=Command.CommandType.CONFIGURATION, description="transversal Gain setting for all aspic controls for this reb")
    public void setAllGain(int gain) {
        this.setAllInternal("gain", gain);
    }

    @Command(type=Command.CommandType.CONFIGURATION, description="transversal Rc setting for all aspic controls for this reb")
    public void setAllRc(int rc) {
        this.setAllInternal("rc", rc);
    }

    private void setAllInternal(String parmName, int val) {
        for (AspicControl aspic : this.aspics) {
            ComponentConfigurationEnvironment cce = this.getSubsystem().getComponentConfigurationEnvironment((Object)aspic);
            cce.submitChange(parmName, (Object)val);
        }
        this.getSubsystem().getSubsystemConfigurationEnvironment().commitBulkChange();
    }

    @Command(type=Command.CommandType.ACTION, description="Loads configured DAC values")
    public int loadDacs(boolean all) throws Exception {
        int count = all ? this.dacCtrl.loadConfig() : this.dacCtrl.loadChanged();
        this.log.info((Object)("Loaded " + count + " " + this.getName() + " DACs"));
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Clear DAC values")
    public void clearDacs() throws Exception {
        this.dacCtrl.clear();
    }

    @Command(type=Command.CommandType.ACTION, description="Loads configured bias DAC values")
    public int loadBiasDacs(boolean all) throws Exception {
        int count = 0;
        for (BiasControl bias : this.biases) {
            if (bias == null) continue;
            count += all ? bias.load() : bias.loadChanged();
        }
        this.log.info((Object)("Loaded " + count + " " + this.getName() + " bias DACs"));
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Clear bias DAC values")
    public void clearBiasDacs() throws Exception {
        for (BiasControl bias : this.biases) {
            if (bias == null) continue;
            bias.clear();
        }
    }

    @Command(type=Command.CommandType.ACTION, description=" Loads configuration data to the CABACs")
    public int loadCabacs() throws Exception {
        int count = 0;
        try {
            if (this.cbc.getVersion() == 0) {
                for (int j = 0; j < this.cabacs.length; j += 2) {
                    if (this.cabacs[j] == null) continue;
                    int[] dataT = new int[22];
                    int[] dataB = new int[22];
                    int k = 0;
                    while (this.cabacs[j].getData(k, dataT) && this.cabacs[j + 1].getData(k, dataB)) {
                        this.cbc.set(0, dataT);
                        this.cbc.set(1, dataB);
                        this.cbc.load(j / 2);
                        ++k;
                    }
                    count += 2;
                }
            } else {
                for (CabacControl cabac : this.cabacs) {
                    if (cabac == null) continue;
                    count += cabac.load();
                }
            }
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
        this.log.info((Object)("Loaded " + count + " " + this.getName() + " CABACs"));
        return count;
    }

    @Command(type=Command.CommandType.QUERY, description="Checks loaded CABAC configuration data")
    public List<Integer> checkCabacs() throws Exception {
        try {
            ArrayList<Integer> diff = new ArrayList<Integer>();
            for (int j = 0; j < this.cabacs.length; j += 2) {
                if (this.cabacs[j] == null) continue;
                if (this.cbc.getVersion() == 0) {
                    this.cbc.fetch(j / 2);
                    diff.add(this.cabacs[j].compare(this.cbc.get(0)));
                    diff.add(this.cabacs[j + 1].compare(this.cbc.get(1)));
                    continue;
                }
                diff.add(this.cabacs[j].check());
                diff.add(this.cabacs[j + 1].check());
            }
            return diff;
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
            return null;
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the CABAC power enable bits")
    public void setCabacPower(@Argument(description="Enable bits") int enables) throws DriverException {
        this.cbc.setRegulator(enables);
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the CABAC power enable bits")
    public int getCabacPower() {
        try {
            return this.cbc.getRegulator();
        }
        catch (DriverException e) {
            return -1;
        }
    }

    @Command(type=Command.CommandType.ACTION, description=" Load configuration data to the ASPICs")
    public int loadAspics(boolean all) throws Exception {
        int count = 0;
        for (AspicControl aspic : this.aspics) {
            if (aspic == null) continue;
            count += all ? aspic.load() : aspic.loadChanged();
        }
        this.log.info((Object)("Loaded " + count + " " + this.getName() + " ASPICs"));
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description=" Check loaded ASPIC configuration")
    public int checkAspics() throws Exception {
        int mask = 0;
        int index = 0;
        for (AspicControl aspic : this.aspics) {
            if (aspic == null) continue;
            mask |= aspic.check() << index;
            index += 4;
        }
        return mask;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the back bias on state")
    public boolean isBackBiasOn() throws Exception {
        try {
            return this.bss.isBackBiasOn();
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
            return false;
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn back bias on or off")
    public void setBackBias(@Argument(name="value", description="The on state") boolean value) throws Exception {
        try {
            this.bss.setBackBias(value);
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set heater voltage")
    public void setHeater(@Argument(name="heater", description="Heater number") int heater, @Argument(name="volts", description="The voltage") double volts) throws Exception {
        this.heaterVolts = volts;
        double ampRest = this.dac.getVersion() == 6 ? 10.0 : 5.0;
        double convFact = 819.2 / (1.0 + ampRest / 10.0);
        int value = (int)(convFact * volts);
        try {
            this.dac.set(heater == 0 ? 18 : 21, value, true);
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set heater power")
    public void setHeaterPower(@Argument(name="heater", description="Heater number") int heater, @Argument(name="power", description="The power value") double power) throws Exception {
        this.setHeater(heater, Math.sqrt(power * 20.0));
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the time base to the current system time")
    public void setTime() throws Exception {
        try {
            this.bss.disable();
            this.bss.setTime();
            this.bss.enable();
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the time base as Unix time")
    public long getTime() throws Exception {
        try {
            return this.bss.getTime();
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
            return 0L;
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets a trigger time as Unix time")
    public long getTime(@Argument(name="regset", description="Register set name") String rSet) throws Exception {
        Integer regSet = rsetNames.get(rSet.toLowerCase());
        if (regSet == null) {
            throw new RaftException("Invalid register set name");
        }
        try {
            return this.bss.getTriggerTime(regSet.intValue());
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
            return 0L;
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the FITS file test conditions")
    public void setFitsConditions(String filter, double temperature, double wavelength) {
        this.img.setFitsConditions(filter, temperature, wavelength);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the DAQ metadata for the current image")
    public ImageMetadata getImageMetadata() throws RaftException {
        return this.img.getImageMetadata();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets a portion of the current image")
    public ImageData getImage(@Argument(name="offset", description="Offset to the pixel data") int offset, @Argument(name="count", description="Number of pixels") int count) throws RaftException {
        return this.img.getImage(offset, count);
    }

    @Command(type=Command.CommandType.ACTION, description="Resets the front end")
    public void resetFrontEnd() throws Exception {
        try {
            this.imc.resetFrontEnd();
            this.bss.enable();
            this.bss.setTime();
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the contents of REB registers")
    public RegisterData getRegister(@Argument(name="address", description="Address of the first register") int address, @Argument(name="count", description="Number of registers to read") int count) throws Exception {
        int[] values = new int[count];
        try {
            this.bss.read(address, values);
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
        return new RegisterData(address, count, values);
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the contents of REB registers")
    public void setRegister(@Argument(name="address", description="Address of the first register") int address, @Argument(name="values", description="Values to write") int[] values) throws Exception {
        try {
            this.bss.write(address, values);
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB status block")
    public StatusData getRebStatus() throws Exception {
        try {
            return new StatusData(this.sts.readStatus());
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
            return null;
        }
    }

    BoardDacs getBoardDacs() {
        return this.dac;
    }

    Aspic getAspic() {
        return this.asp;
    }

    Cabac getCabac() {
        return this.cbc;
    }

    public ImageProc getImageProc() {
        return this.img;
    }

    public SequencerProc getSequencer() {
        return this.seq;
    }

    void checkTimeout(DriverException e) throws Exception {
        this.checkTimeout((Exception)((Object)e), RaftException.class);
    }

    double getTempValue(int hwChan) {
        return this.online ? this.tempValues[hwChan] : 0.0;
    }

    double getPowerValue(int hwChan) {
        return this.online ? this.powerValues[hwChan] : 0.0;
    }

    @Deprecated
    public void setFitsFileNamePatter(String fitsFileNamePattern) {
        this.img.setFitsFileNamePatter(fitsFileNamePattern);
    }

    static {
        hdwTypeMap.put("DAQ0", 0);
        hdwTypeMap.put("DAQ1", 1);
        hdwTypeMap.put("PCI", 2);
        hdwTypeMap.put("PCI0", 2);
        hdwTypeMap.put("PCI1", 3);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("TEMP", 0);
        typeMap.put("POWER", 1);
        typeMap.put("RTD", 2);
        typeMap.put("ATEMP", 3);
        typeMap.put("BIAS", 4);
        typeMap.put("CURR", 5);
        typeMap.put("CRVOLT", 6);
        typeMap.put("HEATER", 7);
        rsetNames = new HashMap<String, Integer>();
        rsetNames.put("stat", 0);
        rsetNames.put("time", 1);
        rsetNames.put("seq", 2);
        rsetNames.put("tadc", 4);
        rsetNames.put("padc", 3);
    }
}

