#! /bin/sh
#
#  Run a REB test program
#
#  rebRun.sh type [nreb]
#
#    type    The type of REB: 1, 3, 4, 5, w or g
#
#    nreb    The number of REBs present (default 1)
#

if [ `uname` == Linux ]; then FP=`readlink -fn $0`
else FP=`perl -e "use Cwd 'abs_path'; print abs_path('$0')"`; fi
BD=`dirname $FP`

if [ "$1" == "" ]; then
    echo "No REB type specified: must be 1, 3, 4, 5, w or g"
    exit
else 
    type=$1
    if [ $type == 1 ]; then
        app=Reb1Run
    elif [ $type == 3 ]; then
        app=Reb3Run
    elif [ $type == 4 ]; then
        app=Reb4Run
    elif [ $type == 5 ]; then
        app=Reb5Run
    elif [ $type == w ]; then
        app=WrebRun
    elif [ $type == g ]; then
        app=GrebRun
    else
        echo "Invalid REB type specified: must be 1, 3, 4, 5, w or g"
        exit
    fi
fi

if [ "$2" == "" ]; then
    params=""
else
    nreb=$2
    params="-D org.lsst.ccs.rafts.nreb=$nreb --configuration Rafts:$nreb,Limits:$nreb,RaftsLimits:$nreb"
fi

$BD/CCSbootstrap.sh -app $app $params
