/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb.sim;

import java.util.concurrent.locks.Condition;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.sim.AddressSpace;
import org.lsst.ccs.drivers.reb.sim.AutoCloseableReentrantLock;
import org.lsst.ccs.drivers.reb.sim.DataProvider;
import org.lsst.ccs.drivers.reb.sim.HandleAndIdManager;
import org.lsst.ccs.drivers.reb.sim.REB3Simulation;
import org.lsst.ccs.drivers.reb.sim.SequencerSimulation;
import org.lsst.ccs.drivers.reb.sim.SimulatedImage;
import org.lsst.ccs.drivers.reb.sim.SimulationException;

public class ImageClientDaq1Simulation
implements ImageClient.Impl {
    private final HandleAndIdManager manager;
    private REB3Simulation reb3;
    private final AutoCloseableReentrantLock stateLock = new AutoCloseableReentrantLock();
    private final Condition imageDelivered = this.stateLock.newCondition();
    private final SequencerSimulation.StateListener stateListener = (oldState, newState) -> {
        try (AutoCloseableReentrantLock lock = this.stateLock.open();){
            if (newState == SequencerSimulation.State.RUNNING) {
                this.tag = this.reb3.getTriggerTime(2);
            }
            if (oldState == SequencerSimulation.State.RUNNING && newState == SequencerSimulation.State.STOPPED) {
                this.length = 0xCC00000;
                this.imageDelivered.signalAll();
            }
        }
    };
    private int schema;
    private int version;
    private int id;
    private long tag;
    private int length;
    private final DataProvider dataProvider;

    ImageClientDaq1Simulation(HandleAndIdManager manager, DataProvider provider) {
        this.manager = manager;
        this.dataProvider = provider;
    }

    @Override
    public void newImageClient(int id, String ifc) {
        AddressSpace rs = this.manager.getAddressSpaceForId(id);
        if (rs instanceof REB3Simulation) {
            if (this.reb3 != null) {
                throw new SimulationException("Unsupported repeat call to newImageClient");
            }
        } else {
            throw new SimulationException("Unsupported implementation of AddressSpace returned");
        }
        this.reb3 = (REB3Simulation)rs;
        this.reb3.getSequencer().addStateListener(this.stateListener);
        this.schema = this.reb3.read(0);
        this.version = this.reb3.read(1);
        this.id = this.reb3.read(2);
    }

    @Override
    public void deleteImageClient() {
        if (this.reb3 != null) {
            this.reb3.getSequencer().removeStateListener(this.stateListener);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Image waitForImage(Image image) {
        SimulatedImage result = image instanceof SimulatedImage ? (SimulatedImage)image : new SimulatedImage(this);
        result.setSchema(this.schema);
        result.setVersion(this.version);
        result.setAddress(this.id);
        try (AutoCloseableReentrantLock lock = this.stateLock.open();){
            this.imageDelivered.await();
            result.setLength(this.length);
            result.setTag(this.tag);
            SimulatedImage simulatedImage = result;
            return simulatedImage;
        }
        catch (InterruptedException ex) {
            throw new SimulationException("Interrupted while waiting for image", new Object[]{ex});
        }
    }

    @Override
    public boolean getImage(Image image) {
        if (image instanceof SimulatedImage) {
            SimulatedImage simImage = (SimulatedImage)image;
            int[] registers = this.manager.getRegisters();
            int[] metadata = null;
            if (registers != null) {
                metadata = new int[registers.length];
                for (int i = 0; i < registers.length; ++i) {
                    this.reb3.readRegs(registers[i], metadata, i, 1);
                }
            }
            simImage.setRegisters(metadata);
            simImage.setData(this.dataProvider.getData(image.getMetadata()));
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
    }

    @Override
    public void deleteImageMetadataRef(Image image) {
    }
}

