/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.reb;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;

public class BaseSet
extends RegClient {
    public static final int RSET_STATUS = 0;
    public static final int RSET_TIME_BASE = 1;
    public static final int RSET_SEQUENCER = 2;
    public static final int RSET_POWER_ADCS = 3;
    public static final int RSET_TEMP_ADCS = 4;
    public static final int RSET_FAST_ADCS = 5;
    public static final int REG_SCHEMA = 0;
    public static final int REG_VERSION = 1;
    public static final int REG_ID = 2;
    public static final int REG_TIME_BASE = 4;
    public static final int REG_STATE = 8;
    public static final int REG_TRIGGER = 9;
    public static final int REG_TRIG_TIME = 10;
    public static final int REG_SN_REB_START = 0x800000;
    public static final int REG_SN_REB_VALUE = 0x800001;
    public static final int REG_SN_DREB_START = 0x800010;
    public static final int REG_SN_DREB_VALUE = 0x800011;
    public static final int REG_DCDC_SYNC = 0x900000;
    public static final int REG_BACK_BIAS = 0xD00000;
    public static final int REB_TYPE_UNKNOWN = -1;
    public static final int REB_TYPE_SCIENCE = 0;
    public static final int REB_TYPE_GUIDER = 1;
    public static final int REB_TYPE_WAVEFRONT = 2;
    public static final int OPTN_SEQUENCER = 0;
    public static final int OPTN_CABAC = 1;
    public static final int OPTN_ASPIC = 2;
    public static final int OPTN_REB_SN = 3;
    public static final int OPTN_DREB_SN = 4;
    public static final int OPTN_DCDC_SYNC = 5;
    public static final int OPTN_BOARD_DACS = 6;
    public static final int OPTN_BOARD_POWER = 7;
    public static final int OPTN_BOARD_TEMP = 8;
    public static final int OPTN_STATUS = 9;
    public static final int OPTN_CCD_TEMP = 10;
    public static final int OPTN_SLOW_ADCS = 11;
    public static final int OPTN_FAST_ADCS = 12;
    public static final int OPTN_BACK_BIAS = 13;
    public static final int FW_VERSION_INITIAL = -3;
    public static final int FW_VERSION_UNSET = -2;
    public static final int FW_VERSION_UNKNOWN = -1;
    public static final int FW_VERSION_REB0_0 = 0;
    public static final int FW_VERSION_REB0_1 = 1;
    public static final int FW_VERSION_REB1_2 = 2;
    public static final int FW_VERSION_REB1_3 = 3;
    public static final int FW_VERSION_REB1_4 = 4;
    public static final int FW_VERSION_WREB_1 = 5;
    public static final int FW_VERSION_REB3 = 6;
    public static final int FW_VERSION_WREB_2 = 7;
    public static final int FW_VERSION_REB4 = 8;
    public static final int FW_VERSION_GREB = 9;
    public static final int FW_VERSION_WREB_3 = 10;
    public static final int FW_VERSION_REB5 = 11;
    public static final int VERSION_UNSUPP = -1;
    public static final int VERSION_0 = 0;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final int VERSION_5 = 5;
    public static final int CLOCK_PERIOD_0 = 5;
    public static final int CLOCK_PERIOD_1 = 10;
    public static final long SN_READ_OKAY = 0x1000000000000L;
    public static final long SN_READ_ERROR = 0x2000000000000L;
    public static final long SN_READ_TIMEOUT = 0x4000000000000L;
    public static final long SN_VALUE_MASK = 0xFFFFFFFFFFFFL;
    static double ERROR_VALUE = Double.NaN;
    private static final Map<Integer, Version> versionMap = new HashMap<Integer, Version>();
    private static final int WAIT_TIMEOUT = 1000;
    private int fwVersion = -3;
    private int rebType;
    private int defaultRebType = 0;
    private int numStrips;
    private int handleInst;
    private final Map<Integer, Integer> optionVersion = new HashMap<Integer, Integer>();

    public BaseSet() {
    }

    public BaseSet(RegClient reg) {
        this.ctxt = reg.ctxt;
    }

    public int getHwVersion() throws REBException {
        return this.read(1);
    }

    public int getFwVersion() throws REBException {
        this.setAllVersions();
        return this.fwVersion;
    }

    public int getRebType() throws REBException {
        this.setAllVersions();
        return this.rebType;
    }

    public void setDefaultRebType(int type) {
        this.defaultRebType = type;
    }

    public int getNumStrips() throws REBException {
        this.setAllVersions();
        return this.numStrips;
    }

    public int getVersion(int option) throws REBException {
        return this.getVersion(option, false);
    }

    public int getVersion(int option, boolean unsOkay) throws REBException {
        this.setAllVersions();
        if (this.fwVersion == -1) {
            throw new REBException("Unknown firmware version");
        }
        Integer version = this.optionVersion.get(option);
        if (version == null) {
            throw new REBException("Unrecognized option");
        }
        if (version == -1 && !unsOkay) {
            throw new REBException("Option not supported by the firmware");
        }
        return version;
    }

    public boolean isVersion(int option, int ... version) throws REBException {
        int currVersion = this.getVersion(option, true);
        for (int testVersion : version) {
            if (testVersion != currVersion) continue;
            return true;
        }
        return false;
    }

    public void checkVersion(int option, int ... version) throws REBException {
        if (!this.isVersion(option, version)) {
            this.throwIncompatException();
        }
    }

    public void checkNotVersion(int option, int ... version) throws REBException {
        if (this.isVersion(option, version)) {
            this.throwIncompatException();
        }
    }

    public void throwIncompatException() throws REBException {
        throw new REBException("Incompatible firmware version");
    }

    public void enable() throws REBException {
        this.enable(1);
    }

    public void disable() throws REBException {
        this.disable(1);
    }

    public long getTimeRaw() throws REBException {
        return this.readLong(4);
    }

    public long getTime() throws REBException {
        return this.convertRawTime(this.getTimeRaw());
    }

    public long convertRawTime(long raw) throws REBException {
        return (long)this.getPeriod() * raw / 1000000L;
    }

    public void setTimeRaw(long time) throws REBException {
        this.writeLong(4, time);
    }

    public void setTime(long time) throws REBException {
        this.setTimeRaw(1000000L * time / (long)this.getPeriod());
    }

    public void setTime() throws REBException {
        this.setTime(System.currentTimeMillis());
    }

    public void enable(int regSet) throws REBException {
        this.write(9, this.read(8) & 3 | 1 << regSet);
    }

    public void disable(int regSet) throws REBException {
        this.write(9, this.read(8) & 3 & ~(1 << regSet));
    }

    public boolean isEnabled(int regSet) throws REBException {
        return (this.read(8) & 1 << regSet) != 0;
    }

    public void waitDone(int regSet) throws REBException {
        this.waitDone(regSet, 1000);
    }

    public void waitDone(int regSet, int timeout) throws REBException {
        long limit = System.currentTimeMillis() + (long)timeout;
        boolean busy = true;
        while (busy && System.currentTimeMillis() < limit) {
            busy = this.isEnabled(regSet);
            if (!busy) continue;
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (busy) {
            throw new REBException("Completion wait timeout");
        }
    }

    public long getTriggerTimeRaw(int regSet) throws REBException {
        return this.readLong(10 + 2 * regSet);
    }

    public long getTriggerTime(int regSet) throws REBException {
        return (long)this.getPeriod() * this.getTriggerTimeRaw(regSet) / 1000000L;
    }

    public long getRebSerial() throws REBException {
        this.getVersion(3);
        this.write(0x800000, 0);
        long value = this.readLong(0x800001);
        if ((value & 0x1000000000000L) == 0L) {
            String problem = (value & 0x2000000000000L) != 0L ? "error" : "timeout";
            throw new REBException("Serial number read " + problem);
        }
        return value & 0xFFFFFFFFFFFFL;
    }

    public long getDrebSerial() throws REBException {
        this.getVersion(4);
        this.write(0x800010, 0);
        long value = this.readLong(0x800011);
        if ((value & 0x1000000000000L) == 0L) {
            String problem = (value & 0x2000000000000L) != 0L ? "error" : "timeout";
            throw new REBException("Serial number read " + problem);
        }
        return value & 0xFFFFFFFFFFFFL;
    }

    public void setDcdcSync(boolean enable) throws REBException {
        this.getVersion(5);
        this.write(0x900000, enable ? 1 : 0);
    }

    public boolean isDcdcSync() throws REBException {
        this.getVersion(5);
        return (this.read(0x900000) & 1) != 0;
    }

    public void setBackBias(boolean on) throws REBException {
        this.getVersion(13);
        this.write(0xD00000, on ? 1 : 0);
    }

    public boolean isBackBiasOn() throws REBException {
        this.getVersion(13);
        return (this.read(0xD00000) & 1) != 0;
    }

    private void setAllVersions() throws REBException {
        try {
            this.checkOpen();
        }
        catch (REBException e) {
            if (this.defaultRebType == -1) {
                throw e;
            }
            if (this.fwVersion == -2) {
                return;
            }
            this.fwVersion = -2;
            this.setVersions();
            return;
        }
        if (this.fwVersion > -2 && this.handleInst == this.ctxt.instance) {
            return;
        }
        this.handleInst = this.ctxt.instance;
        int schema = this.read(0);
        int hwVersion = this.read(1);
        int pgpVersion = hwVersion >>> 16;
        int type = pgpVersion >> 12;
        hwVersion &= 0xFFFF;
        this.fwVersion = -1;
        if (schema == 15851008) {
            this.fwVersion = 0;
        } else if (pgpVersion == 45084) {
            if (schema == 1) {
                this.fwVersion = 1;
            } else if (schema == 2) {
                this.fwVersion = 2;
            } else if (schema == 3) {
                this.fwVersion = 3;
            } else if (schema == 4) {
                this.fwVersion = 4;
            }
        } else if (type == 11) {
            this.fwVersion = hwVersion < 256 ? (hwVersion < 32 ? 5 : 7) : (hwVersion < 512 ? 6 : 8);
        } else if (type == 1) {
            this.fwVersion = hwVersion >= 16384 ? 8 : 10;
        } else if (type == 2) {
            this.fwVersion = hwVersion >= 12288 ? 10 : 9;
        } else if (type == 3) {
            int n = hwVersion < 12288 ? 9 : (hwVersion < 16384 ? 6 : (this.fwVersion = hwVersion < 20480 ? 8 : 11));
        }
        if (this.fwVersion == -1 && this.defaultRebType == -1) {
            throw new REBException("Unknown firmware version");
        }
        this.setVersions();
    }

    private void setVersions() {
        int fwVersn = this.fwVersion;
        if (this.fwVersion == -2 || this.fwVersion == -1) {
            fwVersn = this.defaultRebType == 2 ? 10 : (this.defaultRebType == 1 ? 9 : 8);
        }
        Version versions = versionMap.get(fwVersn);
        this.rebType = versions.rebType;
        this.optionVersion.put(0, versions.sequencer);
        this.optionVersion.put(1, versions.cabac);
        this.optionVersion.put(2, versions.aspic);
        this.optionVersion.put(3, versions.rebSn);
        this.optionVersion.put(5, versions.dcdcSync);
        this.optionVersion.put(4, versions.drebSn);
        this.optionVersion.put(6, versions.dacs);
        this.optionVersion.put(7, versions.power);
        this.optionVersion.put(8, versions.boardTemp);
        this.optionVersion.put(9, versions.status);
        this.optionVersion.put(10, versions.ccdTemp);
        this.optionVersion.put(11, versions.slowAdcs);
        this.optionVersion.put(12, versions.fastAdcs);
        this.optionVersion.put(13, versions.backBias);
        this.numStrips = this.rebType == 0 ? 3 : (this.rebType == 1 ? 2 : 1);
    }

    private int getPeriod() throws REBException {
        return this.fwVersion == 0 ? 5 : 10;
    }

    static {
        versionMap.put(0, new Version(0, 0, -1, -1, -1, -1, -1, 0, -1, -1, 0, -1, -1, -1, -1));
        versionMap.put(1, new Version(0, 1, -1, -1, -1, -1, -1, 1, 0, 0, 0, -1, -1, -1, -1));
        versionMap.put(2, new Version(0, 1, 0, -1, -1, -1, -1, 1, 1, 1, 0, -1, -1, -1, -1));
        versionMap.put(3, new Version(0, 1, 0, -1, 0, 0, 0, 1, 1, 1, 1, -1, -1, -1, -1));
        versionMap.put(4, new Version(0, 2, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, -1, -1, -1));
        versionMap.put(5, new Version(2, 3, 1, 1, 0, -1, 0, 2, 2, 2, 1, 0, 0, 0, 0));
        versionMap.put(6, new Version(0, 3, -1, 1, 0, -1, 0, 3, 1, 3, 1, 0, 1, -1, 0));
        versionMap.put(7, new Version(2, 3, -1, 1, 0, -1, 0, 4, 2, 2, 1, 1, 2, -1, 0));
        versionMap.put(8, new Version(0, 3, -1, 1, 0, -1, 0, 3, 1, 3, 1, 0, 3, -1, 0));
        versionMap.put(9, new Version(1, 3, -1, 1, 0, -1, 0, 5, 3, 4, 1, 1, 4, -1, 0));
        versionMap.put(10, new Version(2, 3, -1, 1, 0, -1, 0, 5, 3, 4, 1, 1, 4, -1, 0));
        versionMap.put(11, new Version(0, 3, -1, 1, 0, -1, 0, 3, 4, 3, 1, 1, 5, -1, 0));
    }

    public static class Version {
        private final int rebType;
        private final int sequencer;
        private final int cabac;
        private final int aspic;
        private final int rebSn;
        private final int drebSn;
        private final int dcdcSync;
        private final int dacs;
        private final int power;
        private final int boardTemp;
        private final int status;
        private final int ccdTemp;
        private final int slowAdcs;
        private final int fastAdcs;
        private final int backBias;

        public Version(int rebType, int sequencer, int cabac, int aspic, int rebSn, int drebSn, int dcdcSync, int dacs, int power, int boardTemp, int status, int ccdTemp, int slowAdcs, int fastAdcs, int backBias) {
            this.rebType = rebType;
            this.sequencer = sequencer;
            this.cabac = cabac;
            this.aspic = aspic;
            this.rebSn = rebSn;
            this.drebSn = drebSn;
            this.dcdcSync = dcdcSync;
            this.dacs = dacs;
            this.power = power;
            this.boardTemp = boardTemp;
            this.status = status;
            this.ccdTemp = ccdTemp;
            this.slowAdcs = slowAdcs;
            this.fastAdcs = fastAdcs;
            this.backBias = backBias;
        }
    }
}

