/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.console.py4j;

import java.time.Duration;
import java.util.concurrent.Future;
import org.lsst.ccs.BusMaster;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.CommandArgumentMatchException;
import org.lsst.ccs.command.CommandInvocationException;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import py4j.GatewayServer;

public class Py4JServer {
    private final ConcurrentMessagingUtils sci;
    private final AgentMessagingLayer messagingAccess;

    public Py4JServer(ConcurrentMessagingUtils sci, AgentMessagingLayer messagingAccess) {
        this.sci = sci;
        this.messagingAccess = messagingAccess;
    }

    public Object invoke(String target, String command) throws CommandInvocationException, CommandArgumentMatchException {
        CommandRequest basicCommandBusMessage = new CommandRequest(target, command);
        try {
            return this.sci.sendSynchronousCommand(basicCommandBusMessage);
        }
        catch (Exception ex) {
            throw new CommandInvocationException("Error dispatching command: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Future<Object> invokeAsync(String target, String command) throws CommandInvocationException, CommandArgumentMatchException {
        CommandRequest basicCommandBusMessage = new CommandRequest(target, command);
        try {
            return this.sci.sendAsynchronousCommand(basicCommandBusMessage);
        }
        catch (Exception ex) {
            throw new CommandInvocationException("Error dispatching command: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void setDefaultTimeout(Duration defaultTimeout) {
        this.sci.setDefaultTimeout(defaultTimeout);
    }

    public void addStatusMessageListener(StatusMessageListener listener) {
        this.messagingAccess.addStatusMessageListener(listener);
    }

    public void removeStatusMessageListener(StatusMessageListener listener) {
        this.messagingAccess.removeStatusMessageListener(listener);
    }

    public static void main(String[] argv) throws Exception {
        BusMaster busMaster = new BusMaster("py4j-server");
        busMaster.start();
        AgentMessagingLayer messagingAccess = busMaster.getMessagingAccess();
        ConcurrentMessagingUtils sci = new ConcurrentMessagingUtils(messagingAccess, Duration.ofMillis(15000L));
        Py4JServer svr = new Py4JServer(sci, messagingAccess);
        GatewayServer gatewayServer = new GatewayServer((Object)svr);
        gatewayServer.start();
        System.out.println("Gateway Server Started");
    }
}

