/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.UsesSubsystem;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.rafts.PIController;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.utilities.logging.Logger;

public class TempControl
implements UsesSubsystem {
    private Double gain;
    private Double timeConst;
    private Double smoothTime;
    private Double maxOutput;
    private Double awGain;
    private Double basePower;
    private Double tolerance;
    private double minOutput = 0.0;
    private double maxInput = 100.0;
    private double minInput = -200.0;
    private Integer updateTime;
    private String[] tempChans;
    private String[] rebs;
    private PIController pic;
    private final List<Channel> tempChansL = new ArrayList<Channel>();
    private final List<REBDevice> rebsL = new ArrayList<REBDevice>();
    private double lastPower;
    private boolean active;
    private Timer loopTimer;
    private double setTemp;
    private Logger log;

    public void initialize(Subsystem subsys, Monitor mon, Logger log) {
        Object cmpt;
        ComponentLookup clu = subsys.getComponentLookup();
        if (this.gain == null) {
            MonitorLogUtils.reportConfigError((Logger)subsys.getLogger(), (String)this.getName(), (String)"gain", (String)"is missing");
        }
        if (this.timeConst == null) {
            MonitorLogUtils.reportConfigError((Logger)subsys.getLogger(), (String)this.getName(), (String)"timeConst", (String)"is missing");
        }
        if (this.smoothTime == null) {
            MonitorLogUtils.reportConfigError((Logger)subsys.getLogger(), (String)this.getName(), (String)"smoothTime", (String)"is missing");
        }
        if (this.maxOutput == null) {
            MonitorLogUtils.reportConfigError((Logger)subsys.getLogger(), (String)this.getName(), (String)"maxOutput", (String)"is missing");
        }
        if (this.awGain == null) {
            MonitorLogUtils.reportConfigError((Logger)subsys.getLogger(), (String)this.getName(), (String)"awGain", (String)"is missing");
        }
        if (this.basePower == null) {
            MonitorLogUtils.reportConfigError((Logger)subsys.getLogger(), (String)this.getName(), (String)"basePower", (String)"is missing");
        }
        if (this.tolerance == null) {
            MonitorLogUtils.reportConfigError((Logger)subsys.getLogger(), (String)this.getName(), (String)"tolerance", (String)"is missing");
        }
        if (this.updateTime == null) {
            MonitorLogUtils.reportConfigError((Logger)subsys.getLogger(), (String)this.getName(), (String)"updateTime", (String)"is missing");
        }
        if (this.tempChans == null) {
            MonitorLogUtils.reportConfigError((Logger)subsys.getLogger(), (String)this.getName(), (String)"tempChans", (String)"is missing");
        } else {
            for (String cName : this.tempChans) {
                cmpt = clu.getComponentByName(cName);
                if (cmpt instanceof Channel) {
                    this.tempChansL.add((Channel)cmpt);
                    continue;
                }
                MonitorLogUtils.reportConfigError((Logger)subsys.getLogger(), (String)this.getName(), (String)"tempChans", (String)"contains non-Channel item");
            }
        }
        if (this.rebs == null) {
            MonitorLogUtils.reportConfigError((Logger)subsys.getLogger(), (String)this.getName(), (String)"rebs", (String)"is missing");
        } else {
            for (String cName : this.rebs) {
                cmpt = clu.getComponentByName(cName);
                if (cmpt instanceof REBDevice) {
                    this.rebsL.add((REBDevice)((Object)cmpt));
                    continue;
                }
                MonitorLogUtils.reportConfigError((Logger)subsys.getLogger(), (String)this.getName(), (String)"rebs", (String)"contains non-REBDevice item");
            }
        }
        this.log = log;
        this.pic = new PIController(this.gain, this.timeConst);
        this.pic.setSmoothTime(this.smoothTime);
        this.pic.setAwGain(this.awGain);
        this.pic.setBaseOutput(this.basePower);
        this.pic.setInputRange(this.minInput, this.maxInput);
        this.pic.setOutputRange(this.minOutput, this.maxOutput);
        this.pic.setTolerance(this.tolerance);
    }

    void setPower(double power) {
        for (REBDevice reb : this.rebsL) {
            try {
                reb.setHeaterPower(0, power / (double)this.rebs.length);
            }
            catch (Exception e) {
                this.log.error((Object)("Error setting " + reb.getName() + " heater: " + e.getMessage()));
            }
        }
    }

    public void setTemperature(double temp) {
        this.setTemp = temp;
        this.pic.setSetpoint(this.setTemp);
    }

    public double getTemperature() {
        return this.setTemp;
    }

    public void startLoop(double power) {
        if (this.active) {
            return;
        }
        this.lastPower = power;
        this.startLoop();
    }

    public void startLoop() {
        if (this.active) {
            return;
        }
        this.active = true;
        this.pic.reset();
        this.pic.setIntegral(this.lastPower - this.basePower);
        this.loopTimer = new Timer(true);
        this.loopTimer.schedule((TimerTask)new Iterate(), 0L, (long)this.updateTime.intValue());
    }

    public void stopLoop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.loopTimer.cancel();
        this.setPower(0.0);
    }

    public boolean isLoopActive() {
        return this.active;
    }

    public void reset() {
        this.pic.reset();
    }

    private class Iterate
    extends TimerTask {
        private Iterate() {
        }

        @Override
        public void run() {
            int count = 0;
            double temp = 0.0;
            for (Channel tempChan : TempControl.this.tempChansL) {
                double value = tempChan.getValue();
                if (Double.isNaN(value)) continue;
                temp += value;
                ++count;
            }
            if (count > 0) {
                double tod = (double)System.currentTimeMillis() / 1000.0;
                TempControl.this.lastPower = TempControl.this.pic.performPI(new double[]{temp / (double)count}, tod);
                TempControl.this.setPower(TempControl.this.lastPower);
            } else {
                TempControl.this.log.error((Object)"Control loop iteration failed: no valid temperature values available");
            }
        }
    }
}

