/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import hep.aida.IAnalysisFactory;
import hep.aida.IDataPoint;
import hep.aida.IDataPointSet;
import hep.aida.IDataPointSetFactory;
import hep.aida.IManagedObject;
import hep.aida.util.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import nom.tam.fits.FitsException;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.drivers.reb.Image;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.ImageMetadata;
import org.lsst.ccs.drivers.reb.sim.SimulatedImage;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.data.ImageData;
import org.lsst.ccs.subsystem.rafts.data.ImageState;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.ccd.Segment;
import org.lsst.ccs.utilities.image.DefaultImageSet;
import org.lsst.ccs.utilities.image.FitsFileWriter;
import org.lsst.ccs.utilities.image.FitsHeaderMetadataProvider;
import org.lsst.ccs.utilities.image.FitsHeadersSpecifications;
import org.lsst.ccs.utilities.image.ImageSet;
import org.lsst.ccs.utilities.image.MetaDataSet;
import org.lsst.ccs.utilities.image.ReadOutParameters;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.pattern.FileNamePatternUtils;

public class ImageProc {
    private static final int[] DATA_SEGMENT_MAP = new int[]{15, 14, 13, 12, 11, 10, 9, 8, 0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] INV_DATA_SEGMENT_MAP = new int[DATA_SEGMENT_MAP.length];
    private static final int NUM_CCDS = 3;
    private static final int NUM_ADCS = 16;
    private static final int DATA_MASK_STRAIGHT = 131072;
    private static final int DATA_MASK_INVERTED = 131071;
    private final IDataPointSetFactory dpsf = IAnalysisFactory.create().createDataPointSetFactory(null);
    private REBDevice reb;
    private Subsystem subsys;
    private Logger log;
    private int ccdMask;
    private int numCcds;
    private int numRebCcds;
    private Image currImage = new Image();
    private ByteBuffer[] currImageBuffer;
    private RaftException currImageExcp = new RaftException("No image data available");
    private int numCols;
    private int numRows;
    private int fitsSeqnum;
    private boolean externalSequenceNumber = false;
    private long imageTime;
    private boolean scanMode;
    private String defaultDirectory = ".";
    private String fitsFileNamePattern = "Image_${rebName}_${sensorId}_${timestamp}.fits";
    private String imageDataFileNamePattern = "Image_${rebName}_${timestamp}.dat";
    private final Properties fileNamePatternProperties = new Properties();
    private Reb rebGeometry;
    private ReadOutParameters readOutParameters;
    private int dataInversionMask = 131071;
    private final ImageProcFitsHeaderMetadataProvider metadataProvider = new ImageProcFitsHeaderMetadataProvider();
    private static final int[][] CCD_MAP;

    public ImageProc(ImageClient imc) {
        imc.setListener((ImageClient.Listener)new GetImage(), this.currImage);
        this.fileNamePatternProperties.setProperty("raftLoc", "99");
    }

    public void configure(REBDevice reb, Subsystem subsys, Logger log) {
        this.reb = reb;
        this.log = log;
        this.subsys = subsys;
        this.fileNamePatternProperties.setProperty("rebName", reb.getName());
    }

    @Deprecated
    public void configure(String rebName, int rebId, Subsystem subsys, Logger log) {
        this.log = log;
        this.subsys = subsys;
        this.fileNamePatternProperties.setProperty("rebName", rebName);
    }

    void setPatternProperty(String propertyName, String propertyValue) {
        this.fileNamePatternProperties.setProperty(propertyName, propertyValue);
    }

    public void enableScan(boolean enable) {
        this.scanMode = enable;
    }

    public void setCcdMask(int ccdMask) {
        this.ccdMask = ccdMask;
        this.numCcds = Integer.bitCount(this.ccdMask);
    }

    public void setNumRebCcds(int numRebCcds) {
        this.numRebCcds = numRebCcds;
    }

    public void setRebGeometry(Reb reb) {
        this.rebGeometry = reb;
    }

    public void setDataInversion(boolean invert) {
        this.dataInversionMask = invert ? 131071 : 131072;
    }

    public String saveImage(String dName) throws RaftException, IOException {
        if (this.currImage.getData() == null) {
            throw new RaftException("Image contains no valid data");
        }
        String dirName = (dName == null || dName.isEmpty() ? this.defaultDirectory : dName) + "/";
        String filName = FileNamePatternUtils.resolveFileName((String)this.imageDataFileNamePattern, (Properties)this.fileNamePatternProperties);
        String shortFileName = Paths.get(filName, new String[0]).getFileName().toString();
        this.setFitsFileName(shortFileName);
        try (FileOutputStream ofs = new FileOutputStream(dirName + filName);){
            ofs.getChannel().write(this.currImage.getData());
        }
        return filName;
    }

    void setExternalSequenceNumber(int sequenceNumber) {
        this.fitsSeqnum = sequenceNumber;
        this.externalSequenceNumber = true;
    }

    public List<String> saveFitsImage(String dName, FitsHeaderMetadataProvider provider) throws IOException, RaftException {
        if (this.currImageExcp != null) {
            throw this.currImageExcp;
        }
        int numberOfColumns = this.numCols;
        int numberOfRows = this.numRows;
        if (this.currImage instanceof SimulatedImage) {
            numberOfColumns = this.readOutParameters.getSerialReadPixels();
            numberOfRows = this.readOutParameters.getParallelReadPixels();
        }
        if (this.currImageBuffer[0].limit() != 4 * numberOfColumns * numberOfRows) {
            throw new RaftException("Image size is inconsistent with slice count. Size: " + this.currImageBuffer[0].limit() / 4 + ", expected: " + numberOfColumns * numberOfRows + " (" + numberOfColumns + "x" + numberOfRows + ")");
        }
        ArrayList<String> names = new ArrayList<String>();
        String dirPatt = (dName == null || dName.isEmpty() ? this.defaultDirectory : dName) + "/";
        int jd = 0;
        for (int j = 0; j < 3; ++j) {
            FitsFileWriter writer;
            int n;
            if ((this.ccdMask & 1 << j) == 0) continue;
            int ccdId = this.reb.getRebType() == 0 ? this.numRebCcds - 1 - j : j;
            CCD ccdGeometry = (CCD)this.rebGeometry.getChild(0, ccdId);
            DefaultImageSet imageSet = new DefaultImageSet(ccdGeometry, this.readOutParameters);
            if (this.externalSequenceNumber) {
                n = this.fitsSeqnum;
            } else {
                n = this.fitsSeqnum + 1;
                this.fitsSeqnum = this.fitsSeqnum;
            }
            int seqNumber = n;
            this.metadataProvider.setSequenceNumber(seqNumber);
            this.metadataProvider.setImageDates(System.currentTimeMillis(), this.imageTime);
            ArrayList<FitsHeaderMetadataProvider> providers = new ArrayList<FitsHeaderMetadataProvider>();
            providers.add(this.metadataProvider);
            if (provider != null) {
                providers.add(provider);
            }
            Properties resolverProperties = this.getPropertiesFromMetadataProviders(providers, (ImageSet)imageSet);
            this.fileNamePatternProperties.setProperty("sensorId", String.valueOf(ccdId));
            this.fileNamePatternProperties.setProperty("sensorLoc", String.valueOf(this.reb.getRebNumber()) + String.valueOf(ccdId));
            try {
                this.fileNamePatternProperties.setProperty("testType", resolverProperties.getProperty("TestType").toLowerCase());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                this.fileNamePatternProperties.setProperty("imageType", resolverProperties.getProperty("ImageType").toLowerCase());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            resolverProperties.putAll((Map<?, ?>)this.fileNamePatternProperties);
            String fileName = FileNamePatternUtils.resolveFileName((String)this.fitsFileNamePattern, (Properties)resolverProperties);
            String shortFileName = Paths.get(fileName, new String[0]).getFileName().toString();
            this.setFitsFileName(shortFileName);
            String dirName = FileNamePatternUtils.resolveFileName((String)dirPatt, (Properties)resolverProperties);
            File file = new File(dirName, fileName);
            file.getParentFile().mkdirs();
            try {
                writer = new FitsFileWriter(file, (ImageSet)imageSet, providers);
            }
            catch (FitsException e) {
                throw new RaftException("FITS error: " + (Object)((Object)e));
            }
            for (int k = 0; k < 16; ++k) {
                ByteBuffer buff = this.currImageBuffer[jd * 16 + k];
                buff.rewind();
                writer.write(DATA_SEGMENT_MAP[k], buff);
            }
            writer.close();
            names.add(file.getName());
            ++jd;
        }
        return names;
    }

    public List<String> saveFitsImage(String dName) throws IOException, RaftException {
        return this.saveFitsImage(dName, null);
    }

    private Properties getPropertiesFromMetadataProviders(List<FitsHeaderMetadataProvider> providers, ImageSet imageSet) {
        Properties p = new Properties();
        for (FitsHeaderMetadataProvider provider : providers) {
            p.putAll((Map<?, ?>)provider.getPrimaryHeaderMetadata(imageSet).convertToProperties());
        }
        return p;
    }

    public ImageMetadata getImageMetadata() throws RaftException {
        return this.currImage.getMetadata();
    }

    public ImageData getImage(int offset, int count) throws RaftException {
        if (this.currImage.getData() == null) {
            throw new RaftException("Image contains no valid data");
        }
        int length = count;
        int iLength = this.currImage.getLength();
        if (length < 0 || offset < 0 || offset >= iLength) {
            throw new RaftException("Invalid length or offset");
        }
        if (length == 0 || length + offset > iLength) {
            length = iLength - offset;
        }
        int[] data = new int[length];
        ByteBuffer buff = this.currImage.getData();
        buff.order(ByteOrder.LITTLE_ENDIAN);
        buff.position(4 * offset);
        buff.asIntBuffer().get(data);
        return new ImageData(this.currImage.getTimestamp(), offset, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ImageData getImage(String fileName, int offset, int count) throws RaftException, IOException {
        MappedByteBuffer buff;
        offset *= 4;
        int length = 4 * count;
        try (FileInputStream ifs = new FileInputStream(fileName);){
            FileChannel chan = ifs.getChannel();
            long iLength = chan.size();
            if (length < 0 || offset < 0 || (long)offset >= iLength) {
                throw new RaftException("Invalid length or offset");
            }
            if (length == 0 || (long)(length + offset) > iLength) {
                length = (int)(iLength - (long)offset);
            }
            buff = chan.map(FileChannel.MapMode.READ_ONLY, offset, length);
        }
        int[] data = new int[length / 4];
        buff.order(ByteOrder.LITTLE_ENDIAN);
        buff.asIntBuffer().get(data);
        return new ImageData(0L, offset / 4, data);
    }

    public double[][] getImageStats() throws RaftException {
        if (this.currImageExcp != null) {
            throw this.currImageExcp;
        }
        double[][] stats = new double[this.currImageBuffer.length][2];
        for (int j = 0; j < this.currImageBuffer.length; ++j) {
            double avg;
            double sum = 0.0;
            double sumSq = 0.0;
            int count = this.currImageBuffer[j].limit() / 4;
            for (int k = 0; k < count; ++k) {
                double value = this.currImageBuffer[j].getInt();
                sum += value;
                sumSq += value * value;
            }
            stats[j][0] = avg = sum / (double)count;
            stats[j][1] = Math.sqrt(sumSq / (double)count - avg * avg);
        }
        return stats;
    }

    public ByteBuffer[] splitImage() throws RaftException {
        int j;
        ByteBuffer data = this.currImage.getData();
        if (data == null) {
            throw new RaftException("Image contains no valid data");
        }
        int numSeg = this.numCcds * 16;
        int segSize = data.limit() / numSeg;
        if (data.limit() != 4 * (segSize / 4) * numSeg) {
            throw new RaftException("Invalid image size: " + data.limit());
        }
        ByteBuffer[] adata = new ByteBuffer[numSeg];
        for (j = 0; j < numSeg; ++j) {
            adata[j] = ByteBuffer.allocate(segSize);
        }
        data.order(ByteOrder.nativeOrder());
        for (j = 0; j < segSize / 4; ++j) {
            ByteBuffer[] byteBufferArray = adata;
            int n = byteBufferArray.length;
            for (int i = 0; i < n; ++i) {
                ByteBuffer buff = byteBufferArray[i];
                buff.putInt(data.getInt() ^ this.dataInversionMask);
            }
        }
        for (ByteBuffer buff : adata) {
            buff.flip();
        }
        return adata;
    }

    public void setFitsConditions(String filter, double temperature, double wavelength) {
        this.metadataProvider.setFitsConditions(filter, temperature, wavelength);
    }

    protected void setConstFitsMetadata(long serial) {
        this.metadataProvider.setConstFitsMetadata(serial);
    }

    protected void setSequencerFileName(String name) {
        this.metadataProvider.setSequencerFileName(name);
    }

    public void setSeqFitsMetadata(String cfgName, int nSlice) {
        for (int nCols = 550; nCols >= 500; --nCols) {
            if (nSlice % nCols != 0) continue;
            this.numCols = nCols;
            this.numRows = nSlice / nCols;
            this.log.debug((Object)("Inferring number of columns and rows from number of slices (" + nSlice + "): " + this.numCols + "x" + this.numRows));
            this.metadataProvider.setSeqFitsMetadata(cfgName, 0.0, 0.0);
            return;
        }
        this.log.error((Object)"Cannot factor slice count correctly");
    }

    public void setSeqFitsMetadata(String cfgName, int nCols, int nRows) {
        this.numCols = nCols;
        this.numRows = nRows;
        this.metadataProvider.setSeqFitsMetadata(cfgName, 0.0, 0.0);
    }

    public void setFitsFileName(String fitsFileName) {
        this.metadataProvider.setFitsFileName(fitsFileName);
    }

    public void setExposureTime(double expTime) {
        this.metadataProvider.setExposureTime(expTime);
    }

    public void setDefaultImageDirectory(String dirName) {
        this.defaultDirectory = dirName == null || dirName.isEmpty() ? "." : dirName;
    }

    public void setFitsFileNamePattern(String pattern) {
        this.fitsFileNamePattern = pattern;
    }

    public void setImageDataFileNamePattern(String pattern) {
        this.imageDataFileNamePattern = pattern;
    }

    @Deprecated
    public void setFitsFileNamePatter(String fitsFileNamePattern) {
        this.fitsFileNamePattern = fitsFileNamePattern;
    }

    @Deprecated
    public void setImageDataFileNamePatter(String imageDataFileNamePattern) {
        this.imageDataFileNamePattern = imageDataFileNamePattern;
    }

    private static String timestampString(long tstamp) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(tstamp / 1000000L);
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        return String.format("%tY%<tm%<td%<tH%<tM%<tS", cal);
    }

    public void setReadOutParameters(ReadOutParameters readOutParameters) {
        this.readOutParameters = readOutParameters;
    }

    private void analyzeImage(Segment segment, int ccdNum, int segNum, Map<String, Object> imageMetaData) throws RaftException {
        double stdev;
        int daqCcdNum;
        if (this.currImageExcp != null) {
            throw this.currImageExcp;
        }
        int n = daqCcdNum = this.reb.getRebType() != 0 ? ccdNum : CCD_MAP[this.numRebCcds - 1 - ccdNum][this.ccdMask];
        if (daqCcdNum < 0) {
            throw new RaftException("Invalid CCD number: " + ccdNum + "; CCD mask = " + this.ccdMask);
        }
        ByteBuffer buff = this.currImageBuffer[daqCcdNum * 16 + INV_DATA_SEGMENT_MAP[segNum]];
        buff.rewind();
        double pix_sum_active = 0.0;
        double pix_sum_sq_active = 0.0;
        int npix_active = 0;
        double pix_sum_bias = 0.0;
        double pix_sum_sq_bias = 0.0;
        int npix_bias = 0;
        int numberOfColumns = this.numCols;
        int numberOfRows = this.numRows;
        if (this.currImage instanceof SimulatedImage) {
            numberOfColumns = this.readOutParameters.getSerialReadPixels();
            numberOfRows = this.readOutParameters.getParallelReadPixels();
        }
        for (int row = 0; row < numberOfRows; ++row) {
            for (int col = 0; col < numberOfColumns; ++col) {
                double pixval = buff.getInt();
                if (col > 3 && col < 3 + segment.getSegmentSerialActiveSize()) {
                    pix_sum_active += pixval;
                    pix_sum_sq_active += pixval * pixval;
                    ++npix_active;
                    continue;
                }
                if (col <= 3 + segment.getSegmentSerialActiveSize()) continue;
                pix_sum_bias += pixval;
                pix_sum_sq_bias += pixval * pixval;
                ++npix_bias;
            }
        }
        if (npix_active > 0) {
            double average = pix_sum_active / (double)npix_active;
            stdev = Math.sqrt(pix_sum_sq_active / (double)npix_active - average * average);
            imageMetaData.put("AVERAGE", average);
            imageMetaData.put("STDEV", stdev);
        }
        if (npix_bias > 0) {
            double average = pix_sum_bias / (double)npix_bias;
            stdev = Math.sqrt(pix_sum_sq_bias / (double)npix_bias - average * average);
            imageMetaData.put("AVGBIAS", average);
            imageMetaData.put("STDVBIAS", stdev);
        }
    }

    static /* synthetic */ ByteBuffer[] access$502(ImageProc x0, ByteBuffer[] x1) {
        x0.currImageBuffer = x1;
        return x1;
    }

    static {
        for (int j = 0; j < DATA_SEGMENT_MAP.length; ++j) {
            ImageProc.INV_DATA_SEGMENT_MAP[ImageProc.DATA_SEGMENT_MAP[j]] = j;
        }
        FitsHeadersSpecifications.addSpecFile((String)"Fits_primary_header.spec", (String)"primary");
        CCD_MAP = new int[][]{{-1, 0, -1, 0, -1, 0, -1, 0}, {-1, -1, 0, 1, -1, -1, 0, 1}, {-1, -1, -1, -1, 0, 1, 1, 2}};
    }

    private class ImageProcFitsHeaderMetadataProvider
    implements FitsHeaderMetadataProvider {
        private long obsvTime;
        private final Map<String, Object> sysMetadata = new HashMap<String, Object>();

        private ImageProcFitsHeaderMetadataProvider() {
        }

        public MetaDataSet getPrimaryHeaderMetadata(ImageSet imageSet) {
            if (ImageProc.this.rebGeometry.getChildrenList().contains(imageSet.getCCD())) {
                MetaDataSet ccdMetadataSet = new MetaDataSet();
                int j = imageSet.getCCD().getSerialPosition();
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("Tag", String.valueOf(this.obsvTime));
                ccdMetadataSet.addMetaDataMap("sys", this.sysMetadata);
                ccdMetadataSet.addMetaDataMap("ccd", metadata);
                return ccdMetadataSet;
            }
            return null;
        }

        public MetaDataSet getDataExtendedHeaderMetadata(ImageSet imageSet, int extendedIndex) {
            if (ImageProc.this.rebGeometry.getChildrenList().contains(imageSet.getCCD())) {
                MetaDataSet segmentMetaDataSet = new MetaDataSet();
                HashMap metadata = new HashMap();
                try {
                    ImageProc.this.analyzeImage((Segment)imageSet.getCCD().getSegments().get(extendedIndex), imageSet.getCCD().getSerialPosition(), extendedIndex, metadata);
                }
                catch (RaftException ex) {
                    ImageProc.this.log.error((Object)ex);
                }
                segmentMetaDataSet.addMetaDataMap("sys", this.sysMetadata);
                segmentMetaDataSet.addMetaDataMap("seg", metadata);
                return segmentMetaDataSet;
            }
            return null;
        }

        public MetaDataSet getAdditionalExtendedHeaderMetadata(ImageSet imageSet, String extendedKeyword) {
            return null;
        }

        private void setSequenceNumber(int seqnum) {
            this.sysMetadata.put("SequenceNumber", seqnum);
        }

        private void setImageDates(long fileTime, long obsvTime) {
            this.obsvTime = obsvTime;
            Date fileDate = new Date(fileTime);
            this.sysMetadata.put("FileCreationTime", fileDate);
            Date obsDate = new Date(obsvTime);
            this.sysMetadata.put("ObservationDate", obsDate);
        }

        private void setExposureTime(double expTime) {
            this.sysMetadata.put("ExposureTime", expTime);
        }

        private void setSeqFitsMetadata(String cfgName, double expTime, double delay) {
            this.sysMetadata.put("ExposureTime", expTime);
            this.sysMetadata.put("ShutterDelay", delay);
            this.sysMetadata.put("CCDControllerConfigFile", cfgName);
        }

        private void setFitsFileName(String fitsFileName) {
            this.sysMetadata.put("OriginalFileName", fitsFileName);
        }

        private void setConstFitsMetadata(long serial) {
            this.sysMetadata.put("CCDControllerSerial", String.format("%012x", serial));
        }

        private void setFitsConditions(String filter, double temperature, double wavelength) {
            this.sysMetadata.put("FilterName", filter);
            this.sysMetadata.put("TemperatureSetPoint", temperature);
            this.sysMetadata.put("MonochromatorWavelength", wavelength);
        }

        private void setSequencerFileName(String name) {
            this.sysMetadata.put("SequencerFileName", name);
        }
    }

    private class GetImage
    implements ImageClient.Listener {
        private GetImage() {
        }

        public void processImage(Image image) {
            ImageProc.this.currImage = image;
            ImageProc.this.imageTime = ImageProc.this.currImage.getTimestamp() / 1000000L;
            ImageProc.this.fileNamePatternProperties.setProperty("timestamp", ImageProc.timestampString(ImageProc.this.currImage.getTimestamp()));
            try {
                ImageProc.access$502(ImageProc.this, ImageProc.this.splitImage());
                ImageProc.this.currImageExcp = null;
            }
            catch (RaftException e) {
                ImageProc.this.log.error((Object)e.getMessage());
                ImageProc.access$502(ImageProc.this, null);
                ImageProc.this.currImageExcp = e;
                return;
            }
            ImageState iState = new ImageState(ImageProc.this.currImage.getTimestamp(), ImageProc.this.currImage.getLength());
            KeyValueData kvd = new KeyValueData("ImageState", (Serializable)iState);
            ImageProc.this.subsys.publishSubsystemDataOnStatusBus(kvd);
            if (ImageProc.this.scanMode) {
                if (ImageProc.this.currImageBuffer[0].limit() % 1024 != 0) {
                    ImageProc.this.log.warning((Object)"Scan mode image data size not a multiple of 256");
                }
                IDataPointSet[] sets = new IDataPointSet[ImageProc.this.currImageBuffer.length];
                KeyValueDataList plots = new KeyValueDataList(ImageProc.this.reb.getName() + " scan plots");
                for (int j = 0; j < ImageProc.this.currImageBuffer.length; ++j) {
                    IDataPointSet points;
                    IntBuffer data = ImageProc.this.currImageBuffer[j].asIntBuffer();
                    int strip = j / 16;
                    int amp = j % 16;
                    String title = ImageProc.this.reb.getName() + ": Strip " + strip + ", Ampl " + amp;
                    sets[j] = points = ImageProc.this.dpsf.create("", title, 2);
                    for (int k = 0; k < Math.min(1024, data.limit()); ++k) {
                        IDataPoint point = points.addPoint();
                        point.coordinate(0).setValue((double)k);
                        point.coordinate(1).setValue((double)data.get());
                    }
                    try {
                        plots.addData(String.valueOf(j), (Serializable)((Object)XMLUtils.createXMLString((IManagedObject)((IManagedObject)sets[j]))), KeyValueData.KeyValueDataType.KeyValuePlotData);
                        continue;
                    }
                    catch (IOException ex) {
                        ImageProc.this.log.warning((Object)"Error writing dataPointSet to xml", (Throwable)ex);
                    }
                }
                ImageProc.this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)plots);
            }
        }
    }
}

