/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.SubsystemConfigurationEnvironment;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.config.DACS;
import org.lsst.ccs.subsystem.rafts.data.RaftException;

public class DacControl
extends Control
implements ConfigurationBulkChangeHandler {
    public static final String SCLK_LOW_P = "sclkLowP";
    public static final String SCLK_HIGH_P = "sclkHighP";
    public static final String PCLK_LOW_P = "pclkLowP";
    public static final String PCLK_HIGH_P = "pclkHighP";
    public static final String RG_LOW_P = "rgLowP";
    public static final String RG_HIGH_P = "rgHighP";
    public static final String SCLK_LOW = "sclkLow";
    public static final String SCLK_LOW_SH = "sclkLowSh";
    public static final String SCLK_HIGH = "sclkHigh";
    public static final String SCLK_HIGH_SH = "sclkHighSh";
    public static final String PCLK_LOW = "pclkLow";
    public static final String PCLK_LOW_SH = "pclkLowSh";
    public static final String PCLK_HIGH = "pclkHigh";
    public static final String PCLK_HIGH_SH = "pclkHighSh";
    public static final String RG_LOW = "rgLow";
    public static final String RG_LOW_SH = "rgLowSh";
    public static final String RG_HIGH = "rgHigh";
    public static final String RG_HIGH_SH = "rgHighSh";
    public static final String CS_GATE = "csGate";
    private static final int SCLK_LOW_CH = 1;
    private static final int SCLK_LOW_SH_CH = 2;
    private static final int SCLK_HIGH_CH = 4;
    private static final int SCLK_HIGH_SH_CH = 8;
    private static final int PCLK_LOW_CH = 16;
    private static final int PCLK_LOW_SH_CH = 32;
    private static final int PCLK_HIGH_CH = 64;
    private static final int PCLK_HIGH_SH_CH = 128;
    private static final int RG_LOW_CH = 256;
    private static final int RG_LOW_SH_CH = 512;
    private static final int RG_HIGH_CH = 1024;
    private static final int RG_HIGH_SH_CH = 2048;
    private static final int CS_GATE_CH = 4096;
    private static final String[] checkList = new String[]{"sclkLow", "sclkHigh", "pclkLow", "pclkHigh", "rgLow", "rgHigh"};
    private final double DAC_CONV = 819.0;
    @ConfigurationParameter(category="Rafts")
    private double sclkLowP;
    @ConfigurationParameter(category="Rafts")
    private double sclkHighP;
    @ConfigurationParameter(category="Rafts")
    private double pclkLowP;
    @ConfigurationParameter(category="Rafts")
    private double pclkHighP;
    @ConfigurationParameter(category="Rafts")
    private double rgLowP;
    @ConfigurationParameter(category="Rafts")
    private double rgHighP;
    @ConfigurationParameter(category="RaftsLimits")
    private double sclkLowMin;
    @ConfigurationParameter(category="RaftsLimits")
    private double sclkLowMax;
    @ConfigurationParameter(category="RaftsLimits")
    private double sclkHighMin;
    @ConfigurationParameter(category="RaftsLimits")
    private double sclkHighMax;
    @ConfigurationParameter(category="RaftsLimits")
    private double pclkLowMin;
    @ConfigurationParameter(category="RaftsLimits")
    private double pclkLowMax;
    @ConfigurationParameter(category="RaftsLimits")
    private double pclkHighMin;
    @ConfigurationParameter(category="RaftsLimits")
    private double pclkHighMax;
    @ConfigurationParameter(category="RaftsLimits")
    private double rgLowMin;
    @ConfigurationParameter(category="RaftsLimits")
    private double rgLowMax;
    @ConfigurationParameter(category="RaftsLimits")
    private double rgHighMin;
    @ConfigurationParameter(category="RaftsLimits")
    private double rgHighMax;
    @ConfigurationParameter(category="Rafts")
    private int sclkLow;
    @ConfigurationParameter(category="Rafts")
    private int sclkLowSh;
    @ConfigurationParameter(category="Rafts")
    private int sclkHigh;
    @ConfigurationParameter(category="Rafts")
    private int sclkHighSh;
    @ConfigurationParameter(category="Rafts")
    private int pclkLow;
    @ConfigurationParameter(category="Rafts")
    private int pclkLowSh;
    @ConfigurationParameter(category="Rafts")
    private int pclkHigh;
    @ConfigurationParameter(category="Rafts")
    private int pclkHighSh;
    @ConfigurationParameter(category="Rafts")
    private int rgLow;
    @ConfigurationParameter(category="Rafts")
    private int rgLowSh;
    @ConfigurationParameter(category="Rafts")
    private int rgHigh;
    @ConfigurationParameter(category="Rafts")
    private int rgHighSh;
    @ConfigurationParameter(category="Rafts")
    private final int[] csGate = new int[3];
    private boolean raw = false;
    private int version = -1;
    private boolean valid;
    private int hwVersion;
    private BoardDacs dac;
    private int changed = -1;
    private final Map<String, Double> lowLimitMap = new HashMap<String, Double>();
    private final Map<String, Double> highLimitMap = new HashMap<String, Double>();
    private String configError;
    private double railShiftConvH;
    private double railConvH;
    private double railShiftConvL;
    private double railConvL;

    public DacControl() {
        for (String pName : checkList) {
            this.lowLimitMap.put(pName, 0.0);
            this.highLimitMap.put(pName, 0.0);
        }
    }

    @Deprecated
    public DacControl(String desc, int hwChan, double sclkLowP, double sclkHighP, double pclkLowP, double pclkHighP, double rgLowP, double rgHighP) {
        this.description = desc;
        this.hwChan = hwChan;
        this.sclkLowP = sclkLowP;
        this.sclkHighP = sclkHighP;
        this.pclkLowP = pclkLowP;
        this.pclkHighP = pclkHighP;
        this.rgLowP = rgLowP;
        this.rgHighP = rgHighP;
        this.version = -1;
        this.raw = false;
    }

    @Deprecated
    public DacControl(String desc, int hwChan, int sclkLow, int sclkHigh, int pclkLow, int pclkHigh, int rgLow, int rgHigh, int[] csGate) {
        this.description = desc;
        this.hwChan = hwChan;
        this.sclkLow = sclkLow;
        this.sclkHigh = sclkHigh;
        this.pclkLow = pclkLow;
        this.pclkHigh = pclkHigh;
        this.rgLow = rgLow;
        this.rgHigh = rgHigh;
        System.arraycopy(csGate, 0, this.csGate, 0, this.csGate.length);
        this.version = 0;
        this.raw = true;
    }

    @Deprecated
    public DacControl(String desc, int hwChan, int sclkLow, int sclkLowSh, int sclkHigh, int sclkHighSh, int pclkLow, int pclkLowSh, int pclkHigh, int pclkHighSh, int rgLow, int rgLowSh, int rgHigh, int rgHighSh) {
        this.description = desc;
        this.hwChan = hwChan;
        this.sclkLow = sclkLow;
        this.sclkLowSh = sclkLowSh;
        this.sclkHigh = sclkHigh;
        this.sclkHighSh = sclkHighSh;
        this.pclkLow = pclkLow;
        this.pclkLowSh = pclkLowSh;
        this.pclkHigh = pclkHigh;
        this.pclkHighSh = pclkHighSh;
        this.rgLow = rgLow;
        this.rgLowSh = rgLowSh;
        this.rgHigh = rgHigh;
        this.rgHighSh = rgHighSh;
        this.version = 1;
        this.raw = true;
    }

    @Deprecated
    public DacControl(String desc, int hwChan, int sclkLow, int sclkLowSh, int sclkHigh, int pclkLow, int pclkLowSh, int pclkHigh, int rgLow, int rgLowSh, int rgHigh) {
        this.description = desc;
        this.hwChan = hwChan;
        this.sclkLow = sclkLow;
        this.sclkLowSh = sclkLowSh;
        this.sclkHigh = sclkHigh;
        this.pclkLow = pclkLow;
        this.pclkLowSh = pclkLowSh;
        this.pclkHigh = pclkHigh;
        this.rgLow = rgLow;
        this.rgLowSh = rgLowSh;
        this.rgHigh = rgHigh;
        this.version = 2;
        this.raw = true;
    }

    protected void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        if (this.configError != null) {
            this.log.error((Object)("Config error (startup): " + this.getName() + ": " + this.configError));
        }
        this.dac = ((REBDevice)devc).getBoardDacs();
    }

    public boolean checkConfig() {
        this.hwVersion = DacControl.getHwVersion(this.dac);
        if (this.raw && this.version != this.hwVersion || !this.raw && this.hwVersion != 1 && this.hwVersion != 2) {
            this.log.error((Object)"DAC configuration incompatible with the firmware");
            return false;
        }
        if (!this.raw) {
            double shiftGainH = this.hwVersion == 1 ? 2.0 : 2.4899999999999998;
            double shiftGainL = this.hwVersion == 1 ? 2.0 : 2.4677898909811695;
            double fudge = this.hwVersion == 1 ? 1.0 : 1.04;
            this.railShiftConvH = fudge * 819.0 / shiftGainH;
            this.railConvH = fudge * 819.0 / (1.0 + shiftGainH);
            this.railShiftConvL = fudge * 819.0 / shiftGainL;
            this.railConvL = fudge * 819.0 / (1.0 + shiftGainL);
        } else {
            this.valid = true;
        }
        return true;
    }

    public boolean isRaw() {
        return this.raw;
    }

    public static int getHwVersion(BoardDacs dac) {
        int version = dac.getVersion();
        version = version == 0 || version == 1 ? 0 : (version == 2 || version == 4 || version == 5 ? 1 : (version == 3 ? 2 : -1));
        return version;
    }

    @Deprecated
    public int getHwVersion() {
        return this.hwVersion;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void validateBulkChange(Map<String, Object> params) throws IllegalArgumentException {
        if (this.raw) {
            return;
        }
        String errMsg = null;
        boolean newLimits = false;
        for (String pName : checkList) {
            double value = (Double)params.get(pName + "P");
            StringBuilder stringBuilder = new StringBuilder();
            if (value > (Double)params.get(stringBuilder.append(pName).append("Max").toString())) {
                errMsg = pName + "P is above high limit";
                break;
            }
            StringBuilder stringBuilder2 = new StringBuilder();
            if (!(value < (Double)params.get(stringBuilder2.append(pName).append("Min").toString()))) continue;
            errMsg = pName + "P is below low limit";
            break;
        }
        if (errMsg == null && (Double)params.get(SCLK_HIGH_P) < (Double)params.get(PCLK_HIGH_P)) {
            errMsg = "sclkHighP is below pclkHighP";
        }
        if (errMsg != null && this.getName() != null) {
            for (String pName : checkList) {
                if ((Double)params.get(pName + "Max") == this.highLimitMap.get(pName) && (Double)params.get(pName + "Min") == this.lowLimitMap.get(pName)) continue;
                newLimits = true;
                break;
            }
        }
        if (errMsg == null) {
            this.valid = true;
            return;
        }
        if (this.getName() == null) {
            this.valid = false;
            this.configError = errMsg;
            return;
        }
        if (newLimits) {
            this.valid = false;
            this.log.error((Object)("Configuration failure (new limits): " + this.getName() + ": " + errMsg));
            return;
        }
        errMsg = this.getName() + ": " + errMsg;
        this.log.error((Object)("Configuration failure: " + errMsg));
        throw new IllegalArgumentException(errMsg);
    }

    @ConfigurationParameterChanger
    public void setPclkLowP(double value) {
        this.pclkLowP = value;
    }

    public double getPclkLowP() {
        return this.pclkLowP;
    }

    @ConfigurationParameterChanger
    public void setPclkLowMax(double value) {
        this.pclkLowMax = value;
        this.highLimitMap.put(PCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setPclkLowMin(double value) {
        this.pclkLowMin = value;
        this.lowLimitMap.put(PCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setPclkHighP(double value) {
        this.pclkHighP = value;
    }

    public double getPclkHighP() {
        return this.pclkHighP;
    }

    @ConfigurationParameterChanger
    public void setPclkHighMax(double value) {
        this.pclkHighMax = value;
        this.highLimitMap.put(PCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setPclkHighMin(double value) {
        this.pclkHighMin = value;
        this.lowLimitMap.put(PCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setSclkLowP(double value) {
        this.sclkLowP = value;
    }

    public double getSclkLowP() {
        return this.sclkLowP;
    }

    @ConfigurationParameterChanger
    public void setSclkLowMax(double value) {
        this.sclkLowMax = value;
        this.highLimitMap.put(SCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setSclkLowMin(double value) {
        this.sclkLowMin = value;
        this.lowLimitMap.put(SCLK_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setSclkHighP(double value) {
        this.sclkHighP = value;
    }

    public double getSclkHighP() {
        return this.sclkHighP;
    }

    @ConfigurationParameterChanger
    public void setSclkHighMax(double value) {
        this.sclkHighMax = value;
        this.highLimitMap.put(SCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setSclkHighMin(double value) {
        this.sclkHighMin = value;
        this.lowLimitMap.put(SCLK_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setRgLowP(double value) {
        this.rgLowP = value;
    }

    public double getRgLowP() {
        return this.rgLowP;
    }

    @ConfigurationParameterChanger
    public void setRgLowMax(double value) {
        this.rgLowMax = value;
        this.highLimitMap.put(RG_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setRgLowMin(double value) {
        this.rgLowMin = value;
        this.lowLimitMap.put(RG_LOW, value);
    }

    @ConfigurationParameterChanger
    public void setRgHighP(double value) {
        this.rgHighP = value;
    }

    public double getRgHighP() {
        return this.rgHighP;
    }

    @ConfigurationParameterChanger
    public void setRgHighMax(double value) {
        this.rgHighMax = value;
        this.highLimitMap.put(RG_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setRgHighMin(double value) {
        this.rgHighMin = value;
        this.lowLimitMap.put(RG_HIGH, value);
    }

    @ConfigurationParameterChanger
    public void setPclkLow(int value) {
        this.pclkLow = value;
        this.changed |= 0x10;
    }

    public int getPclkLow() {
        return this.pclkLow;
    }

    @ConfigurationParameterChanger
    public void setPclkHigh(int value) {
        this.pclkHigh = value;
        this.changed |= 0x40;
    }

    public int getPclkHigh() {
        return this.pclkHigh;
    }

    @ConfigurationParameterChanger
    public void setSclkLow(int value) {
        this.sclkLow = value;
        this.changed |= 1;
    }

    public int getSclkLow() {
        return this.sclkLow;
    }

    @ConfigurationParameterChanger
    public void setSclkHigh(int value) {
        this.sclkHigh = value;
        this.changed |= 4;
    }

    public int getSclkHigh() {
        return this.sclkHigh;
    }

    @ConfigurationParameterChanger
    public void setRgLow(int value) {
        this.rgLow = value;
        this.changed |= 0x100;
    }

    public int getRgLow() {
        return this.rgLow;
    }

    @ConfigurationParameterChanger
    public void setRgHigh(int value) {
        this.rgHigh = value;
        this.changed |= 0x400;
    }

    public int getRgHigh() {
        return this.rgHigh;
    }

    @ConfigurationParameterChanger
    public void setCsGate(int[] value) {
        System.arraycopy(value, 0, this.csGate, 0, this.csGate.length);
        this.changed |= 0x1000;
    }

    public int[] getCsGate() {
        return this.csGate;
    }

    @ConfigurationParameterChanger
    public void setPclkLowSh(int value) {
        this.pclkLowSh = value;
        this.changed |= 0x20;
    }

    public int getPclkLowSh() {
        return this.pclkLowSh;
    }

    @ConfigurationParameterChanger
    public void setPclkHighSh(int value) {
        this.pclkHighSh = value;
        this.changed |= 0x80;
    }

    public int getPclkHighSh() {
        return this.pclkHighSh;
    }

    @ConfigurationParameterChanger
    public void setSclkLowSh(int value) {
        this.sclkLowSh = value;
        this.changed |= 2;
    }

    public int getSclkLowSh() {
        return this.sclkLowSh;
    }

    @ConfigurationParameterChanger
    public void setSclkHighSh(int value) {
        this.sclkHighSh = value;
        this.changed |= 8;
    }

    public int getSclkHighSh() {
        return this.sclkHighSh;
    }

    @ConfigurationParameterChanger
    public void setRgLowSh(int value) {
        this.rgLowSh = value;
        this.changed |= 0x200;
    }

    public int getRgLowSh() {
        return this.rgLowSh;
    }

    @ConfigurationParameterChanger
    public void setRgHighSh(int value) {
        this.rgHighSh = value;
        this.changed |= 0x800;
    }

    public int getRgHighSh() {
        return this.rgHighSh;
    }

    void setConfig(DACS dacs) {
        Object[] values;
        SubsystemConfigurationEnvironment sce = this.getSubsystem().getSubsystemConfigurationEnvironment();
        String name = this.getName();
        if (!this.raw) {
            values = dacs.getPValues();
            sce.submitChange(name, RG_HIGH_P, (Object)values[5]);
            sce.submitChange(name, RG_LOW_P, (Object)values[4]);
            sce.submitChange(name, PCLK_HIGH_P, (Object)values[3]);
            sce.submitChange(name, PCLK_LOW_P, (Object)values[2]);
            sce.submitChange(name, SCLK_HIGH_P, (Object)values[1]);
            sce.submitChange(name, SCLK_LOW_P, (Object)values[0]);
        } else {
            values = dacs.getValues();
            sce.submitChange(name, RG_HIGH, (Object)((int)values[5]));
            sce.submitChange(name, RG_LOW, (Object)((int)values[4]));
            sce.submitChange(name, PCLK_HIGH, (Object)((int)values[3]));
            sce.submitChange(name, PCLK_LOW, (Object)((int)values[2]));
            sce.submitChange(name, SCLK_HIGH, (Object)((int)values[1]));
            sce.submitChange(name, SCLK_LOW, (Object)((int)values[0]));
            if (this.hwVersion < 1) {
                sce.submitChange(name, CS_GATE, (Object)new int[]{(int)values[12], (int)values[13], (int)values[14]});
            }
            if (this.hwVersion == 1) {
                sce.submitChange(name, RG_HIGH_SH, (Object)((int)values[11]));
                sce.submitChange(name, PCLK_HIGH_SH, (Object)((int)values[9]));
                sce.submitChange(name, SCLK_HIGH_SH, (Object)((int)values[7]));
            }
            if (this.hwVersion >= 1) {
                sce.submitChange(name, RG_LOW_SH, (Object)((int)values[10]));
                sce.submitChange(name, PCLK_LOW_SH, (Object)((int)values[8]));
                sce.submitChange(name, SCLK_LOW_SH, (Object)((int)values[6]));
            }
        }
        try {
            sce.commitBulkChange();
        }
        catch (IllegalArgumentException e) {
            sce.dropSubmittedChangesForComponent(name);
            throw e;
        }
    }

    void getConfig(DACS dacs) {
        if (!this.raw) {
            double[] values = dacs.getPValues();
            values[5] = this.rgHighP;
            values[4] = this.rgLowP;
            values[3] = this.pclkHighP;
            values[2] = this.pclkLowP;
            values[1] = this.sclkHighP;
            values[0] = this.sclkLowP;
        } else {
            int[] values = dacs.getValues();
            values[5] = this.rgHigh;
            values[4] = this.rgLow;
            values[3] = this.pclkHigh;
            values[2] = this.pclkLow;
            values[1] = this.sclkHigh;
            values[0] = this.sclkLow;
            if (this.hwVersion < 1) {
                values[12] = this.csGate[0];
                values[13] = this.csGate[1];
                values[14] = this.csGate[2];
            }
            if (this.hwVersion == 1) {
                values[11] = this.rgHighSh;
                values[9] = this.pclkHighSh;
                values[7] = this.sclkHighSh;
            }
            if (this.hwVersion >= 1) {
                values[10] = this.rgLowSh;
                values[8] = this.pclkLowSh;
                values[6] = this.sclkLowSh;
            }
        }
    }

    public int loadConfig() throws Exception {
        int count;
        if (!this.valid) {
            throw new RaftException(this.getName() + " configuration not valid");
        }
        if (!this.raw) {
            count = 9;
            this.setDac(0, this.sclkLowP >= 0.0 ? (int)(this.railConvL * this.sclkLowP) : 0);
            this.setDac(1, this.sclkLowP <= 0.0 ? (int)(-this.railShiftConvL * this.sclkLowP) : 0);
            this.setDac(2, this.sclkHighP >= 0.0 ? (int)(this.railConvH * this.sclkHighP) : 0);
            this.setDac(8, this.pclkLowP >= 0.0 ? (int)(this.railConvL * this.pclkLowP) : 0);
            this.setDac(9, this.pclkLowP <= 0.0 ? (int)(-this.railShiftConvL * this.pclkLowP) : 0);
            this.setDac(10, this.pclkHighP >= 0.0 ? (int)(this.railConvH * this.pclkHighP) : 0);
            this.setDac(4, this.rgLowP >= 0.0 ? (int)(this.railConvL * this.rgLowP) : 0);
            this.setDac(5, this.rgLowP <= 0.0 ? (int)(-this.railShiftConvL * this.rgLowP) : 0);
            this.setDac(6, this.rgHighP >= 0.0 ? (int)(this.railConvH * this.rgHighP) : 0);
            if (this.hwVersion == 1) {
                this.setDac(3, this.sclkHighP <= 0.0 ? (int)(-this.railShiftConvH * this.sclkHighP) : 0);
                this.setDac(11, this.pclkHighP <= 0.0 ? (int)(-this.railShiftConvH * this.pclkHighP) : 0);
                this.setDac(7, this.rgHighP <= 0.0 ? (int)(-this.railShiftConvH * this.rgHighP) : 0);
                count += 3;
            }
        } else {
            count = 6;
            this.setDac(0, this.sclkLow);
            this.setDac(2, this.sclkHigh);
            this.setDac(8, this.pclkLow);
            this.setDac(10, this.pclkHigh);
            this.setDac(4, this.rgLow);
            this.setDac(6, this.rgHigh);
            if (this.hwVersion < 1) {
                this.setDac(17, this.csGate[0]);
                this.setDac(19, this.csGate[1]);
                this.setDac(20, this.csGate[2]);
                count += 3;
            }
            if (this.hwVersion == 1) {
                this.setDac(3, this.sclkHighSh);
                this.setDac(11, this.pclkHighSh);
                this.setDac(7, this.rgHighSh);
                count += 3;
            }
            if (this.hwVersion >= 1) {
                this.setDac(1, this.sclkLowSh);
                this.setDac(9, this.pclkLowSh);
                this.setDac(5, this.rgLowSh);
                count += 3;
            }
        }
        this.loadDac();
        this.changed = 0;
        return count;
    }

    public int loadChanged() throws Exception {
        if (!this.valid) {
            throw new RaftException(this.getName() + " configuration not valid");
        }
        int count = 0;
        if (this.changed != 0) {
            if (!this.raw) {
                if ((this.changed & 1) != 0) {
                    this.setDac(0, this.sclkLowP >= 0.0 ? (int)(this.railConvL * this.sclkLowP) : 0);
                    this.setDac(1, this.sclkLowP <= 0.0 ? (int)(-this.railShiftConvL * this.sclkLowP) : 0);
                    count += 2;
                }
                if ((this.changed & 4) != 0) {
                    this.setDac(2, this.sclkHighP >= 0.0 ? (int)(this.railConvH * this.sclkHighP) : 0);
                    ++count;
                    if (this.hwVersion == 1) {
                        this.setDac(3, this.sclkHighP <= 0.0 ? (int)(-this.railShiftConvH * this.sclkHighP) : 0);
                        ++count;
                    }
                }
                if ((this.changed & 0x10) != 0) {
                    this.setDac(8, this.pclkLowP >= 0.0 ? (int)(this.railConvL * this.pclkLowP) : 0);
                    this.setDac(9, this.pclkLowP <= 0.0 ? (int)(-this.railShiftConvL * this.pclkLowP) : 0);
                    count += 2;
                }
                if ((this.changed & 0x40) != 0) {
                    this.setDac(10, this.pclkHighP >= 0.0 ? (int)(this.railConvH * this.pclkHighP) : 0);
                    ++count;
                    if (this.hwVersion == 1) {
                        this.setDac(11, this.pclkHighP <= 0.0 ? (int)(-this.railShiftConvH * this.pclkHighP) : 0);
                        ++count;
                    }
                }
                if ((this.changed & 0x100) != 0) {
                    this.setDac(4, this.rgLowP >= 0.0 ? (int)(this.railConvL * this.rgLowP) : 0);
                    this.setDac(5, this.rgLowP <= 0.0 ? (int)(-this.railShiftConvL * this.rgLowP) : 0);
                    count += 2;
                }
                if ((this.changed & 0x400) != 0) {
                    this.setDac(6, this.rgHighP >= 0.0 ? (int)(this.railConvH * this.rgHighP) : 0);
                    ++count;
                    if (this.hwVersion == 1) {
                        this.setDac(7, this.rgHighP <= 0.0 ? (int)(-this.railShiftConvH * this.rgHighP) : 0);
                        ++count;
                    }
                }
            } else {
                if ((this.changed & 1) != 0) {
                    this.setDac(0, this.sclkLow);
                    ++count;
                }
                if ((this.changed & 4) != 0) {
                    this.setDac(2, this.sclkHigh);
                    ++count;
                }
                if ((this.changed & 0x10) != 0) {
                    this.setDac(8, this.pclkLow);
                    ++count;
                }
                if ((this.changed & 0x40) != 0) {
                    this.setDac(10, this.pclkHigh);
                    ++count;
                }
                if ((this.changed & 0x100) != 0) {
                    this.setDac(4, this.rgLow);
                    ++count;
                }
                if ((this.changed & 0x400) != 0) {
                    this.setDac(6, this.rgHigh);
                    ++count;
                }
                if (this.hwVersion < 1 && (this.changed & 0x1000) != 0) {
                    this.setDac(17, this.csGate[0]);
                    this.setDac(19, this.csGate[1]);
                    this.setDac(20, this.csGate[2]);
                    count += 3;
                }
                if (this.hwVersion == 1) {
                    if ((this.changed & 8) != 0) {
                        this.setDac(3, this.sclkHighSh);
                        ++count;
                    }
                    if ((this.changed & 0x80) != 0) {
                        this.setDac(11, this.pclkHighSh);
                        ++count;
                    }
                    if ((this.changed & 0x800) != 0) {
                        this.setDac(7, this.rgHighSh);
                        ++count;
                    }
                }
                if (this.hwVersion >= 1) {
                    if ((this.changed & 2) != 0) {
                        this.setDac(1, this.sclkLowSh);
                        ++count;
                    }
                    if ((this.changed & 0x20) != 0) {
                        this.setDac(9, this.pclkLowSh);
                        ++count;
                    }
                    if ((this.changed & 0x200) != 0) {
                        this.setDac(5, this.rgLowSh);
                        ++count;
                    }
                }
            }
            this.loadDac();
            this.changed = 0;
        }
        return count;
    }

    public void clear() throws Exception {
        this.setDac(0, 0);
        this.setDac(2, 0);
        this.setDac(8, 0);
        this.setDac(10, 0);
        this.setDac(4, 0);
        this.setDac(6, 0);
        if (this.hwVersion < 1) {
            this.setDac(17, 0);
            this.setDac(19, 0);
            this.setDac(20, 0);
        }
        if (this.hwVersion == 1) {
            this.setDac(3, 0);
            this.setDac(11, 0);
            this.setDac(7, 0);
        }
        if (this.hwVersion >= 1) {
            this.setDac(1, 0);
            this.setDac(9, 0);
            this.setDac(5, 0);
        }
        this.loadDac();
        this.changed = -1;
    }

    void setDac(int chan, int value) throws Exception {
        this.testOnline();
        try {
            this.dac.set(chan, value);
        }
        catch (REBException e) {
            this.checkTimeout((Exception)((Object)e), RaftException.class);
        }
    }

    void loadDac() throws Exception {
        this.testOnline();
        try {
            this.dac.loadGlobal();
        }
        catch (REBException e) {
            this.checkTimeout((Exception)((Object)e), RaftException.class);
        }
    }
}

