/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import org.lsst.ccs.SubsystemConfigurationEnvironment;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reb.Cabac;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.Monitor;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.config.CABAC;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.utilities.logging.Logger;

public class CabacControl
extends Control {
    static final String RD = "rd";
    static final String OG = "og";
    static final String GD = "gd";
    static final String RG_RISE = "rgRise";
    static final String RG_FALL = "rgFall";
    static final String SCLK_RISE = "sclkRise";
    static final String SCLK_FALL = "sclkFall";
    static final String PCLK_RISE = "pclkRise";
    static final String PCLK_FALL = "pclkFall";
    static final String OD_RDO = "odRdo";
    static final String OD_EXP = "odExp";
    static final String PULSE = "pulse";
    static final double LOW_SCALE = 0.019;
    static final double HIGH_SCALE = 0.15;
    private static final int[][] cfgFields = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}};
    @ConfigurationParameter(name="rd", category="Rafts")
    private int rd;
    @ConfigurationParameter(name="og", category="Rafts")
    private int og;
    @ConfigurationParameter(name="gd", category="Rafts")
    private int gd;
    @ConfigurationParameter(name="rgRise", category="Rafts")
    private int rgRise;
    @ConfigurationParameter(name="rgFall", category="Rafts")
    private int rgFall;
    @ConfigurationParameter(name="sclkRise", category="Rafts")
    private final int[] sclkRise = new int[3];
    @ConfigurationParameter(name="sclkFall", category="Rafts")
    private final int[] sclkFall = new int[3];
    @ConfigurationParameter(name="pclkRise", category="Rafts")
    private final int[] pclkRise = new int[4];
    @ConfigurationParameter(name="pclkFall", category="Rafts")
    private final int[] pclkFall = new int[4];
    @ConfigurationParameter(name="odRdo", category="Rafts")
    private final int[] odRdo = new int[2];
    @ConfigurationParameter(name="odExp", category="Rafts")
    private final int[] odExp = new int[2];
    private final int version;
    private int hwVersion;
    private Cabac cbc;

    public CabacControl(String desc, int hwChan, int rd, int og, int gd, int rgRise, int[] sclkRise, int[] pclkRise, int[] odRdo, int[] odExp) {
        this.description = desc;
        this.hwChan = hwChan;
        this.rd = rd;
        this.og = og;
        this.gd = gd;
        this.rgRise = rgRise;
        System.arraycopy(sclkRise, 0, this.sclkRise, 0, this.sclkRise.length);
        System.arraycopy(pclkRise, 0, this.pclkRise, 0, this.pclkRise.length);
        System.arraycopy(odRdo, 0, this.odRdo, 0, this.odRdo.length);
        System.arraycopy(odExp, 0, this.odExp, 0, this.odExp.length);
        this.version = 0;
    }

    public CabacControl(String desc, int hwChan, int rd, int og, int gd, int rgRise, int rgFall, int[] sclkRise, int[] sclkFall, int[] pclkRise, int[] pclkFall, int[] odRdo, int[] odExp) {
        this.description = desc;
        this.hwChan = hwChan;
        this.rd = rd;
        this.og = og;
        this.gd = gd;
        this.rgRise = rgRise;
        this.rgFall = rgFall;
        System.arraycopy(sclkRise, 0, this.sclkRise, 0, this.sclkRise.length);
        System.arraycopy(sclkFall, 0, this.sclkFall, 0, this.sclkFall.length);
        System.arraycopy(pclkRise, 0, this.pclkRise, 0, this.pclkRise.length);
        System.arraycopy(pclkFall, 0, this.pclkFall, 0, this.pclkFall.length);
        System.arraycopy(odRdo, 0, this.odRdo, 0, this.odRdo.length);
        System.arraycopy(odExp, 0, this.odExp, 0, this.odExp.length);
        this.version = 1;
    }

    protected void configure(Monitor mon, Device devc) {
        super.configure(mon, devc);
        this.cbc = ((REBDevice)devc).getCabac();
    }

    public boolean checkConfig() {
        this.hwVersion = CabacControl.getHwVersion(this.cbc);
        if (this.version != this.hwVersion) {
            this.log.error((Object)("CABAC " + this.hwChan + " configuration incompatible with the firmware"));
            return false;
        }
        try {
            if (this.hwChan >= 0 && this.hwChan < 2 * this.cbc.getNumStrips()) {
                return true;
            }
        }
        catch (DriverException e) {
            this.log.error((Object)"Error getting number of strips");
            return false;
        }
        try {
            MonitorLogUtils.reportError((Logger)this.log, (String)this.getName(), (String)"HW channel", (Object)this.hwChan);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static int getHwVersion(Cabac cbc) {
        int version = cbc.getVersion();
        version = version == 0 ? 0 : (version == 1 ? 1 : -1);
        return version;
    }

    @Deprecated
    public int getHwVersion() {
        return this.hwVersion;
    }

    @ConfigurationParameterChanger
    public void setRd(int value) {
        this.rd = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Reset Drain voltage")
    public int getRd() {
        return this.rd;
    }

    @ConfigurationParameterChanger
    public void setOg(int value) {
        this.og = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Output Gate voltage")
    public int getOg() {
        return this.og;
    }

    @ConfigurationParameterChanger
    public void setGd(int value) {
        this.gd = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Guard Diode voltage")
    public int getGd() {
        return this.gd;
    }

    @ConfigurationParameterChanger
    public void setRgRise(int value) {
        this.rgRise = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Reset Gate rise current")
    public int getRgRise() {
        return this.rgRise;
    }

    @ConfigurationParameterChanger
    public void setRgFall(int value) {
        this.rgFall = value;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Reset Gate fall current")
    public int getRgFall() {
        return this.rgFall;
    }

    @ConfigurationParameterChanger
    public void setSclkRise(int[] value) {
        System.arraycopy(value, 0, this.sclkRise, 0, this.sclkRise.length);
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Serial Clock rise currents")
    public int[] getSclkRise() {
        return this.sclkRise;
    }

    @ConfigurationParameterChanger
    public void setSclkFall(int[] value) {
        System.arraycopy(value, 0, this.sclkFall, 0, this.sclkFall.length);
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Serial Clock fall currents")
    public int[] getSclkFall() {
        return this.sclkFall;
    }

    @ConfigurationParameterChanger
    public void setPclkRise(int[] value) {
        System.arraycopy(value, 0, this.pclkRise, 0, this.pclkRise.length);
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Parallel Clock rise currents")
    public int[] getPclkRise() {
        return this.pclkRise;
    }

    @ConfigurationParameterChanger
    public void setPclkFall(int[] value) {
        System.arraycopy(value, 0, this.pclkFall, 0, this.pclkFall.length);
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the Parallel Clock fall currents")
    public int[] getPclkFall() {
        return this.pclkFall;
    }

    @ConfigurationParameterChanger
    public void setOdRdo(int[] value) {
        System.arraycopy(value, 0, this.odRdo, 0, this.odRdo.length);
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the readout mode Output Drain voltages")
    public int[] getOdRdo() {
        return this.odRdo;
    }

    @ConfigurationParameterChanger
    public void setOdExp(int[] value) {
        System.arraycopy(value, 0, this.odExp, 0, this.odExp.length);
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the exposure mode Output Drain voltages")
    public int[] getOdExp() {
        return this.odExp;
    }

    void setConfig(CABAC cabac) {
        int[] values = cabac.getValues();
        SubsystemConfigurationEnvironment sce = this.getSubsystem().getSubsystemConfigurationEnvironment();
        String name = this.getName();
        sce.change(name, RD, (Object)values[0]);
        sce.change(name, OG, (Object)values[1]);
        sce.change(name, GD, (Object)values[2]);
        sce.change(name, RG_RISE, (Object)values[7]);
        sce.change(name, SCLK_RISE, (Object)new int[]{values[9], values[11], values[13]});
        sce.change(name, PCLK_RISE, (Object)new int[]{values[15], values[17], values[19], values[21]});
        if (this.version != 0) {
            sce.change(name, RG_FALL, (Object)values[8]);
            sce.change(name, SCLK_FALL, (Object)new int[]{values[10], values[12], values[14]});
            sce.change(name, PCLK_FALL, (Object)new int[]{values[16], values[18], values[20], values[22]});
        }
        sce.change(name, OD_RDO, (Object)new int[]{values[3], values[4]});
        sce.change(name, OD_EXP, (Object)new int[]{values[5], values[6]});
    }

    CABAC getConfig() {
        CABAC cabac = new CABAC();
        int[] values = cabac.getValues();
        values[0] = this.rd;
        values[1] = this.og;
        values[2] = this.gd;
        values[7] = this.rgRise;
        values[9] = this.sclkRise[0];
        values[11] = this.sclkRise[1];
        values[13] = this.sclkRise[2];
        values[15] = this.pclkRise[0];
        values[17] = this.pclkRise[1];
        values[19] = this.pclkRise[2];
        values[21] = this.pclkRise[3];
        if (this.version != 0) {
            values[8] = this.rgFall;
            values[10] = this.sclkFall[0];
            values[12] = this.sclkFall[1];
            values[14] = this.sclkFall[2];
            values[16] = this.pclkFall[0];
            values[18] = this.pclkFall[1];
            values[20] = this.pclkFall[2];
            values[22] = this.pclkFall[3];
        }
        values[3] = this.odRdo[0];
        values[4] = this.odRdo[1];
        values[5] = this.odExp[0];
        values[6] = this.odExp[1];
        return cabac;
    }

    int load() throws Exception {
        if (this.cbc.getVersion() == 0) {
            return 0;
        }
        try {
            int strips = 1 << this.hwChan / 2;
            int side = (this.hwChan & 1) == 0 ? 0 : 1;
            int[] data = this.getData();
            int[][] nArray = cfgFields;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] fields;
                for (int j : fields = nArray[i]) {
                    this.cbc.writeField(strips, 1 << side, j, data[j]);
                }
            }
            return 1;
        }
        catch (REBException e) {
            this.checkTimeout((Exception)((Object)e), RaftException.class);
            return 0;
        }
    }

    boolean getData(int index, int[] data) {
        if (index >= cfgFields.length) {
            return false;
        }
        int[] fields = cfgFields[index];
        int[] cData = this.getData();
        for (int j : fields) {
            data[j] = cData[j];
        }
        return true;
    }

    int check() throws Exception {
        if (this.cbc.getVersion() == 0) {
            return -1;
        }
        try {
            int mask = 0;
            int strips = 1 << this.hwChan / 2;
            int side = (this.hwChan & 1) == 0 ? 0 : 1;
            int[] data = this.getData();
            int[][] nArray = cfgFields;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] fields;
                for (int j : fields = nArray[i]) {
                    if (this.cbc.readField(strips, side, j)[0] == data[j]) continue;
                    mask |= 1 << j;
                }
            }
            return mask;
        }
        catch (REBException e) {
            this.checkTimeout((Exception)((Object)e), RaftException.class);
            return 0;
        }
    }

    int compare(int[] read) {
        int mask = 0;
        int[] config = this.getData();
        int[][] nArray = cfgFields;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int[] fields;
            for (int j : fields = nArray[i]) {
                if (read[j] == config[j]) continue;
                mask |= 1 << j;
            }
        }
        return mask;
    }

    private int[] getData() {
        int[] data = new int[22];
        data[0] = this.odExp[0];
        data[1] = this.odExp[1];
        data[2] = this.odRdo[0];
        data[3] = this.odRdo[1];
        if (this.version == 0) {
            data[4] = this.pclkRise[0];
            data[5] = this.pclkRise[1];
            data[6] = this.pclkRise[2];
            data[7] = this.pclkRise[3];
            data[8] = this.sclkRise[0];
            data[9] = this.sclkRise[1];
            data[10] = this.sclkRise[2];
            data[11] = this.rgRise;
        } else {
            data[4] = this.pclkRise[0] << 8 | this.pclkFall[0] & 0xFF;
            data[5] = this.pclkRise[1] << 8 | this.pclkFall[1] & 0xFF;
            data[6] = this.pclkRise[2] << 8 | this.pclkFall[2] & 0xFF;
            data[7] = this.pclkRise[3] << 8 | this.pclkFall[3] & 0xFF;
            data[8] = this.sclkRise[0] << 8 | this.sclkFall[0] & 0xFF;
            data[9] = this.sclkRise[1] << 8 | this.sclkFall[1] & 0xFF;
            data[10] = this.sclkRise[2] << 8 | this.sclkFall[2] & 0xFF;
            data[11] = this.rgRise << 8 | this.rgFall & 0xFF;
        }
        data[12] = this.gd;
        data[13] = this.og;
        data[14] = this.rd;
        return data;
    }
}

