/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.ui;

import java.io.File;
import java.io.PrintStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.rafts.data.ImageState;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;

public class RaftsConsole
implements StatusMessageListener {
    private static final Map<Integer, String> ptrTypeMap = new HashMap<Integer, String>();
    private static final PrintStream out;
    private static final int TIMEOUT = 10000;
    private final ConcurrentMessagingUtils ca;
    private String raftsSS = System.getProperty("org.lsst.ccs.rafts.name", "ccs-rafts");
    private int rebIndex = 0;

    public RaftsConsole() {
        new Agent("RaftsConsole", AgentInfo.AgentType.CONSOLE).startAgent();
        AgentMessagingLayer aml = Agent.getEnvironmentMessagingAccess();
        this.ca = new ConcurrentMessagingUtils(aml);
        aml.addStatusMessageListener((StatusMessageListener)this);
    }

    @Command(name="setreb", description="Set the default REB")
    public void setReb(@Argument(name="index", description="The index of the REB") int index) throws Exception {
        this.rebIndex = index;
        this.showReb();
    }

    @Command(name="showreb", description="Show the default REB")
    public void showReb() throws Exception {
        out.println("Default REB: " + this.getReb(this.rebIndex));
    }

    @Command(name="settarget", description="Set the target subsystem")
    public void setTarget(@Argument(name="subsys", description="The subsystem name") String subsys) throws Exception {
        this.raftsSS = subsys;
        this.showTarget();
    }

    @Command(name="showtarget", description="Show the target subsystem")
    public void showTarget() throws Exception {
        out.println("Target subsystem: " + this.raftsSS);
    }

    @Command(name="setregister", description="Set the value of a register")
    public void setRegister(@Argument(name="address", description="The register address") int address, @Argument(name="value", description="The value to set") int value) throws Exception {
        this.setRegister(this.rebIndex, address, value);
    }

    @Command(name="setregister", description="Set the value of a register")
    public void setRegister(@Argument(name="index", description="The index of the REB") int index, @Argument(name="address", description="The register address") int address, @Argument(name="value", description="The value to set") int value) throws Exception {
        int[] values = new int[]{value};
        this.sendCommand(this.getReb(index), "setRegister", address, values);
    }

    @Command(name="showregister", description="Show the values of registers")
    public void showRegister(@Argument(name="address", description="The first register address") int address, @Argument(name="count", description="The numberof registers to show") int count) throws Exception {
        this.showRegister(this.rebIndex, address, count);
    }

    @Command(name="showregister", description="Show the values of registers")
    public void showRegister(@Argument(name="index", description="The index of the REB") int index, @Argument(name="address", description="The first register address") int address, @Argument(name="count", description="The numberof registers to show") int count) throws Exception {
        out.println(this.sendCommand(this.getReb(index), "getRegister", address, count));
    }

    @Command(name="showdevices", description="Show all devices")
    public void showDevices() throws Exception {
        List devices = (List)this.sendCommand(null, "getDeviceNames", new Object[0]);
        if (devices.isEmpty()) {
            return;
        }
        out.print("Devices:");
        devices.stream().forEach(devc -> out.format(" %s", devc));
        out.println();
    }

    @Command(name="setvalue", description="Set a configured value")
    public void setValue(@Argument(name="chan", description="The qualified name of the channel") String chan, @Argument(name="value", description="The value to set") String value) throws Exception {
        String command;
        String[] wds = chan.split("\\.", 3);
        if (wds.length < 2) {
            throw new Exception("Channel name must be qualified with device name");
        }
        String field = wds[wds.length - 1];
        String channel = wds.length <= 2 ? wds[0] : wds[0] + "." + wds[1];
        Object resp = this.sendCommand(channel, command = "get" + field.substring(0, 1).toUpperCase() + field.substring(1), new Object[0]);
        String rType = resp.getClass().getName();
        if (!rType.startsWith("[")) {
            if (rType.endsWith("Integer")) {
                this.sendCommand(channel, "change", field, Integer.decode(value));
            } else if (rType.endsWith("Double")) {
                this.sendCommand(channel, "change", field, Double.valueOf(value));
            } else {
                this.sendCommand(channel, "change", field, value);
            }
        } else {
            wds = value.split(",");
            if (rType.endsWith("I")) {
                int[] iResp = (int[])resp;
                if (wds.length > iResp.length) {
                    throw new Exception("Too many array elements supplied");
                }
                for (int j = 0; j < wds.length; ++j) {
                    if (wds[j].equals("*")) continue;
                    iResp[j] = Integer.decode(wds[j]);
                }
                this.sendCommand(channel, "change", field, iResp);
            } else {
                double[] dResp = (double[])resp;
                if (wds.length > dResp.length) {
                    throw new Exception("Too many array elements supplied");
                }
                for (int j = 0; j < wds.length; ++j) {
                    if (wds[j].equals("*")) continue;
                    dResp[j] = Double.valueOf(wds[j]);
                }
                this.sendCommand(channel, "change", field, dResp);
            }
        }
    }

    @Command(name="showvalue", description="Show one or more configured values")
    public void showValue(@Argument(name="chan", description="The name of the device or channel") String chan) throws Exception {
        String channel;
        String[] wds = chan.split("\\.", 3);
        String field = wds.length == 1 ? "*" : wds[wds.length - 1];
        String string = channel = wds.length <= 2 ? wds[0] : wds[0] + "." + wds[1];
        if (field.equals("*") || field.length() == 0) {
            RaftsConsole.displayValues((Map)this.sendCommand(channel, "getConfigValues", new Object[0]));
        } else {
            String command = "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
            out.println("Value: " + RaftsConsole.getString(this.sendCommand(channel, command, new Object[0])));
        }
    }

    @Command(name="showvalue", description="Show all configured values")
    public void showValue() throws Exception {
        RaftsConsole.displayValues((Map)this.sendCommand(null, "getConfigValues", new Object[0]));
    }

    @Command(name="loaddac", description="Load all configured global DAC values")
    public void loadDac() throws Exception {
        this.sendCommand(this.getReb(this.rebIndex), "loadDacs", new Object[0]);
    }

    @Command(name="loadbias", description="Load all configured bias DAC values")
    public void loadBias() throws Exception {
        this.sendCommand(this.getReb(this.rebIndex), "loadBiasDacs", new Object[0]);
    }

    @Command(name="loadaspic", description="Load all configured ASPIC values")
    public void loadAspic() throws Exception {
        this.sendCommand(this.getReb(this.rebIndex), "loadAspics", new Object[0]);
    }

    @Command(name="checkaspic", description="Check all configured ASPIC values")
    public void checkAspic() throws Exception {
        List diff = (List)this.sendCommand(this.getReb(this.rebIndex), "checkAspics", new Object[0]);
        out.println("No. of differences: " + diff.size());
    }

    @Command(name="loadcabac", description="Load all configured CABAC values")
    public void loadCabac() throws Exception {
        this.sendCommand(this.getReb(this.rebIndex), "loadCabacs", new Object[0]);
    }

    @Command(name="checkcabac", description="Check all configured CABAC values")
    public void checkCabac() throws Exception {
        List diff = (List)this.sendCommand(this.getReb(this.rebIndex), "checkCabacs", new Object[0]);
        out.println("No. of differences: " + diff.size());
    }

    @Command(name="settime", description="Set the time to the Unix system time")
    public void setTime() throws Exception {
        this.sendCommand(null, "setTime", new Object[0]);
    }

    @Command(name="showtime", description="Show the current time on an REB")
    public void showTime(@Argument(name="index", description="The index of the REB") int index) throws Exception {
        String device = this.getReb(index);
        RaftsConsole.displayTime(device, (Long)this.sendCommand(device, "getTime", new Object[0]));
    }

    @Command(name="showtime", description="Show the current times on all REBs")
    public void showTime() throws Exception {
        List times = (List)this.sendCommand(null, "getTime", new Object[0]);
        for (int j = 0; j < times.size(); j += 2) {
            RaftsConsole.displayTime((String)times.get(j), (Long)times.get(j + 1));
        }
    }

    @Command(name="showtime", description="Show a trigger time on a REB")
    public void showTime(@Argument(name="index", description="The index of the REB") int index, @Argument(name="trigger", description="The name of the trigger") Trigger trigger) throws Exception {
        RaftsConsole.displayTime("Trigger", (Long)this.sendCommand(this.getReb(index), "getTime", trigger.name()));
    }

    @Command(name="checkxml", description="Check the sequencer code from a local XML file")
    public void checkXml(@Argument(name="file", description="The name of the file") String file) throws Throwable {
        this.getModel(file);
    }

    @Command(name="dumpxml", description="Dump the sequencer code from a local XML file")
    public void dumpXml(@Argument(name="file", description="The name of the file") String file) throws Throwable {
        FPGA2Model model = this.getModel(file);
        List<int[]> commands = model.getCommands();
        commands.stream().forEach(cmnd -> {
            for (int j = 0; j < ((int[])cmnd).length; ++j) {
                String fmt = j == 0 ? "%x" : (j == 1 ? " %2d" : " %4x");
                out.format(fmt, cmnd[j]);
            }
            out.println();
        });
    }

    @Command(name="loadsequencer", description="Load the sequencer from a remote file")
    public void loadSequencer(@Argument(name="file", description="The name of the file") String file) throws Exception {
        List slices = (List)this.sendCommand(null, "loadSequencer", file);
        out.print("Slice counts:");
        slices.stream().forEach(nSlice -> out.format(" %s", nSlice));
        out.println();
    }

    @Command(name="showmains", description="Show the sequencer main programs")
    public void showMains() throws Exception {
        List maps = (List)this.sendCommand(null, "getMainMap", new Object[0]);
        this.displayMaps("Mains", maps, Format.RAW);
    }

    @Command(name="showsubs", description="Show the sequencer subroutines")
    public void showSubroutines() throws Exception {
        List maps = (List)this.sendCommand(null, "getSubroutineMap", new Object[0]);
        this.displayMaps("Subroutines", maps, Format.RAW);
    }

    @Command(name="showfunctions", description="Show the sequencer functions")
    public void showFunctions() throws Exception {
        List maps = (List)this.sendCommand(null, "getFunctionMap", new Object[0]);
        this.displayMaps("Functions", maps, Format.RAW);
    }

    @Command(name="showpointers", description="Show the sequencer pointers")
    public void showPointers() throws Exception {
        this.showPointers(Format.POINTER);
    }

    @Command(name="showpointers", description="Show the sequencer pointers")
    public void showPointers(@Argument(name="format", description="Display format") Format format) throws Exception {
        List maps = (List)this.sendCommand(null, "getPointers", new Object[0]);
        this.displayMaps("Pointers", maps, format);
    }

    @Command(name="showparameter", description="Show a parameter value")
    public void showParameter(@Argument(name="name", description="Parameter name") String name) throws Exception {
        List values = (List)this.sendCommand(null, "getParameter", name);
        out.print("Parameter " + name + ":");
        values.stream().forEach(value -> out.format(" %s", value));
        out.println();
    }

    @Command(name="setparameter", description="Set a parameter value")
    public void setParameter(@Argument(name="name", description="Parameter name") String name, @Argument(name="value", description="The value to set") int value) throws Exception {
        this.sendCommand(null, "setParameter", name, value);
    }

    @Command(name="setsource", description="Set the sequencer data source")
    public void setSource(@Argument(name="value", description="The value to set") int value) throws Exception {
        this.sendCommand(null, "setDataSource", value);
    }

    @Command(name="startsequencer", description="Start the sequencer")
    public void startSequencer() throws Exception {
        this.sendCommand(null, "startSequencer", new Object[0]);
    }

    @Command(name="stopsequencer", description="Stop a sequencer loop")
    public void stopSequencer() throws Exception {
        this.sendCommand(null, "sendStop", new Object[0]);
    }

    @Command(name="stepsequencer", description="Step a sequencer loop")
    public void stepSequencer() throws Exception {
        this.sendCommand(null, "sendStep", new Object[0]);
    }

    @Command(name="saveimage", description="Save the raw image to a directory")
    public void saveImage(@Argument(name="dir", description="The name of the directory") String dir) throws Exception {
        this.sendCommand(null, "saveImage", dir);
    }

    @Command(name="saveimage", description="Save the raw image to the current directory")
    public void saveImage() throws Exception {
        this.saveImage("");
    }

    @Command(name="savefitsimage", description="Save the image in FITS format")
    public void saveFitsImage(@Argument(name="file", description="The name of the file") String file) throws Exception {
        this.sendCommand(null, "saveFitsImage", file);
    }

    @Command(name="dumpimage", description="Dump the contents of the current image")
    public void dumpImage(@Argument(name="offset", description="The offset to the first pixel") int offset, @Argument(name="size", description="The number of pixels") int size) throws Exception {
        out.println(this.sendCommand(this.getReb(this.rebIndex), "getImage", offset, size));
    }

    @Command(name="dumpimage", description="Dump the contents of a raw image file")
    public void dumpImage(@Argument(name="offset", description="The offset to the first pixel") int offset, @Argument(name="size", description="The number of pixels") int size, @Argument(name="file", description="The name of the file") String file) throws Exception {
        out.println(this.sendCommand(null, "getImage", file, offset, size));
    }

    @Command(name="showimagestats", description="Show the metadata for the current image")
    public void showImageStats() throws Exception {
        out.println(this.sendCommand(this.getReb(this.rebIndex), "getImageMetadata", new Object[0]));
    }

    @Command(name="showrebstats", description="Show the REB statistics data")
    public void showRebStats() throws Exception {
        out.println(this.sendCommand(this.getReb(this.rebIndex), "getRebStatus", new Object[0]));
    }

    @Command(name="saveconfig", description="Save the current configuration")
    public void saveConfiguration() throws Exception {
        this.sendCommand(null, "saveConfig", new Object[0]);
    }

    private Object sendCommand(String child, String func, Object ... args) throws Exception {
        String dest = this.raftsSS + (child == null || child.isEmpty() ? "" : "/" + child);
        CommandRequest cmd = new CommandRequest(dest, func, args);
        return this.ca.sendSynchronousCommand(cmd, Duration.ofMillis(10000L));
    }

    public void onStatusMessage(StatusMessage s) {
        if (!s.getOriginAgentInfo().getName().equals(this.raftsSS) || !(s instanceof StatusSubsystemData)) {
            return;
        }
        StatusSubsystemData sd = (StatusSubsystemData)s;
        if (!sd.getDataKey().equals("ImageState")) {
            return;
        }
        ImageState is = (ImageState)sd.getSubsystemData().getValue();
        out.format("Received image: timestamp = %016x, length = %s\n", is.getTimestamp(), is.getLength());
    }

    private String getReb(int index) throws Exception {
        List<String> devices = this.getRebs();
        for (String devc : devices) {
            if (index-- != 0) continue;
            return devc;
        }
        throw new Exception("REB index out of range");
    }

    private List<String> getRebs() throws Exception {
        return (List)this.sendCommand(null, "getREBDeviceNames", new Object[0]);
    }

    private static void displayTime(String desc, long time) {
        Date tm = new Date(time);
        out.format("%s time: %tY-%<tm-%<td %<tH:%<tM:%<tS.%<tL\n", desc, tm);
    }

    private static String getString(Object value) {
        String sValue;
        String vType = value.getClass().getName();
        if (!vType.startsWith("[")) {
            sValue = value.toString();
        } else if (vType.endsWith("I")) {
            int[] iValue = (int[])value;
            StringBuilder text = new StringBuilder("[");
            text.append(iValue[0]);
            for (int k = 1; k < iValue.length; ++k) {
                text.append(", ").append(iValue[k]);
            }
            text.append("]");
            sValue = text.toString();
        } else {
            double[] dValue = (double[])value;
            StringBuilder text = new StringBuilder("[");
            text.append(dValue[0]);
            for (int k = 1; k < dValue.length; ++k) {
                text.append(", ").append(dValue[k]);
            }
            text.append("]");
            sValue = text.toString();
        }
        return sValue;
    }

    private static void displayValues(Map<String, Object> values) {
        if (values.isEmpty()) {
            return;
        }
        out.print("Configured values:");
        int COL_SIZE = 39;
        int posn = COL_SIZE + 1;
        String fmt = "\n%-" + COL_SIZE + "s";
        for (String name : values.keySet()) {
            String item = String.format("  %-20s: %s", name, RaftsConsole.getString(values.get(name)));
            if (posn > COL_SIZE || posn + item.length() > 2 * COL_SIZE) {
                out.format(fmt, item);
                posn = item.length() > COL_SIZE ? item.length() : COL_SIZE;
                continue;
            }
            out.print(item);
            posn += item.length();
        }
        out.println();
    }

    private void displayMaps(String title, List<Map<String, Integer>> maps, Format format) throws Exception {
        for (int j = 0; j < maps.size(); ++j) {
            String head = this.getReb(j) + " " + title + ":";
            out.print(head);
            int leng = head.length();
            Map<String, Integer> map = maps.get(j);
            if (map == null || map.isEmpty()) {
                out.print(" None");
            } else {
                String pad = null;
                for (Map.Entry<String, Integer> e : map.entrySet()) {
                    String item;
                    if (format == Format.POINTER) {
                        int value = e.getValue();
                        item = " " + e.getKey() + "=" + ptrTypeMap.get(value >> 8) + ":" + (value & 0xFF);
                    } else {
                        item = " " + e.getKey() + "=" + e.getValue();
                    }
                    if (leng + item.length() > 80) {
                        out.println();
                        if (pad == null) {
                            char[] padC = new char[head.length()];
                            Arrays.fill(padC, ' ');
                            pad = new String(padC);
                        }
                        out.print(pad);
                        leng = pad.length();
                    }
                    out.print(item);
                    leng += item.length();
                }
            }
            out.println();
        }
    }

    private FPGA2Model getModel(String file) throws Throwable {
        try {
            return new FPGA2ModelBuilder().compileFile(new File(file));
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            throw t == null ? e : t;
        }
    }

    static {
        ptrTypeMap.put(0, "F");
        ptrTypeMap.put(2, "FR");
        ptrTypeMap.put(1, "S");
        ptrTypeMap.put(3, "SR");
        out = System.out;
    }

    public static enum Trigger {
        STAT,
        TIME,
        SEQ,
        TADC,
        PADC;

    }

    public static enum Format {
        RAW,
        POINTER;

    }
}

